/**
 *
 */
'use strict';
define(function() {
  var epanetexpCtrl = function(
    $scope,
    ConfigFactory,
    FeatureTypeFactory,
    ImportExportFactory,
    $filter
  ) {
    /**
     *    Définition des éléments de paramétrage par panneaux.
     */
    $scope.defineParameters = function() {
      //-- Liste des panneaux.
      $scope.params = [];

      //-- Panneau des paramètres généraux.
      $scope.defineGeneralParams();

      //-- Panneau de configuration de l'export des canalisations.
      $scope.definePipeParams();

      //-- Panneau de configuration de l'export des noeuds.
      $scope.defineNodeParams();

      //-- Panneau de configuration de l'export des réservoirs.
      $scope.defineReservoirParams();

      //-- Panneau de configuration de l'export des sources.
      $scope.defineSourceParams();

      $scope.showCstDefVal = true;
    };

    /**
     *    Récupére l'objet carte pour ultérieuremnt dessiner le cadre de la zone à exporter.
     */

    $scope.getMap = function(aScope) {
      if (aScope == null) return undefined;
      if (aScope.map != undefined) return aScope.map;
      else return $scope.getMap(aScope.$parent);
    };
    $scope.map = $scope.getMap($scope);

    $scope.setCurentViewAsExportZone = function() {
      var extent = $scope.map.getView().calculateExtent($scope.map.getSize());
      var coords = [];
      coords.push([extent[0], extent[1]]);
      coords.push([extent[0], extent[3]]);
      coords.push([extent[2], extent[3]]);
      coords.push([extent[2], extent[1]]);
      coords.push([extent[0], extent[1]]);
      $scope.params[0].fields[4].theRealField.geomvalue = coords;
      $scope.params[0].fields[4].theRealField.geomproj = $scope.map
        .getView()
        .getProjection()
        .getCode();
    };

    function addParamField(param, name, label, section, val, valtype) {
      param.fields.push({
        name: name,
        label: label,
        _value: val,
        valueType: valtype,
        section: section,
      });
    }

    function addParamField2(
      param,
      name,
      label,
      valtype,
      lyr,
      nvis,
      sdv,
      optional,
      ttia
    ) {
      param.fields.push({
        name: name,
        label: label,
        valueType: valtype,
        layer: lyr,
        notvisible: nvis,
        setdefaultvalue: sdv,
        isoptional: optional,
        totakeintoaccount: ttia,
      });
    }

    /**
     * ----  Configuration générale de l'export EPANET
     * ----
     * ----  * Nom du projet
     * ----  * Unité de débit
     * ----  * Formule de perte de charge
     * ----  * Ensemble des données à exporter
     */
    $scope.defineGeneralParams = function() {
      var param = {};
      param.title = 'aepepanetexp.GeneralParameters';
      param.name = 'general parameters';
      param.visible = true;
      $scope.currentpanelInd = 0;
      param.fields = [];
      param.fields.push({
        name: 'projet',
        label: 'aepepanetexp.ProjectName',
        name4file: 'Projet',
        valueType: 'String',
        _value: undefined,
        section: 'TITLE',
      });
      param.fields.push({
        name: 'flowrate',
        label: 'aepepanetexp.FlowRateUnit',
        section: 'OPTIONS',
        name4file: 'Units',
        _value: 'CFS',
        valueType: 'domain',
        values: [
          { label: 'aepepanetexp.cubicfeetsec', _value: 'CFS' },
          { label: 'aepepanetexp.gallonsmin', _value: 'GPM' },
          { label: 'aepepanetexp.milliongalday', _value: 'MGD' },
          { label: 'aepepanetexp.imperialMGD', _value: 'IMGD' },
          { label: 'aepepanetexp.acrefeetday', _value: 'AFD' },
          { label: 'aepepanetexp.literssec', _value: 'LPS' },
          { label: 'aepepanetexp.litermin', _value: 'LPM' },
          { label: 'aepepanetexp.megalitersday', _value: 'MLD' },
          { label: 'aepepanetexp.cubicmetershr', _value: 'CMH' },
          { label: 'aepepanetexp.cubicmetersday', _value: 'CMD' },
        ],
      });
      param.fields.push({
        name: 'loadlossformula',
        label: 'aepepanetexp.LoadLossFormula',
        section: 'OPTIONS',
        name4file: 'Headloss',
        _value: 'H-W',
        valueType: 'domain',
        values: [
          { label: 'aepepanetexp.hazenwilliams', _value: 'H-W' },
          { label: 'aepepanetexp.darcyweisbach', _value: 'D-W' },
          { label: 'aepepanetexp.chezymanning', _value: 'C-M' },
        ],
      });
      param.fields.push({
        name: '_areatoexport',
        label: 'aepepanetexp.AreaToExport',
        _value: 'definedarea',
        valueType: 'Options',
        options: [
          { label: 'aepepanetexp.database', _value: 'database' },
          {
            label: 'aepepanetexp.currentview',
            _value: 'currentview',
          },
          {
            label: 'aepepanetexp.specificarea',
            _value: 'definedarea',
          },
        ],
      });

      $scope.areadefvisible = {};
      $scope.definedarea01 = param.fields[param.fields.length - 1];
      $scope.$watch('definedarea01._value', function(newvalue) {
        if (newvalue == 'currentview') {
          // $scope.definedarea01 = "definedarea";
          $scope.setCurentViewAsExportZone();
          $scope.curview_onevent = $scope.map
            .getView()
            .on('propertychange', function(e) {
              $scope.setCurentViewAsExportZone();
            });
        }
        //$scope.map.getView().unByKey($scope.curview_onevent);
        else ol.Observable.unByKey($scope.curview_onevent);

        $scope.areadefvisible._value = newvalue == 'definedarea';
      });

      param.fields.push({
        name: 'areatoexportaspolygon',
        label: '',
        _value: '',
        valueType: 'area',
        visible: $scope.areadefvisible,
        theRealField: param.fields[param.fields.length - 1],
        tostore: false,
      });

      addParamField(param, 'Specific Gravity', '', 'OPTIONS', '1');
      addParamField(param, 'Viscosity', '', 'OPTIONS', '1', '');
      addParamField(param, 'Trials', '', 'OPTIONS', '40', '');
      addParamField(param, 'Accuracy', '', 'OPTIONS', '0.1', '');
      addParamField(param, 'CHECKFREQ', '', 'OPTIONS', '2', '');
      addParamField(param, 'MAXCHECK', '', 'OPTIONS', '10', '');
      addParamField(param, 'DAMPLIMIT', '', 'OPTIONS', '0', '');
      addParamField(param, 'Unbalanced', '', 'OPTIONS', 'Continue 10', '');
      addParamField(param, 'Pattern', '', 'OPTIONS', '1', '');
      addParamField(param, 'Demand Multiplier', '', 'OPTIONS', '1', '');
      addParamField(param, 'Emitter Exponent', '', 'OPTIONS', '0.5', '');
      addParamField(param, 'Quality', '', 'OPTIONS', 'None mg/l', '');
      addParamField(param, 'Diffusivity', '', 'OPTIONS', '1', '');

      $scope.params.push(param);
    };

    /**
     * ----  Configuration de l'export EPANET des canalisations.
     * ----
     * ----  * Choix du layer des canalisations
     * ----  * Champ identifiant du layer des canalisations
     * ----  * Champ diamétre du layer des canalisations
     * ----  * Champ rugosité du layer des canalisations
     * ----  * Champ statut du layer des canalisations
     * ----  * Case à cocher: faut il utiliser la valeur calculée la longueur des canalisation
     * ----  * Dans le cas où on n'utilise pas la valeur calculée de la longueur, indiquer le champ longueur
     */
    $scope.definePipeParams = function() {
      var param = {};
      param.title = 'aepepanetexp.PipeParameters';
      param.name = 'PIPES';
      param.visible = false;
      param.fields = [];
      param.fields.push({
        name: 'layer',
        label: 'aepepanetexp.Layer',
        valueType: 'LayerList',
        filter: 'onlyLineLayers',
        idprefix: 'P',
      });
      param.fields.push({
        name: 'ID',
        label: 'aepepanetexp.Identifier',
        valueType: 'LayerFields',
        layer: param.fields[0],
      });
      param.fields.push({
        name: '+calc+length',
        label: 'aepepanetexp.CalculateLength',
        valueType: 'CheckBox',
        _value: true,
        name4file: 'Length',
        replace: 'Length',
        params: [
          {
            name: 'decimal',
            label: 'Nombre de décimales',
            _value: 2,
          },
        ],
        showparams: false,
      });
      param.fields.push({
        name: 'Length',
        label: 'aepepanetexp.Length',
        valueType: 'LayerFields',
        notvisible: param.fields[2],
        layer: param.fields[0],
        notundefinedif: param.fields[2],
        params: [
          {
            name: 'decimal',
            label: 'Nombre de décimales',
            _value: 2,
          },
        ],
        showparams: false,
      });
      param.fields.push({
        name: 'Diameter',
        label: 'aepepanetexp.Diameter',
        maybeconstant: true,
        useconstant: false,
        valueType: 'LayerFields',
        layer: param.fields[0],
        setdefaultvalue: { constant: 0 },
        isoptional: true,
        totakeintoaccount: true,
      });
      param.fields.push({
        name: 'Roughness',
        label: 'aepepanetexp.Roughness',
        maybeconstant: true,
        useconstant: false,
        valueType: 'LayerFields',
        layer: param.fields[0],
        setdefaultvalue: {
          dependson: $scope.params[0].fields[2],
          valueson: { 'H-W': 110, 'D-W': 0.15, 'C-M': 0.015 },
        },
        isoptional: true,
        totakeintoaccount: true,
        addDefVal: true,
        showCstDefVal: false,
      });
      param.fields.push({
        name: 'Persing',
        label: '',
        valueType: '',
        setdefaultvalue: { constant: 0 },
        _value: '',
        isoptional: true,
        totakeintoaccount: false,
      });
      param.fields.push({
        name: 'Status',
        label: 'aepepanetexp.Status',
        valueType: 'LayerFields',
        layer: param.fields[0],
        isoptional: true,
        totakeintoaccount: true,
      });
      $scope.params.push(param);
    };

    /**
     * ----  Configuration de l'export EPANET des noeuds.
     * ----
     * ----  * Choix du layer des noeuds
     * ----  * Champ identifiant du layer des noeuds
     * ----  * Champ altitude du layer des noeuds
     * ----  * Champ consommation du layer des noeuds
     * ----  * Champ courbe modulation du layer des noeuds
     */
    $scope.defineNodeParams = function() {
      var param = {};
      param.title = 'aepepanetexp.NodeParameters';
      param.name = 'JUNCTIONS';
      param.visible = false;
      param.fields = [];
      param.fields.push({
        name: 'layer',
        label: 'aepepanetexp.Layer',
        valueType: 'LayerList',
        filter: 'onlyPointLayers',
        idprefix: 'J',
      });

      addParamField(
        param,
        '_create_nodes_automatically',
        'aepepanetexp.CreateNodesAutomatically',
        undefined,
        false,
        'CheckBox'
      );
      param.fields[0].notvisible = param.fields[1];

      addParamField(
        param,
        'ID',
        'aepepanetexp.Identifier',
        undefined,
        undefined,
        'LayerFields'
      );
      param.fields[2].layer = param.fields[0];
      param.fields[2].notvisible = param.fields[1];

      addParamField2(
        param,
        'Elev',
        'aepepanetexp.Elevation',
        'LayerFields',
        param.fields[0],
        param.fields[1],
        { constant: 0 },
        true,
        true
      );

      addParamField2(
        param,
        'Demand',
        'aepepanetexp.Demand',
        'LayerFields',
        param.fields[0],
        param.fields[1],
        { constant: 0 },
        true,
        true
      );

      addParamField2(
        param,
        'Pattern',
        'aepepanetexp.Pattern',
        'LayerFields',
        param.fields[0],
        param.fields[1],
        { constant: 0 },
        true,
        true
      );

      $scope.params.push(param);
    };

    /**
     * ----  Configuration de l'export EPANET des réservoirs.
     * ----
     * ----  * Choix du layer des réservoirs
     * ----  * Champ identifiant du layer des réservoirs
     * ----  * Champ altitude du layer des réservoirs
     * ----  * Champ consommation du layer des noeuds
     * ----  * Champ courbe modulation du layer des noeuds
     */
    $scope.defineReservoirParams = function() {
      var param = {};
      param.title = 'aepepanetexp.ReservoirParameters';
      param.name = 'TANKS';
      param.visible = false;
      param.fields = [];
      param.fields.push({
        name: 'layer',
        label: 'aepepanetexp.Layer',
        valueType: 'LayerList',
        filter: 'onlyPointLayers',
        idprefix: 'T',
      });
      param.fields.push({
        name: '_do_not_export',
        label: 'aepepanetexp.DoNotExport',
        valueType: 'CheckBox',
        _value: false,
      });

      param.fields[0].notvisible = param.fields[1];

      param.fields.push({
        name: 'ID',
        label: 'aepepanetexp.Identifier',
        valueType: 'LayerFields',
        layer: param.fields[0],
        notvisible: param.fields[1],
      });
      param.fields.push({
        name: 'Elevation',
        label: 'aepepanetexp.Elevation2',
        valueType: 'LayerFields',
        maybeconstant: true,
        useconstant: false,
        layer: param.fields[0],
        notvisible: param.fields[1],
        setdefaultvalue: { constant: 0 },
        isoptional: true,
        totakeintoaccount: true,
      });
      param.fields.push({
        name: 'Level Init',
        label: '',
        valueType: '',
        setdefaultvalue: { constant: 2 },
        _value: '',
        isoptional: true,
        totakeintoaccount: false,
      });
      param.fields.push({
        name: 'Level Min',
        label: '',
        valueType: '',
        setdefaultvalue: { constant: 0 },
        _value: '',
        isoptional: true,
        totakeintoaccount: false,
      });
      param.fields.push({
        name: 'Level Max',
        label: '',
        valueType: '',
        setdefaultvalue: { constant: 4 },
        _value: '',
        isoptional: true,
        totakeintoaccount: false,
      });
      param.fields.push({
        name: 'Diameter',
        label: '',
        valueType: '',
        setdefaultvalue: { constant: 20 },
        _value: '',
        isoptional: true,
        totakeintoaccount: false,
      });
      param.fields.push({
        name: 'Vol Min',
        label: '',
        valueType: '',
        setdefaultvalue: { constant: 0 },
        _value: '',
        isoptional: true,
        totakeintoaccount: false,
      });
      param.fields.push({
        name: 'Courbe Vol',
        label: '',
        valueType: '',
        setdefaultvalue: { constant: '' },
        _value: '',
        isoptional: true,
        totakeintoaccount: false,
      });
      $scope.params.push(param);
    };
    /**
     * ----  Configuration de l'export EPANET des sources.
     * ----
     * ----  * Choix du layer des sources
     * ----  * Champ identifiant du layer des sources
     * ----  * Champ altitude du layer des réservoirs
     * ----  * Champ consommation du layer des noeuds
     * ----  * Champ courbe modulation du layer des noeuds
     */
    $scope.defineSourceParams = function() {
      var param = {};
      param.title = 'aepepanetexp.SourceParameters';
      param.name = 'RESERVOIRS';
      param.visible = false;
      param.fields = [];
      param.fields.push({
        name: 'layer',
        label: 'aepepanetexp.Layer',
        valueType: 'LayerList',
        filter: 'onlyPointLayers',
        idprefix: 'S',
      });
      param.fields.push({
        name: '_do_not_export',
        label: 'aepepanetexp.DoNotExport',
        valueType: 'CheckBox',
        _value: false,
      });
      param.fields[0].notvisible = param.fields[1];
      param.fields.push({
        name: 'ID',
        label: 'aepepanetexp.Identifier',
        valueType: 'LayerFields',
        layer: param.fields[0],
        notvisible: param.fields[1],
      });
      param.fields.push({
        name: 'Head',
        label: 'aepepanetexp.Head',
        valueType: 'LayerFields',
        layer: param.fields[0],
        notvisible: param.fields[1],
        setdefaultvalue: { constant: 0 },
        isoptional: true,
        totakeintoaccount: true,
      });
      $scope.params.push(param);
    };

    $scope.nextPanelExists = function() {
      return $scope.currentpanelInd < $scope.params.length - 1;
    };
    $scope.prevPanelExists = function() {
      return $scope.currentpanelInd != 0;
    };

    $scope.panelFieldsOk = function(fields) {
      var ind;
      for (ind = 0; ind < fields.length; ind++)
        if (
          fields[ind].name == '_do_not_export' ||
          fields[ind].name == '_create_nodes_automatically'
        ) {
          if (fields[ind]._value) return true;
          break;
        }

      for (ind = 0; ind < fields.length; ind++) {
        fields[ind].notOk = false;
        //-- On dit que l'on veut une constante pour ce champ
        //-- mais elle n'est pas définie !!!
        if (
          (fields[ind].constantvalue == undefined ||
            fields[ind].constantvalue == '') &&
          fields[ind].useconstant &&
          fields[ind].totakeintoaccount
        ) {
          fields[ind].notOk = true;
          return false;
        }
        if (
          fields[ind]._value == undefined &&
          !fields[ind].useconstant &&
          fields[ind].totakeintoaccount
        )
          if (fields[ind].notundefinedif == undefined) {
            //-- La valeur doit être définie
            fields[ind].notOk = true;
            return false;
          }
          //-- La valeur peut ne pas être définie si une autre l'est
          else if (!fields[ind].notundefinedif._value) {
            fields[ind].notOk = true;
            return false;
          }
      }
      return true;
    };

    /**
     *      Retourne TRUE si tous les champs sont renseignés.
     */
    $scope.inputOk = function() {
      var fields = $scope.params[$scope.currentpanelInd].fields;
      return $scope.panelFieldsOk(fields);
    };

    $scope.allParametersAreOk = function() {
      var ip;

      for (ip = 0; ip < $scope.params.length; ip++) {
        if (!$scope.panelFieldsOk($scope.params[ip].fields)) return false;
      }
      return true;
    };

    $scope.getDefaultValue = function(field) {
      var sdv;

      sdv = field.setdefaultvalue;
      if (sdv == undefined) return undefined;
      if (sdv.constant != undefined) return sdv.constant;
      if (sdv.dependson != undefined) return sdv.valueson[sdv.dependson._value];

      return undefined;
    };

    $scope.saveParams = function() {
      var cfg, p, c, f, defval;
      cfg = [];

      for (var ind = 0; ind < $scope.params.length; ind++) {
        p = $scope.params[ind];
        c = {};
        c.name = p.name;
        c.fields = [];
        for (var ifield = 0; ifield < p.fields.length; ifield++) {
          if (p.fields[ifield].tostore !== false) {
            f = {};
            f.name = p.fields[ifield].name;
            if (p.fields[ifield].valueType == 'LayerList') {
              if (p.fields[ifield]._value != undefined)
                f._value = p.fields[ifield]._value.uid;
            } else f._value = p.fields[ifield]._value;
            if (p.fields[ifield].geomvalue != undefined) {
              f.geomvalue = p.fields[ifield].geomvalue;
              f.geomproj = p.fields[ifield].geomproj;
            }
            if (p.fields[ifield].section != undefined)
              f.section = p.fields[ifield].section;
            if (p.fields[ifield].name4file != undefined)
              f.name4file = p.fields[ifield].name4file;
            if (p.fields[ifield].replace != undefined)
              f.replace = p.fields[ifield].replace;
            if (p.fields[ifield].idprefix != undefined)
              f.idprefix = p.fields[ifield].idprefix;
            if (p.fields[ifield].systemidentifier) f._value = '__++sid++__';
            if (p.fields[ifield].params != undefined)
              f.params = p.fields[ifield].params;
            if (
              p.fields[ifield].useconstant &&
              p.fields[ifield].constantvalue != ''
            )
              f.constantvalue = p.fields[ifield].constantvalue;
            if (p.fields[ifield].totakeintoaccount != undefined)
              f.totakeintoaccount = p.fields[ifield].totakeintoaccount;
            if (p.fields[ifield].addDefVal != undefined)
              f.usedefval = p.fields[ifield].addDefVal;

            defval = $scope.getDefaultValue(p.fields[ifield]);
            if (defval != undefined) f.defaultvalue = defval;
            c.fields.push(f);
          }
        }
        cfg.push(c);
      }
      //          return ConfigFactory.add({"config":cfg},"AEP","EPANET");
      return ConfigFactory.add({ config: cfg }, 'AEP', $scope.ConfigName);
    };

    $scope.displayMessages = function(messages) {
      var ind, tmess, mess;

      if (messages == undefined) return;
      for (ind = 0; ind < messages.length; ind++) {
        tmess = messages[ind].split('__xx__');
        mess = $filter('translate')(tmess[1]);
        if (tmess[0] == 'ERROR') require('toastr').error(mess);
        else require('toastr').warning(mess);
      }
    };

    $scope.export = function() {
      $scope.waitExport = true;
      $scope.saveParams().then(function() {
        ImportExportFactory.epanetexport($scope.ConfigName).then(function(res) {
          $scope.waitExport = false;
          if (res.data != undefined && res.data.ok) {
            var downloadurl =
              '/services/'+localStorage.getItem('portal')+'/export/downloadexportedfile?f=json' +
              '&exportedFileId=' +
              res.data.exportedFile;
            window.open(downloadurl);
          }
          $scope.displayMessages(res.data.messages);
        });
      });
    };

    $scope.gotoNextPanel = function() {
      $scope.params[$scope.currentpanelInd].visible = false;
      $scope.params[++$scope.currentpanelInd].visible = true;
      $scope.saveParams();
    };

    $scope.gotoPreviousPanel = function() {
      $scope.params[$scope.currentpanelInd].visible = false;
      $scope.params[--$scope.currentpanelInd].visible = true;
      $scope.saveParams();
    };

    $scope.getPanel = function(panelName) {
      var ip;

      for (ip = 0; ip < $scope.params.length; ip++) {
        if ($scope.params[ip].name == panelName) return $scope.params[ip];
      }

      return undefined;
    };

    $scope.getFieldOfPanel = function(param, fieldName) {
      var ifield;

      for (ifield = 0; ifield < param.fields.length; ifield++) {
        if (param.fields[ifield].name == fieldName) return param.fields[ifield];
      }

      return undefined;
    };

    $scope.getLayerFieldValueFromUID = function(uid, field) {
      var lst, ind;

      lst = FeatureTypeFactory.resources.featuretypes;
      for (ind = 0; ind < lst.length; ind++) {
        if (lst[ind].uid == uid) {
          return FeatureTypeFactory.resources.featuretypes[ind];
        }
      }
    };

    //        ConfigFactory.get("AEP" , "EPANET" ).then(function(res)
    ConfigFactory.get('AEP', $scope.ConfigName).then(function(res) {
      var ind, resp, resf, p, f, ifield;

      if (res.data != undefined && res.data != '') {
        for (ind = 0; ind < res.data.config.length; ind++) {
          resp = res.data.config[ind];
          p = $scope.getPanel(resp.name);
          if (p != undefined) {
            for (ifield = 0; ifield < resp.fields.length; ifield++) {
              resf = resp.fields[ifield];
              f = $scope.getFieldOfPanel(p, resf.name);
              if (f != undefined) {
                if (f.valueType == 'LayerList')
                  f._value = $scope.getLayerFieldValueFromUID(resf._value);
                else f._value = resf._value;
                if (resf._value == '__++sid++__') f.systemidentifier = true;
                if (resf.geomvalue != undefined) {
                  f.geomvalue = resf.geomvalue;
                  f.geomproj = resf.geomproj;
                }
                if (resf.params != undefined) f.params = resf.params;
                if (resf.totakeintoaccount != undefined)
                  f.totakeintoaccount = resf.totakeintoaccount;
                if (resf.constantvalue != undefined) {
                  f.useconstant = true;
                  f.constantvalue = resf.constantvalue;
                } else f.useconstant = false;
              }
            }
          }
        }
      }
    });

    $scope.activateOrDeactivateCurViewFollower = function(event, data) {
      var param, f;

      for (var ip = 0; ip < $scope.params.length; ip++) {
        param = $scope.params[ip];
        if (param.name == 'general parameters') {
          for (var ifld = 0; ifld < param.fields.length; ifld++) {
            f = param.fields[ifld];
            if (f.name == '_areatoexport') {
              if (
                f._value == 'currentview' &&
                event.name == 'openTools_epanetexp'
              ) {
                $scope.setCurentViewAsExportZone();
                $scope.curview_onevent = $scope.map
                  .getView()
                  .on('propertychange', function(e) {
                    $scope.setCurentViewAsExportZone();
                  });
              }
              //$scope.map.getView().unByKey($scope.curview_onevent);
              else ol.Observable.unByKey($scope.curview_onevent);
              break;
            }
          }
          break;
        }
      }
    };

    $scope.$on(
      'openTools_epanetexp',
      $scope.activateOrDeactivateCurViewFollower
    );

    $scope.$on(
      'closeTools_epanetexp',
      $scope.activateOrDeactivateCurViewFollower
    );

    $scope.defineParameters();
    $scope.waitExport = false;
  };

  epanetexpCtrl.$inject = [
    '$scope',
    'ConfigFactory',
    'FeatureTypeFactory',
    'ImportExportFactory',
    '$filter',
  ];
  return epanetexpCtrl;
});
