'use strict';
define(function() {
  /**
   * DualListBox Directive
   * Provides two listBox with drag&drop functionnality
   */
  var checkList = function() {
    return {
      restrict: 'EA',
      scope: {
        cfg: '=',
      },
      link: function(scope) {
        // data must be an array
        if (!angular.isArray(scope.cfg.resources.data)) {
          return false;
        }

        /**
         * Check and applies the behavior specifie on the configuration object
         */
        scope.checkBehavior = function(index, checkPosition, behavior) {
          var list = scope.displayData.resources.data;

          if (!list[index].isChild) {
            // check un check all childs
            // todo : ugliest directive ever, do it again ! @RB to @RB
            list.forEach(function(d, i) {
              if (d.parentIndex == index) {
                list[i].checks[checkPosition] = !list[d.parentIndex].checks[
                  checkPosition
                ];
              }
            });
          }
          if (behavior) {
            switch (behavior) {
              case 'cancel_others':
                break;
            }
          }
        };

        scope.$watch(
          function() {
            return scope.cfg.resources.data;
          },
          function(data) {
            if (!data || data.length == 0) return;
            scope.displayData = angular.copy(scope.cfg);
            console.log(scope.displayData);
          },
          true
        );
      },
      templateUrl: 'js/XG/modules/common/views/directives/checkList.html',
    };
  };

  checkList.$inject = [];
  return checkList;
});
