'use strict';
define(() => {
  var jsonText = () => {
    return {
        restrict: 'A',
        require: 'ngModel',
        link: function(scope, element, attr, ngModel) {            
          let stringToJson = (input) => {
            try {
                return JSON.parse(input);
            } catch (error) {
                return input;
            }
            
          }
          let jsonToString = (data) => {
            try {
                return JSON.stringify(data);
            } catch (error) {
                return data;
            }
          }
          ngModel.$parsers.push(stringToJson);
          ngModel.$formatters.push(jsonToString);
        }
    };
  };
  return jsonText;
});
