'use strict';
define(function() {
  var tabbedform = function($timeout) {
    return {
      restrict: 'EA',
      scope: {
        validate: '=',
        tabs: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        var form = angular.element(elt[0]),
          submitButton = form.find('button[type=submit]')[0];

        /**
         * check every element of scope.validate
         * if its empty, switch to tab and add empty class
         */
        var checkRequiredElements = function(e) {
          if (angular.isArray(scope.validate) && scope.validate.length > 0) {
            scope.validate.forEach(function(v) {
              var value = v.key || '';
              if (value.trim() == '') {
                $timeout(function() {
                  scope.tabs.activeTab = 0;
                  form.addClass('incompleteForm');
                });
                return;
              }
            });
          }
        };

        if (submitButton) {
          if (submitButton.addEventListener) {
            submitButton.addEventListener(
              'click',
              checkRequiredElements,
              false
            ); //Modern browsers
          } else if (ele.attachEvent) {
            submitButton.attachEvent('onclick', checkRequiredElements); //Old IE
          }
        }
      },
    };
  };

  tabbedform.$inject = ['$timeout'];
  return tabbedform;
});
