'use strict';
define(function() {
  var kisGeocodageFactory = function($http, $rootScope) {
    var kisGeocodageFactory = {};

    /**
     * search
     * @param url
     * @param q
     * @param type
     * @returns {HttpPromise}
     */
    function search(url, q, type) {
      url = url?url:'https://api-adresse.data.gouv.fr';
      var url_address = url + '/search/?q=' + q;
      if (type && type != '') {
        url_address = url_address + '&type=' + type;
      }
      var promise = $http.get(url_address);
      return promise;
    }

    /**
     * reverse
     * @param url
     * @param coordinate
     * @returns {HttpPromise}
     */
    function reverse(url, coordinate) {
      var promise = $http.get(
        url + '/reverse/?lon=' + coordinate[0] + '&lat=' + coordinate[1]
      );
      return promise;
    }

    /**
     * Retrieve a geoCoderCfg configuration from it's id
     * if it doesnt exist (anymore), return false and toastr error
     * @param id
     * @return geoCoderCfg
     */
    function getGeocoderConfigFromId(id) {
      var geoCoderCfg = false,
        geocoders = $rootScope.xgos.portal.parameters.kisgeocodage;

      for (var i in geocoders) {
        if (geocoders[i].id == id) {
          geoCoderCfg = geocoders[i];
          break;
        }
      }

      return geoCoderCfg;
    }

    function getMarkerLayer() {
      var image = new ol.style.Circle({
        radius: 5,
        fill: null,
        stroke: new ol.style.Stroke({ color: 'red', width: 1 }),
      });
      var iconStyle = new ol.style.Style({
        image: new ol.style.Icon(
          /** @type {olx.style.IconOptions} */ ({
            anchor: [0.5, 1],
            anchorXUnits: 'fraction',
            anchorYUnits: 'fraction',
            opacity: 0.75,
            src: 'img/widget/adressLocation/marker.png',
          })
        ),
      });

      var styles = {
        Point: [iconStyle],
        LineString: [
          new ol.style.Style({
            fill: new ol.style.Fill({
              color: 'rgba(255,255,255,0.4)',
            }),
            stroke: new ol.style.Stroke({
              color: 'red',
              width: 2,
            }),
          }),
        ],
        MultiLineString: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'red',
              width: 1,
            }),
          }),
        ],
        MultiPoint: [
          new ol.style.Style({
            image: image,
          }),
        ],
        MultiPolygon: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'yellow',
              width: 1,
            }),
            fill: new ol.style.Fill({
              color: 'rgba(255, 255, 0, 0.1)',
            }),
          }),
        ],
        Polygon: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'blue',
              lineDash: [4],
              width: 3,
            }),
            fill: new ol.style.Fill({
              color: 'rgba(0, 0, 255, 0.7)',
            }),
          }),
        ],
        GeometryCollection: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'magenta',
              width: 2,
            }),
            fill: new ol.style.Fill({
              color: 'magenta',
            }),
            image: new ol.style.Circle({
              radius: 10,
              fill: null,
              stroke: new ol.style.Stroke({
                color: 'magenta',
              }),
            }),
          }),
        ],
        Circle: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'red',
              width: 2,
            }),
            fill: new ol.style.Fill({
              color: 'rgba(255,0,0,0.2)',
            }),
          }),
        ],
      };
      var styleFunction = function(feature, resolution) {
        return styles[feature.getGeometry().getType()];
      };

      var vectorSource = new ol.source.Vector({
        //create empty vector
      });
      return new ol.layer.Vector({
        source: vectorSource,
        style: styleFunction,
      });
    }

    return {
      kisGeocodageFactory: kisGeocodageFactory,
      search: search,
      reverse: reverse,
      getGeocoderConfigFromId: getGeocoderConfigFromId,
      getMarkerLayer: getMarkerLayer,
    };
  };
  kisGeocodageFactory.$inject = ['$http', '$rootScope'];
  return kisGeocodageFactory;
});
