'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    $translate,
    EditTypesFactory,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.verifZoneSaisie.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope, element, attrs, ctrl) {
        //scope.result = {};
        scope.rule.name = 'VerifZoneSaisie';
        scope.rule.type = 'OnEnd';

        //var editTypesSource = [EditTypesFactory.editTypes.add,EditTypesFactory.editTypes.update, EditTypesFactory.editTypes.updateattributes];

        var editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update,
        ];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        //Si phase de creation
        if (scope.rule.parameters == undefined) {
          scope.rule.parameters = {};
        }

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function() {
            scope.featureTypes = angular.copy(
              FeatureTypeFactory.resources.featuretypes
            );
          });
        } else {
          scope.featureTypes = angular.copy(
            FeatureTypeFactory.resources.featuretypes
          );
        }
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    '$translate',
    'EditTypesFactory',
    'RuleCfgFactory',
  ];
  return gcelement;
});
