'use strict';
define(function() {
  var DocumentFactory = function($http) {
    var DocumentFactory = {};
    /**
     * Class : DocumentFactory
     * Factory WebServices
     */

    /**
     * Function: getlisttemplate
     */
    function getlisttemplate() {
      var promise = $http.get(
        '/services/{portalid}/documents/getlisttemplate?f=json'
      );

      return promise;
    }
    /**
     * Function: downloaddocx
     */
    function downloaddocx(name) {
      var promise = $http.get(
        '/services/{portalid}/documents/downloaddocx?f=json' + '&name=' + name
      );

      return promise;
    }
    /**
     * Function: generatedocx
     */
    function generatedocx(senddata, name, feature_id, pdf,srid) {
      var lang = localStorage.getItem('current_language');
      if (!lang) lang = 'fr';
      if (angular.isUndefined(pdf)) pdf = false;
      var promise = $http.post(
        '/services/{portalid}/documents/generatedocx?f=json' +
          '&name=' +
          name +
          '&feature_id=' +
          feature_id +
          '&lang=' +
          lang +
          '&pdf=' +
          pdf  +
          '&srid=' +
          srid,
        senddata
      );

      return promise;
    }
    /**
     * Function: removeuploaded
     */
    function removeuploaded(fileName) {
      var promise = $http.get(
        '/services/{portalid}/documents/removeuploaded?f=json' +
          '&fileName=' +
          fileName
      );

      return promise;
    }
    /**
     * Function: uploadprocess
     */
    function uploadprocess(senddata) {
      var promise = $http.post(
        '/services/{portalid}/documents/uploadfile?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: uploadfile
     */
    function uploadfile(senddata) {
      var promise = $http.post(
        '/services/{portalid}/documents//upload?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: downloadtemplate
     */
    function downloadtemplate(name) {
      var promise = $http.get(
        '/services/{portalid}/documents/downloadtemplate?f=json' +
          '&name=' +
          name
      );

      return promise;
    }
    /**
     * Function: generatemultipledocx
     */
    function generatemultipledocx(senddata, name, feature_id,srid) {
      var lang = localStorage.getItem('current_language');
      if (!lang) lang = 'fr';
      var promise = $http.post(
        '/services/{portalid}/documents/generateMultipleDocx?f=json' +
          '&name=' + name +
          '&feature_id=' + feature_id +
          '&lang=' + lang +
          '&srid=' + srid,
        senddata
      );

      return promise;
    }

    /**
     * Function: generatemultipledocx
     */
    function getgeneratedzip(filename) {
      var promise = $http.get(
        '/services/{portalid}/documents/getgeneratedzip?f=json' +
          '&filename=' +
          filename
      );

      return promise;
    }

    return {
      DocumentFactory: DocumentFactory,
      getlisttemplate: getlisttemplate,
      downloaddocx: downloaddocx,
      generatedocx: generatedocx,
      generatemultipledocx: generatemultipledocx,
      removeuploaded: removeuploaded,
      uploadprocess: uploadprocess,
      uploadfile: uploadfile,
      getgeneratedzip: getgeneratedzip,
      downloadtemplate: downloadtemplate,
    };
  };
  DocumentFactory.$inject = ['$http'];
  return DocumentFactory;
});
