'use strict';
define(function() {
  var GroupFactory = function($http) {
    var GroupFactory = {};
    /**
     * Class : GroupFactory
     * Factory WebServices
     */

    var resources = {
      groupsLight : []
    };

    /**
     * Function: add
     */
    function add(senddata) {
      var promise = $http.post(
        '/services/{portalid}/rights/group/add?f=json',
        senddata
      );
      promise.then(function(res) {
        resources.groupsLight.push(res.data);
      });
      return promise;
    }

    /**
     * Function: remove
     */
    function remove(id) {
      var promise = $http.get(
        '/services/{portalid}/rights/group/remove?f=json' + '&id=' + id
      );
      promise.then(function() {
        var deleteIndex = resources.groupsLight
          .map(function(x) {
            return x.uid;
          })
          .indexOf(id);
          resources.groupsLight.splice(deleteIndex, 1);
      });
      return promise;
    }

    /**
     * Function: update
     */
    function update(senddata) {
      var promise = $http.post(
        '/services/{portalid}/rights/group/update?f=json',
        senddata
      );
      promise.then(function(res) {
        // New index of the updated group
        let replaceIndex = resources.groupsLight
          .map((x) => {return x.uid;})
          .indexOf(senddata.uid);
          resources.groupsLight[replaceIndex] = res.data;
      });
      return promise;
    }

    /**
     * Function: get
     */
    function get(lightRoles) {
      var promise = $http.get('/services/{portalid}/rights/group/get?f=json&lightRoles=' + !!lightRoles);
      promise.then(function(res) {
          resources.groupsLight = res.data;
      });
      return promise;
    }

    return {
      GroupFactory: GroupFactory,
      resources: resources,
      add: add,
      remove: remove,
      update: update,
      get: get,
    };
  };
  GroupFactory.$inject = ['$http'];
  return GroupFactory;
});
