'use strict';

/**
 * @ngdoc controller
 * @name modules.authentication.controller:AtlasCtrl
 * @description
 * The AtlasCtrl controller
 */
define(function() {
  var AtlasCtrl = function($scope, ngDialog, AtlasFactory, PortalsFactory, $filter) {
    AtlasFactory.getconf().then(
      function(res) {
        if (res.data.etat === 'fini') {
          $scope.currentResources = getTranslatedModelsType(res.data.data);
          AtlasFactory.setAtlas(res.data.data);
        } else {
          console.info('no config');
        }
      },
      function() {
        console.info('no config');
      }
    );

    PortalsFactory.get().then(res => {
      const appPortal = res.data.find(portal => portal.uid === PortalsFactory.getPortalId());
      if (
        appPortal.parameters.arcgis &&
        appPortal.parameters.arcgis.host &&
        appPortal.parameters.arcgis.password &&
        appPortal.parameters.arcgis.username
      ) {
        $scope.enabledArcGis = true;
      }
    });
    $scope.addAtlas = function() {
      $scope.editMode = 'add';
      $scope.edit_resource = { 
        id: Math.floor(Math.random() * 1000000), 
        type: 'kis' , 
        pagedegarde : { $selected: true } , 
        pagedefin : { $selected: true }
      };
      $scope.currentAtlasRessource = angular.copy($scope.edit_resource);
      ngDialog.open({
        template: 'js/XG/modules/tools/views/modals/modal.atlas.html',
        className: 'ngdialog-theme-plain width1000',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.updateAtlas = function() {
      $scope.editMode = 'update';
      $scope.currentAtlasRessource = angular.copy($scope.edit_resource);
      $scope.currentAtlasRessource.type = $scope.currentAtlasRessource.type || 'kis';
      ngDialog.open({
        template: 'js/XG/modules/tools/views/modals/modal.atlas.html',
        className: 'ngdialog-theme-plain width1000',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.removeAtlas = function() {
      $scope.currentResources.splice($scope.selected_resource_index, 1);
      AtlasFactory.saveconf($scope.currentResources).then(function(res) {
        if (res.data.etat === 'fini') {
          AtlasFactory.setAtlas($scope.currentResources);
          console.info('suppression success');
        } else {
          console.info('no config');
        }
      });
    };

    $scope.addAtlasInList = function(currentAtlasRessource) {
      if (angular.isUndefined($scope.currentResources))
        $scope.currentResources = [];
      switch ($scope.editMode) {
        case 'add':
          $scope.currentResources.push(getTranslatedModelsType([currentAtlasRessource])[0]);
          break;
        case 'update':
          for (var i = 0; i < $scope.currentResources.length; i++) {
            if ($scope.currentResources[i].id === currentAtlasRessource.id) {
              $scope.currentResources[i] = angular.copy(currentAtlasRessource);
              break;
            }
          }
          break;
      }
      AtlasFactory.saveconf($scope.currentResources).then(function(res) {
        if (res.data.etat === 'fini') {
          refreshList();
          console.info('success save atlas globales');
        } else {
          console.info('no config');
        }
      });
      return true;
    };

    $scope.refreshDocumentsList = function() {
      refreshList();
    };

    $scope.editListCfg = {
      dataModule: 'tools',
      resource_type: 'atlas',
      cols: ['name', 'printModel'],
      addFunction: $scope.addAtlas,
      editFunction: $scope.updateAtlas,
      removeFunction: $scope.removeAtlas,
    };

    /**
     * [refreshList description]
     * @return {[type]} [description]
     */
    var refreshList = function() {
      $scope.currentResources = [];
      AtlasFactory.getconf().then(
        function(res) {
          if (res.data.etat === 'fini') {
            $scope.currentResources = res.data.data;
            AtlasFactory.setAtlas(res.data.data);
          } else {
            console.info('no config');
          }
        },
        function() {
          console.info('no config');
        }
      );
    };
    function getTranslatedModelsType(models = []) {
      return models.map(model => {
        let translationKey = model.type === 'arcgis' ? 'model_arcgis' : 'model_kis';
        model.translatedType = $filter('translate')('tools.atlas.' + translationKey);
        return model;
      })
    }
  };

  AtlasCtrl.$inject = ['$scope', 'ngDialog', 'AtlasFactory', 'PortalsFactory', '$filter'];
  return AtlasCtrl;
});
