'use strict';
define(function() {
  var ancElementsFacturation = function(
    AncAppFactory,
    BacAppFactory,
    $filter,
    $sce,
    ngDialog,
    OmegaFactory,
    gaDomUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_elements_facturation.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
        periodesCfg: '=',
        periodeFilter: '=',
        crudElement: '&?',
      },
      link: function(scope, elt, attrs, ctrl) {
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;
        scope.controletype = CurrentAppFactory.appCfg.main.controleCfg;

        for (var i in scope.periodesCfg.tarification) {
          scope.periodesCfg.tarification[i].tva = parseFloat(
            scope.periodesCfg.tarification[i].tva
          );
        }

        scope.isOmegaFactu = false;
        if (
          CurrentAppFactory.appCfg.main.properties.dolibarr.facturationTierce
            .active &&
          CurrentAppFactory.appCfg.main.properties.dolibarr.facturationTierce
            .interface.type == 'omega'
        ) {
          scope.isOmegaFactu = true;
        }
        /**
         * retrieve Data Periode
         * 
         * @param {*} key 
         * @returns 
         */
        scope.retrieveDataPeriode = (key) => {
          var value = '';
          for (var i in scope.periodesCfg.periodes) {
            var p = scope.periodesCfg.periodes[i];
            if (p.key == key) {
              p.nom = p.nom || '';
              value =
                "<div style='font-weight: 600;'>" +
                p.nom +
                '</div><small> ' +
                $filter('date')(p.debut) +
                ' - ' +
                $filter('date')(p.fin) +
                '</small>';
            }
          }
          return $sce.trustAsHtml(value);
        };

        let periodeFacturationDialog, choixPeriodeDialog, pfid;
        scope.currElementFactu = {};
        scope.createPeriodeFacturationDialog = () => {
          const periodeFacturation = scope.getTarificationByPeriode(
            scope.periodeFilter
          );
          let ans = false;
          if (
            scope.periodesCfg.periodes &&
            scope.periodesCfg.periodes.length > 1 &&
            (!periodeFacturation || periodeFacturation.length == 0)
          ) {
            ans = confirm(
              "Voulez-vous copier les services d'une période précédente ? ."
            );
            if (ans) {
              scope.dupliquerFacturation = true;
              scope.dupliquerTemplate = false;
              choixPeriodeDialog = ngDialog.open({
                template:
                  'js/XG/widgets/ancapp/main/views/modals/modal.choixPeriode.html',
                className: 'ngdialog-theme-plain width1000 miniclose nopadding',
                closeByDocument: false,
                scope: scope,
              });
            } else {
              pfid = -1;
              scope.currElementFactu = {
                tva: 0,
                prix: 0,
                periode: angular.copy(scope.periodeFilter),
              };
            }
          } else {
            pfid = -1;
            scope.currElementFactu = {
              tva: 0,
              prix: 0,
              periode: angular.copy(scope.periodeFilter),
            };
          }
          if (!ans) {
            if (
              scope.periodesCfg.periodes &&
              scope.periodesCfg.periodes.length == 1 &&
              !scope.currElementFactu.periode
            ) {
              pfid = -1;
              scope.currElementFactu = {
                tva: 0,
                prix: 0,
                periode: angular.copy(scope.periodeFilter),
              };
            }
            periodeFacturationDialog = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.element.facturation.html',
              className: 'ngdialog-theme-plain width1000 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
            });
          }
        };
        scope.editPeriodeFacturationDialog = (index) => {
          pfid = index;
          scope.currElementFactu = scope.periodesCfg.tarification[index];
          periodeFacturationDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.element.facturation.html',
            className: 'ngdialog-theme-plain width1000 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
          if (!tarificationACopier || tarificationACopier.length == 0) {
            require('toastr').warning(
              $filter('translate')('facturation.serviceVide')
            );
          } else {
            tarificationACopier.forEach(function (element) {
              scope.periodesCfg.tarification.push(element);
            });
          }
          choixPeriodeDialog.close();
        };

        /**
         * getTarificationByPeriode
         *
         * @param {*} period
         */
        scope.getTarificationByPeriode = function (period) {
          return scope.periodesCfg.tarification.filter(
            (tarif) => tarif.periode == period
          );
        };

        /***************************************
         * get Periode name
         *
         * @param {*} period
         ***************************************/
        scope.getPeriodeName = (period) => {
          return scope.periodesCfg.periodes.filter(
            (periode) => periode.key == period
          )[0].nom;
        };
        /**
         * copier la Tarification depuis une confihuration ancienne
         *
         * @param {*} periodeChoisiKey
         */
        scope.copierTarification = (periodeChoisiKey) => {
          let tarificationACopier = [];
          const periodeNom = scope.getPeriodeName(scope.periodeFilter);
          scope.periodesCfg.tarification.forEach(function (element) {
            if (element.periode == periodeChoisiKey) {
              let newTarification = angular.copy(element);
              newTarification.periode = angular.copy(scope.periodeFilter);
              newTarification.nom = periodeNom + ' ' + newTarification.nom;
              tarificationACopier.push(newTarification);
              scope.savePeriodeFacturation(newTarification);
            }
          });
          if (!tarificationACopier || tarificationACopier.length == 0) {
            require('toastr').warning(
              $filter('translate')('facturation.serviceVide')
            );
          }
          choixPeriodeDialog.close();
        };
        /**
         * Importer les articles depuis Omega
         *
         * @returns
         */
        scope.importArticlesOmega = () => {
          if (
            !confirm(
              'Êtes-vous certain de vouloir remplacer la liste des articles ?'
            )
          )
            return;
          gaDomUtils.showGlobalLoader();
          OmegaFactory.getlistearticles().then(
            function (res) {
              gaDomUtils.hideGlobalLoader();
              if (!res.data) {
                alert("Impossible d'obtenir la liste des articles.");
                return;
              }

              var tarifs = res.data.map(function (x) {
                return {
                  tva: x.codeTva,
                  prix: x.prixUnitaire,
                  periode: angular.copy(scope.periodeFilter),
                  nom: x.libelle,
                  identifiant: x.code,
                  description: x.libelle,
                  dolibarrId: 'omegaid_' + x.id,
                };
              });

              scope.periodesCfg.tarification = tarifs;
            },
            function () {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                'Impossible de récupérer la liste des articles omega.'
              );
            }
          );
        };

        /**
         * save de la Periode de Facturation
         * 
         * @param {*} newTarification 
         */
        scope.savePeriodeFacturation = (newTarification = undefined) => {
          scope.crudElement({
            element: newTarification == undefined
              ? angular.copy(scope.currElementFactu)
              : angular.copy(newTarification),
            id: pfid ? pfid : -1,
            dialog: periodeFacturationDialog,
          });
        };

        /**
         * supression de la Periode de Facturation
         * 
         * @param {*} newTarification 
         */
        scope.supprimerFacturationPeriode = (index) => {
          var r = confirm(
            'Êtes-vous certain de vouloir supprimer cet élément ?'
          );
          if (r == true) {
            scope.periodesCfg.tarification.splice(index, 1);
          }
        };

         /**
         * Filtre de la liste des elements de facturation via filtre de periode eventuel 
         * 
         * @param {*} c 
         * @returns 
         */
         scope.byPeriodeFilter = (c) => {
          return (
            !angular.isDefined(scope.periodeFilter) ||
            scope.periodeFilter == c.periode
          );
        };
      },
    };
  };

  ancElementsFacturation.$inject = [
    'AncAppFactory',
    'BacAppFactory',
    '$filter',
    '$sce',
    'ngDialog',
    'OmegaFactory',
    'gaDomUtils',
  ];
  return ancElementsFacturation;
});
