'use strict';
define(function() {
  var bacVisite = function(
    BacAppFactory,
    ngDialog,
    $filter,
    FeatureTypeFactory,
    QueryFactory,
    $rootScope
  ) {
    return {
      templateUrl: 'js/XG/widgets/bacapp/main/views/directives/bac_operis.html',
      restrict: 'EA',
      scope: {
        cdata: '=',
        ctrlClos: '=',
        currentReport: '=?',
        boundDdc: '=?',
      },
      link: {
        pre: function(scope, elt, attrs, ctrl) {
          scope.operisCfg = BacAppFactory.appCfg.main.ddc;
          scope.parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            BacAppFactory.appCfg.main.datastore,
            BacAppFactory.appCfg.main.parcellesCfg.emplacement
          );
        },
        post: function(scope, elt, attrs, ctrl) {
          var getParcelleInfo = function() {
            scope.detailsParcelles = [];

            if (
              angular.isDefined(
                scope.currentReport.properties.parcelleHabitation
              )
            ) {
              scope.currentReport.properties.parcelleHabitation.forEach(
                function(parcelle) {
                  QueryFactory.get(scope.parcellesFti.uid, parcelle.id).then(
                    function(res) {
                      if (res.data)
                        scope.detailsParcelles.push(res.data.features[0]);
                    }
                  );
                }
              );
            }
          };

          var createWhere = function(idx) {
            var where = '';
            scope.operisCfg.where.forEach(function(arg) {
              where += scope.detailsParcelles[idx].properties[arg];
            });
            return where;
          };

          getParcelleInfo();

          var folderListOperisDialog;
          var folderListDatatableDialog;
          scope.openDDCDialog = function() {
            scope.listDossiersInstruits = [];

            if (
              angular.isDefined(scope.detailsParcelles) &&
              scope.detailsParcelles.length > 0
            ) {
              scope.detailsParcelles.forEach(function(parcelle, idx) {
                var getWhere = createWhere(idx);

                var where =
                  scope.operisCfg.parcelle.attribut + "='" + getWhere + "'";
                QueryFactory.data(scope.operisCfg.parcelle.feature, where).then(
                  function(res) {
                    if (res.data.features.length) {
                      res.data.features.forEach(function(feat) {
                        where =
                          scope.operisCfg.dossier.attribut +
                          "='" +
                          feat.properties[scope.operisCfg.dossier.attribut] +
                          "'";

                        QueryFactory.data(
                          scope.operisCfg.dossier.feature,
                          where
                        ).then(function(res) {
                          if (res.data)
                            scope.listDossiersInstruits.push(
                              res.data.features[0]
                            );
                        });
                      });
                    }
                  }
                );
              });

              folderListOperisDialog = ngDialog.open({
                template:
                  'js/XG/widgets/bacapp/main/views/modals/modal.operis.liste_dossiers.html',
                className: 'ngdialog-theme-plain width800 miniclose nopadding',
                closeByDocument: false,
                scope: scope,
              });
            } else {
              scope.dossierOperis = FeatureTypeFactory.getFeatureByUid(
                scope.operisCfg.dossier.feature
              );
              folderListDatatableDialog = ngDialog.open({
                template:
                  'js/XG/widgets/bacapp/main/views/modals/modal.operis.datatable.html',
                className: 'ngdialog-theme-plain width1000 miniclose nopadding',
                closeByDocument: false,
                scope: scope,
              });
            }
          };

          scope.addSelectedDossier = function(dossiers) {
            if (angular.isDefined(dossiers)) {
              var id_dossier = [];

              dossiers.forEach(function(dossier) {
                if (dossier.properties.NOMDOSSIER.length)
                  id_dossier.push({
                    nom: dossier.properties.NOMDOSSIER,
                    id_dossier: dossier.properties.ID_DOSSIER,
                  });
              });

              $rootScope.$broadcast('addDDCDossierToControle', id_dossier);

              if (angular.isDefined(folderListDatatableDialog))
                folderListDatatableDialog.close();
            }
          };

          scope.reinitDDC = function() {
            var ans = confirm(
              'Etes-vous sur de vouloir supprimer les dossiers DDC du contrôle ?'
            );

            if (ans) {
              $rootScope.$broadcast('addDDCDossierToControle', {
                reInit: true,
              });
            }
          };

          var infosDossierDDC;
          scope.openDialogDossier = function(dossier) {
            scope.infosDossier = dossier;
            infosDossierDDC = ngDialog.open({
              template:
                'js/XG/widgets/bacapp/main/views/modals/modal.operis.detail_dossier.html',
              className: 'ngdialog-theme-plain width800 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
            });
          };

          scope.openOperis = function() {
            var win = window.open(scope.operisCfg.url, '_blank');
            win.focus();
          };

          scope.transformDate = function(date) {
            var renderedDate = null;
            if (angular.isDefined(date) && date != null)
              renderedDate = $filter('date')(date, 'dd-MM-yyyy');
            return renderedDate;
          };

          scope.$on('openDDCDossier', function(event, data) {
            if (data) {
              var dossier;
              var where = scope.operisCfg.dossier.attribut + "='" + data + "'";

              QueryFactory.data(scope.operisCfg.dossier.feature, where).then(
                function(res) {
                  if (res.data) dossier = res.data.features[0];
                  scope.openDialogDossier(dossier);
                }
              );
            }
          });

          scope.pushDataToControle = function() {
            var ans = confirm(
              "Êtes-vous sur de vouloir récupérer les données issues de DDC ? Cela remplacera les valeurs déjà saisies au sein de l'instruction"
            );
            if (ans) {
              scope.ddc = {};
              scope.ddc.demandeur = {};

              Object.keys(scope.infosDossier.properties).forEach(function(
                prop
              ) {
                switch (prop) {
                  case 'DATEDECISION':
                    scope.ddc.date_decision =
                      scope.infosDossier.properties[prop];
                    break;
                  case 'DEMANDEUR':
                    scope.ddc.demandeur.prenom =
                      scope.infosDossier.properties[prop];
                    break;
                  case 'DATEDEPOT':
                    scope.ddc.date_demande =
                      scope.infosDossier.properties[prop];
                    break;
                  case 'NATUREDECISION':
                    scope.ddc.nature_decision =
                      scope.infosDossier.properties[prop];
                    break;
                  case 'REPRESENTANT':
                    scope.ddc.representant =
                      scope.infosDossier.properties[prop];
                    break;
                  case 'NATURETRAVAUX':
                    scope.ddc.nature_travaux =
                      scope.infosDossier.properties[prop];
                    break;
                  case 'SHON':
                    scope.ddc.surface_plancher =
                      scope.infosDossier.properties[prop];
                    break;
                  case 'DESCRIPTION':
                    scope.ddc.objet = scope.infosDossier.properties[prop];
                    break;
                  case 'DESTINATION':
                    scope.ddc.destination = scope.infosDossier.properties[prop];
                    break;
                  case 'DATEDOC':
                    scope.ddc.date_ouverture_chantier =
                      scope.infosDossier.properties[prop];
                    break;
                  case 'SURFACE':
                    scope.ddc.surface_terrain =
                      scope.infosDossier.properties[prop];
                    break;
                  case 'DATEDAT':
                    scope.ddc.date_achevement_travaux =
                      scope.infosDossier.properties[prop];
                    break;
                }
              });

              $rootScope.$broadcast('pushDDCInfoToControle', scope.ddc);
              infosDossierDDC.close();
            }
          };
        },
      },
    };
  };

  bacVisite.$inject = [
    'BacAppFactory',
    'ngDialog',
    '$filter',
    'FeatureTypeFactory',
    'QueryFactory',
    '$rootScope',
  ];
  return bacVisite;
});
