'use strict';
define(function() {
  var ImportMappingHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/import_mapping_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        if (angular.isUndefined(scope.isModule)) scope.isModule = true;

        scope.hpo = {
          uploadProcessID: undefined,
          importedFeatures: [],
          dropzoneComponent: undefined,
        };

        scope.tabs = [
          {
            title: $filter('translate')('hpo.data.exchange.import'),
          },
          {
            title: $filter('translate')('hpo.data.exchange.mappingnotdone'),
          },
          {
            title: $filter('translate')('hpo.data.exchange.mapping'),
          },
        ];

        scope.tabs.activeTab = 0;

        scope.changedTab = function(newval) {
          console.log(newval);
        };
      },
    };
  };

  ImportMappingHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
  ];
  return ImportMappingHpo;
});
