'use strict';
define(function() {
  var adminNetworkIndigau = function(
    FeatureTypeFactory,
    ConfigFactory,
    $timeout,
    $filter
  ) {
    return {
      templateUrl:
        'js/XG/widgets/indigauapp/home_admin_data/views/directives/admin_network_indigau.html',
      restrict: 'EA',
      scope: {
        calculheight: '=?',
      },
      link: function(scope) {
        scope.edit_resource = {};
        scope.edit_resource.edgesTypes = [];

        function initEdgesAndNodesTypes(featureTypes) {
          scope.edgesFeatureTypes = [];
          scope.nodesFeatureTypes = [];
          angular.forEach(featureTypes, function(featureType) {
            if (featureType.geographic) {
              if (featureType.typeInfo == 'LINE')
                scope.edgesFeatureTypes.push(featureType);
              else if (featureType.typeInfo == 'POINT')
                scope.nodesFeatureTypes.push(featureType);
            }
          });
        }

        function initEdgesAndNodeTypes0() {
          if (FeatureTypeFactory.resources.featuretypes.length > 0)
            initEdgesAndNodesTypes(FeatureTypeFactory.resources.featuretypes);
          else {
            FeatureTypeFactory.get().then(function() {
              initEdgesAndNodesTypes(FeatureTypeFactory.resources.featuretypes);
            });
          }
        }

        /**
         * Envoi un message aux enfants de cette directive afin de mettre à jour
         * la liste des FTI utilisés dans le réseau d'assainissement.
         * Toutefois, celle-ci peut ne pas être chargé au moment de l'envoi,
         * il faut donc réitérer l'envoi du message jusqu'à ce que la directive
         * réceptrice nous indique qu'elle a traité notre demande.
         *
         * @private
         * @method setInitialConfig
         * @param {Object} Configuration du réseau d'assainissement
         * @return {Object} RIEN
         */
        function setInitialConfig(res) {
          scope.$broadcast('setDualListBoxContent', {
            id: 'indigauNetworkEdges',
            leftData: res.data.visibleEdgesTypes,
            tellItIsDone: scope.initialConfigHasBeenSet,
          });
          scope.$broadcast('setDualListBoxContent', {
            id: 'indigauNetworkNodes',
            leftData: res.data.visibleNodesTypes,
            tellItIsDone: scope.initialConfigHasBeenSet,
          });
          $timeout(function() {
            if (!scope.initialConfigHasBeenSet.done) {
              setInitialConfig(res);
            }
          }, 200);
        }

        /**
         * Récupération de la configuration du réseau d'assainissement et
         * envoi de la liste des éléments le composant à chaque dual list afin
         * qu'elles reflétent l'état actuel de la configuration.
         *
         * @private
         * @method getConfig
         * @return {Object} description
         */
        function getConfig() {
          scope.indigauNetworkCfg = {};
          scope.initialConfigHasBeenSet = {};
          scope.initialConfigHasBeenSet.done = false;
          ConfigFactory.get('main', 'indigauNetworkCfg').then(function(res) {
            if (res.data) {
              setInitialConfig(res);
            }
          });
        }

        function initDualLists() {
          scope.indigauNetworkCfg = {};
          scope.indigauNetworkCfg.visibleEdgesTypes = [];
          scope.indigauNetworkCfg.visibleNodesTypes = [];
          // Edges DualListBox
          scope.dLBEdgesData = {
            id: 'indigauNetworkEdges',
            leftData: scope.indigauNetworkCfg.visibleEdgesTypes,
            leftDisplayAttribute: 'name',
            rightData: angular.copy(scope.edgesFeatureTypes),
            rightDisplayAttribute: 'name',
            leftTitle: 'model.network.partEdges',
            rightTitle: 'model.network.allEdges',
            source: 'right',
          };

          // Nodes DualListBox
          scope.dLBNodesData = {
            id: 'indigauNetworkNodes',
            leftData: scope.indigauNetworkCfg.visibleNodesTypes,
            leftDisplayAttribute: 'name',
            rightData: angular.copy(scope.nodesFeatureTypes),
            rightDisplayAttribute: 'name',
            leftTitle: 'model.network.partNodes',
            rightTitle: 'model.network.allNodes',
            source: 'right',
          };
        }

        /**
         * Sauvegarde de la configuration actuellement définie dans l'IHM
         * Cette méthode est appelée par le bouton "Enregostrer".
         *
         * @private
         * @method saveIndigauNetwork
         * @return {Object} description
         */
        scope.saveIndigauNetwork = function() {
          scope.indigauNetworkCfg.visibleEdgesTypes =
            scope.dLBEdgesData.leftData;
          scope.indigauNetworkCfg.visibleNodesTypes =
            scope.dLBNodesData.leftData;
          ConfigFactory.add(
            scope.indigauNetworkCfg,
            'main',
            'indigauNetworkCfg'
          ).then(function(res) {
            if (res.data === true) {
                swal(
              {
                title: $filter('translate')('common.configuration_saved'),
                text:'',
                type: 'success',
                timer: 1500
              });
            } else {
              swal({
                title: $filter('translate')('common.configuration_not_saved'),
                text:'',
                timer: 1500,
                type: 'error',
              });
            }
          });
        };

        function init() {
          scope.edgesAndNodesSelector =
            'js/XG/modules/model/views/modals/modal.network.edges_and_nodes.html';
          initEdgesAndNodeTypes0();
          initDualLists();
          getConfig();
        }

        init();
      },
    };
  };

  adminNetworkIndigau.$inject = [
    'FeatureTypeFactory',
    'ConfigFactory',
    '$timeout',
    '$filter',
  ];
  return adminNetworkIndigau;
});
