'use strict';
define(function() {
  var gcelement = function(
    EditRulesFactory,
    ogcFactory,
    EditTypesFactory,
    gcStyleFactory,
    gclayers,
    SelectManager,
    $translate,
    gcPopup,
    $rootScope,
    GeometryFactory,
    $filter,
    gcInteractions,
    $timeout,
    SridFactory,
    extendedNgDialog,
    gaJsUtils,
    ObjectFilesFactory,
    mapJsUtils,
    bizeditProvider
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/bizedition/views/bizeditmultiupdate.html',
      restrict: 'E',
      scope: {
        map: '=map',
        selectfti: '=selectfti',
        isActive: '=isactive',
        editdescription: '=editdescription',
        menuContext: '=menucontext',
        toolbarwidget: '=?toolbarwidget',
        createeditdescription: '&',
        openpopupattribute2: '&',
        reset: '&',
        save: '&',
        isactivepoint: '=isactivepoint',
        xconstraint: '=',
        yconstraint: '=',
        isxconstraint: '=',
        isyconstraint: '=',
        sridname: '=?',
        getMarkerPosition: '&',
        onSridSelected: '&',
        srids: '=',
        drawMode: '<?', // 'normal': main levée, 'coord': par coordonnées, 'lineaire': positionnement linéaire
        resetMenuContext: '&', // enlève les fonctions spécifiques du menu contextuel. Préserve zoom +/-
        network: '=?',  // nom du réseau d'interconnexion des composants défini dans l'admin
        isAttributePopupOpen: '=?' // désactive le bouton de création
      },

      link: function(scope, elt) {
        scope.isActive = false;
        scope.isactivepoint = scope.selectfti.isactivepoint;
        scope.isxconstraint = false;
        scope.isyconstraint = false;

        const GEOJSON_FORMAT = new ol.format.GeoJSON();

        //////// GESTION DES PROJECTIONS ///////////////////////////////

        const mapProjCode = scope.map.getView().getProjection().getCode();

        //Liste des systemes de projection
        scope.srids = SridFactory.sridsList;

        //Projection sélectionnée.
        if ($rootScope.xgos.mouseposition && $rootScope.xgos.mouseposition.srid) {
          scope.selectedsrid = angular.copy($rootScope.xgos.mouseposition.srid);
        } else {
          if (scope.map && mapProjCode) {
            scope.selectedsrid = angular.copy(mapProjCode)
          } else {
            scope.selectedsrid = {
              name: 'EPSG:3857',
              description:
                  '+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs',
            };
          }
        }

        //Récupération du code de projection de la carte
        //Récupération de la description de la projection de la carte
        let mapProjDescription = '';
        SridFactory.getbycode(mapProjCode).then(
            res => {
              mapProjDescription = res.data;
            },
            () => {
              require('toastr').error('Map SRID description not found !');
            }
        );

        /**
         * Appelée à chaque changement de projectiond dans la liste déroulante.
         */
        scope.onSridSelected = () => {
          if (scope.selectedsrid.name) {
            SridFactory.getbycode(scope.selectedsrid.name).then(
                res => {
                  scope.selectedsrid.description = res.data;
                },
                () => {
                  require('toastr').error('SRID description not found !');
                }
            );
          }
        };

        /**
         * Sélectionne le système de projection correspondant à celui de la carte.
         */
        scope.selectMapEPSG = () => {
          scope.selectedsrid = {
            name: mapProjCode,
            description: mapProjDescription
          };
        };

        //////// FIN GESTION DES PROJECTIONS ///////////////////////////////

        /*SelectionMode: outil utilisé pour sélectionner les objets à éditer
                  normal: dessin d'un cadre
                  polygon: dessin d'un polygon
                  query; récupération d'une sélection courante (après l'utilisation du requeteur)
                */
        scope.selectionMode = { value: 'normal' };

        scope.selectionType = { value: 'add' };

        scope.interactionOn = { value: true };

        //Gestion de l'indicateur et de la possibilité d'activer et désactiver la fonctionnalité de snap.
        scope.snapState = { isOn: false };

        scope.map.on('snapAddedEvent', function(e) {
          scope.snapState.isOn = true;
          scope.isSomeSnapInteraction = true;
        });
        scope.map.on('snapRemovedEvent', function(e) {
          scope.snapState.isOn = false;
          scope.isSomeSnapInteraction = false;
        });

        scope.isSomeSnapInteraction = false;

        /**
         * Handler de la case à cocher permettant d'activer ou de desactiver l'interaction de snap
         * (si la règle métier exécutée à l'initialisation à ajouter une interaction de snap)
         * @returns {undefined}
         */
        scope.switchSnap = () => {
          scope.snapState.isOn=!scope.snapState.isOn;
          for (let inter of scope.map.getInteractions().getArray()) {
            if (inter instanceof ol.interaction.Snap) {
              inter.setActive(scope.snapState.isOn);
            }
          }
        };

        scope.selectedFeatures = [];

        let noResultMsg = 'No Result';
        $translate('bizedition.attributesPopupNoResult').then(function(res) {
          noResultMsg = res;
        });

        /**
         * Méthode appelée au clic sur le bouton correspondant à cette directive.
         * @returns {undefined}
         */
        scope.startAction = function() {
          // pour afficher le formulaire de saisie x,y
          scope.isactivepoint = scope.selectfti.typeInfo === 'POINT';
          scope.reset();
          //Activation si désactivé et desactivation si activé
          //(la mise à jour de isActive n'a pas encore eu lieu à ce niveau,
          //on a ici encore la valeur de 'isactive' tel qu'elle était avant l'appel de reset() )
          scope.isActive = !scope.isActive;
          draw.setActive(scope.isActive);
          dragBox.setActive(scope.isActive);
          if (!scope.isActive) {
            return;
          }

          scope.selectedFeatures = []; //.splice(0);

          scope.editdescription = scope.createeditdescription();
          scope.editdescription.editType =
            EditTypesFactory.editTypes.update.name;
          scope.editdescription.fti = scope.selectfti;

          scope.selectfeaturesToUpdate();
        };

        /**
         * Active une méthode de sélection de features
         * @returns {undefined}
         */
        scope.selectfeaturesToUpdate = function() {

          // laisse uniquement zoom+/- dans le menu contextuel
          scope.resetMenuContext();

          //Si option de sélection de features par dessin d'un polygone
          if (scope.selectionMode.value === 'polygon') {
            scope.map.removeInteraction(dragBox);
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            scope.map.addInteraction(draw);
            //Enregistrement de la reference vers l'interaction pour la retirer de la carte au besoin.
            scope.editdescription.interactions.push(draw);
          } else if (scope.selectionMode.value === 'query') {
            scope.map.removeInteraction(dragBox);
            scope.map.removeInteraction(draw);
            const res = {data: SelectManager.getFeaturesByftiType(scope.selectfti.name)};
            onSelectionResult(res, {});
          } else {
            scope.map.removeInteraction(draw);
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            scope.map.addInteraction(dragBox);
            //Enregistrement de la reference vers l'interaction pour la retirer de la carte au besoin.
            scope.editdescription.interactions.push(dragBox);
          }
          scope.interactionOn.value = true;
        }; //end select

        var dragBox = new ol.interaction.DragBox({
          condition: function(evt) {
            //MacEnvironments don't get here because the event is not
            //recognized as mouseEvent on Mac by the google closure.
            //We have to use the apple key on those devices
            return (
              evt.originalEvent.ctrlKey || scope.isActive
            ); /* ||
                      (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
          },
          style: gcStyleFactory.getStyle('selectrectangle'),
        });

        dragBox.set('gctype', 'kis');
        dragBox.set('interaction', 'Select');
        dragBox.set('widget', 'Edition');

        //Interaction de dessin d'un cadre pour sélectionner des features sur la carte.
        const draw = new ol.interaction.Draw({
          type: 'Polygon',
        });

        draw.setActive(scope.isActive);
        dragBox.setActive(scope.isActive);

        //Interaction de dessin d'un polygone pour sélectionner des features sur la carte.
        dragBox.on('boxend', function(evt) {
          //Réinitialisation préalable si l'interaction dragBox n'a pas été rétirée et que l'utilisateur a la possibilité de refaire une sélection sur la carte.
          //if (scope.editdescription && scope.editdescription.editedfeature) gclayers.getDrawLayer().getSource().removeFeature(scope.editdescription.editedfeature);
          //if (scope.modifyInteraction) map.removeInteraction(scope.modifyInteraction);
          if (scope.p != undefined && scope.p.element != null)
            scope.p.destroy();

          //Recherche des objets intersectés par le polygone de sélection
          const extent = dragBox.getGeometry().getExtent();
          const srid = scope.map.getView().getProjection().getCode();
          //Résultat de la sélection
          ogcFactory.findIntersectedFeaturesByRectangle(extent, srid,
            scope.editdescription.fti.uid, 'edition').then(
            res => {
              onSelectionResult(res, evt);
            },
            error => {
              console.error(
                'select feature() ogcFactory.getfeatures, error:' + error
              );
              require('toastr').error(error);
            }
          );
        }); //en dragBox.end

        /**
         * Handler de fin de dessin de polygone de sélection d'objet sur la carte.
         * Permetr de requeter les objets features de la couche sélectionnée, situés à l'intérieur du dessin.
         */
        draw.on('drawend', function(evt) {
          //Fermeture de l'eventuelle popup déjà ouverte.
          if (scope.p != undefined && scope.p.element != null)
            scope.p.destroy();

          //if (scope.modifyInteraction) map.removeInteraction(scope.modifyInteraction);
          //Récupération de la géométrie dessinée
          const polygon = evt.feature.getGeometry();
          const srid = scope.map.getView().getProjection().getCode();
          // résultat de la sélection
          ogcFactory.findIntersectedFeaturesByPolygon(polygon, srid, scope.editdescription.fti.uid).then(
            res => {
              onSelectionResult(res, evt);
            },
            error => {
              console.error('ogcFactory.getfeatures, error:' + error);
              require('toastr').error(error);
            }
          );
        });

        /**
         * Utilitaire: indique si le feature passé en paramètre appartient déjà à la sélection.
         * @param {ol.Feature} featureToCheck objet openlayers dont on évalue la présence dans le tableau selectedFeatures
         * @return {Boolean} true si feature en paramètre appartient déjà à la sélection sinon false
         */
        function isFeatureToAdd(featureToCheck) {
          return !scope.selectedFeatures.some(feature => feature.getId() === featureToCheck.getId());
        }

        /**
         * [openpopupattribute2 ouvre une popup d'informations d'attribut utilisé lors de la fusion]
         * @param  {ol.Feature} feature [description]
         * @param  {object} fti     [description]
         */
        scope.openpopupattribute2 = function(feature, fti) {
          scope.uploadfile = {};
          if (scope.p2 != undefined && scope.p2.element != null)
            scope.p2.destroy();
          scope.currentFti = fti;
          scope.currentFeature = feature;
          //scope.authorizedAttributes = getAuthorizedAttributes(fti);
          scope.authorizedReadAttributes = fti.attributes;
          scope.authorizedWriteAttributes = fti.attributes;
          scope.authorizedWriteAttributesNames = scope.authorizedWriteAttributes.map(att => att.name);
          scope.currentProperties = feature.getProperties();
          scope.configurationTab = false;
          ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(
            fti.uid,scope.authorizedReadAttributes).then(res =>{
              if (typeof res === 'object' && res != null && res.active) {
              scope.configurationTab = res;
              }
          }).finally(() => {
            // KIS-2987: la configuration de la fiche-objet contient la largeur initiale de la popup
            // => affiche la popup après la récupération de la configuration de la fiche-objet.
            let hasTabs = false;
            let popupWidth = null;
            if (gaJsUtils.notNullAndDefined(scope.configurationTab) && typeof scope.configurationTab !== 'boolean'
                && Array.isArray(scope.configurationTab.configuration) && scope.configurationTab.configuration.length > 0) {
              hasTabs = true;
              const firstConf = scope.configurationTab.configuration[0];
              if (firstConf.popupWidth > 0 && firstConf.popupWidth < window.innerWidth) {
                popupWidth = firstConf.popupWidth;
              }
            }

            // affecte une classe particulière à la gcPopup en présence d'une fiche-objet
          scope.p2 = gcPopup.open({
            scope: scope,
            title: $filter('translate')('edition.popup_title'),
            template:
              'js/XG/widgets/mapapp/bizedition/views/attribute_popup2.html',
            showClose: true,
              minimizeMaximize: true,
              resizable: false,
              minWidth: 430,
              minHeight: 300,
              className: hasTabs ? ' objectFilesPopup': '',
              width: popupWidth
            });

            // Ajustement de la hauteur du tab-content dans le cas de plusieurs lignes d'onglets
            if (hasTabs) {

              // sélecteur de la règle CSS que l'on va modifier
              // on ne peut pas modifier directement le style de l'élement HTML car il est modifiable par le redimensionnement vertical
              const cssRuleIdentifier = '.gcPopup.objectFilePopup .popup-template .myBody .popupContent.attributes-info-box .scrolledTabs .tab-content';
              bizeditProvider.adjustObjectFileTabContentHeight(scope.p2.popup.iddiv, cssRuleIdentifier,'scrolledTabs', 3);
            }
          });
        };
        /**
         * Appelée à la validation d'une édition attributaire
         * @returns {undefined}
         */
        scope.validFeatures = () => {
          if (!bizeditProvider.checkMandatory(scope, scope.authorizedReadAttributes, 1, undefined,
              scope.currentProperties)) {
            return;
          }
          //Mise à jour attributaires
          scope.currentFeature.setProperties(scope.currentProperties);
          scope.currentFeature.attrEdited = true;
          scope.currentFeature.saved = false;
          scope.p2.destroy();

          // met à jour le statut de la session d'édition
          updateGeometryStatus(scope.editdescription);

          scope.isAttributePopupOpen = false;
        };

        /**
         * [defBaryCenter description]
         * @param  {[type]} flatCoord [description]
         * @return {number[]}           [description]
         */
        function defBaryCenter(flatCoord) {
          var anchorX = 0;
          var anchorY = 0;
          //récup de la longueur du tab des flat coordinates (-2 car les deux dernières correspondent aux premiers coordonnées du poly)
          var flatL = flatCoord.length - 2; //polygon
          var pnum = flatL / 2;
          // somme de tous les coordonnées en x et en y à partir du tableau des flat coordinates
          for (var i = 0; i < flatL; i += 2) {
            anchorX += flatCoord[i];
            anchorY += flatCoord[i + 1];
          }
          anchorX = anchorX / pnum;
          anchorY = anchorY / pnum;
          return [anchorX, anchorY];
        }

        /**
         * [newObjet fonction fusion en mode creation d'un nouveau objet]
         * @param  {ol.Feature[]} selectedFeatures        [les features selectionnés]
         * @param  {object} editdescription [correspond au scope.editdescription]
         */
        scope.newObjet = function(selectedFeatures, editdescription) {
          const featuresExtents = [];

          for (let selectedFeature of selectedFeatures) {
            const featureGeometry = GEOJSON_FORMAT.writeGeometry(selectedFeature.getGeometry());
            featuresExtents.push(JSON.parse(featureGeometry));
          }

          GeometryFactory.union(featuresExtents).then(function(res) {

            // ouverture de la popup
            openAttributChoicePopup(editdescription);

            scope.confirm = function(featureChoosen) {
              if (featureChoosen == undefined) {
                return;
              }
              if (scope.AttributChoiseDialog) scope.AttributChoiseDialog.close();
              var geometry = GEOJSON_FORMAT.readGeometry(res.data);
              var relatFeature = featureChoosen.clone();
              relatFeature.setGeometry(geometry);
              gclayers.getDrawLayer().getSource().addFeature(relatFeature);
              var newObject = {
                shareObject: '',
                editType: EditTypesFactory.editTypes.add.name,
                feature: relatFeature,
                fti: editdescription.fti,
              };
              scope.editdescription.relatedfeatures.push(newObject);
              gclayers.getselectSource().clear();
              var extent = geometry.getExtent();
              scope.map.getView().fit(extent, scope.map.getSize());
              scope.$emit('setUpdatesToSave', { value: true });
            };
          }, () => {
            require('toastr').error($filter('translate')('bizedition.union.error'));
          });
          scope.p.destroy();
        };
        /**
         * [replaceObjects fonction fusion en mode remplacement de tous les objets selectionnées par la fusion de l'ensemble]
         * @param  {ol.Feature[]} selectedFeatures        [les features selectionnés]
         * @param  {object} editdescription [correspond au scope.editdescription]
         */
        scope.replaceObjects = function(selectedFeatures, editdescription) {
          if (scope.AttributChoiseDialog) scope.p.destroy();

          const featuresExtents = [];
          for (const selectedFeature of selectedFeatures) {
            const featureGeometry = GEOJSON_FORMAT.writeGeometry(selectedFeature.getGeometry());
            featuresExtents.push(JSON.parse(featureGeometry));
          }
          GeometryFactory.union(featuresExtents).then(function(res) {

            // ouverture de la popup
            openAttributChoicePopup(editdescription);

            scope.confirm = function(featureChoosen) {
              if (featureChoosen == undefined) {
                return;
              }
              if (scope.AttributChoiseDialog) scope.AttributChoiseDialog.close();
              const props = featureChoosen.getProperties();
              editdescription.editedfeature.setProperties(props);
              const geometry = GEOJSON_FORMAT.readGeometry(res.data);
              editdescription.editedfeature.setGeometry(geometry);
              if (editdescription.relatedfeatures) {
                for (let relatedFeature of editdescription.relatedfeatures) {
                  relatedFeature.editType = 'delete';
                }
              }
              gclayers.getselectSource().clear();
              const extent = geometry.getExtent();
              scope.map.getView().fit(extent, scope.map.getSize());

              // met à jour le statut de la session d'édition
              updateGeometryStatus(scope.editdescription);
            };
          }, () => {
            require('toastr').error($filter('translate')('bizedition.union.error'));
          });

          scope.p.destroy();
        };
        scope.highLightFeature = function(f) {
          gclayers.addhighLightFeature(f);
          //ADD Timeout sur scope.removehighLightFeature si probleme pour retirer le highLight
        };
        scope.removehighLightFeature = function(f) {
          gclayers.removehighLightFeatures(f);
          //gclayers.clearhighLightFeatures();
        };
        /**
         * [replaceOneObject fonction de fusion : choisir un des objets selectionnés et le remplacer par la fusion de l'ensemble]
         * @param  {ol.Feature[]} selectedFeatures        [les objets selectionnés]
         * @param  {object} editdescription [description]
         * @param  {ol.Feature} featSelect      [l'objet qui sera remplacé]
         */
        scope.replaceOneObject = function(selectedFeatures, editdescription, featSelect) {
          const featuresExtents = [];
          for (let selectedFeature of selectedFeatures) {
            const featureGeometry = GEOJSON_FORMAT.writeGeometry(selectedFeature.getGeometry());
            featuresExtents.push(JSON.parse(featureGeometry));
          }
          GeometryFactory.union(featuresExtents).then(function(res) {

            // ouverture de la popup
            openAttributChoicePopup(editdescription);

            scope.confirm = function(featureChoosen) {
              if (featureChoosen == undefined) {
                return;
              }
              if (scope.AttributChoiseDialog) scope.AttributChoiseDialog.close();

              const props = featureChoosen.getProperties();

              if (featSelect === selectedFeatures[0].getId()) {
                const geometry = GEOJSON_FORMAT.readGeometry(res.data);
                editdescription.editedfeature.setProperties(props);
                editdescription.editedfeature.setGeometry(geometry);
              } else {
                for (let relatedfeature of editdescription.relatedfeatures) {
                  if ( featSelect === relatedfeature.feature.getId()) {
                    const geometry = GEOJSON_FORMAT.readGeometry(res.data);
                    relatedfeature.feature.setProperties(props);
                    relatedfeature.feature.setGeometry(geometry);
                  }
                }
              }
              gclayers.getselectSource().clear();
              const extent = geometry.getExtent();
              scope.map.getView().fit(extent, scope.map.getSize());
              scope.$emit('setUpdatesToSave', { value: true });
            };
          }, () => {
            require('toastr').error($filter('translate')('bizedition.union.error'));
          });
          scope.p.destroy();
        };
        scope.deplacementMultiple = (source, features) => {
          /// interaction déplacement multiple
          /// ajout de la box de déplacement
          const stylesBox = [
            new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: 'black',
                width: 1,
              }),
              fill: new ol.style.Fill({
                color: 'rgba(255,255,255, 0.1)',
              }),
            }),
            new ol.style.Style({
              image: new ol.style.Circle({
                radius: 1,
                stroke: new ol.style.Stroke({
                  color: 'black',
                }),
                fill: new ol.style.Fill({
                  color: '#ddd',
                }),
              }),
              geometry: function(feature) {
                // return the coordinates of the first ring of the polygon
                const coordinates = feature.getGeometry().getCoordinates()[0];
                return new ol.geom.MultiPoint(coordinates);
              },
            }),
          ];

          // recuperer l'extent du feature selectionné

          //var ext=scope.editdescription.editedfeature.getGeometry().getExtent();
          const ext = source.getExtent();

          //créer la geometrie de la box à partir de l'extent
          const box = new ol.geom.Polygon.fromExtent(ext);
          //créer le feature représentant la box de transformation
          const featureBox = new ol.Feature({
            geometry: box,
            name: 'MyBox',
          });
          // créer la source de la box
          const srcBox = new ol.source.Vector();
          // ajout du feature box à la source
          srcBox.addFeature(featureBox);
          // créer une couche vectorielle de la box
          scope.layerBoxDep = new ol.layer.Vector({
            source: srcBox,
            style: stylesBox,
          });
          // ajouter la couche à la map et visualisation

          scope.map.addLayer(scope.layerBoxDep);

          /******************************************************************************
          DEFINITION DE L'INTERACTION DE TRANSFORMATION PAR DRAG QUI N'A RIEN A FAIRE ICI
          ******************************************************************************/

          /**
           * Define a namespace for the application.
           */
          var app = {};

          /**
           * @constructor
           * @extends {ol.interaction.Pointer}
           */
          app.Drag = function() {
            ol.interaction.Pointer.call(this, {
              handleDownEvent: app.Drag.prototype.handleDownEvent,
              handleDragEvent: app.Drag.prototype.handleDragEvent,
              handleMoveEvent: app.Drag.prototype.handleMoveEvent,
              handleUpEvent: app.Drag.prototype.handleUpEvent,
            });

            /**
             * @type {ol.Pixel}
             * @private
             */

            this.lastCoordinate_ = null;

            /**
             * @type {string|undefined}
             * @private
             */
            this.cursor_ = 'pointer';

            /**
             * @type {}
             * @private
             */

            this.features = {
              box: featureBox,
              selection: features,
            };

            /**
             * @type {string|undefined}
             * @private
             */
            this.previousCursor_ = undefined;

            /**
             * @type {string|undefined}
             * @private
             */
            this.action = undefined;
          };

          ol.inherits(app.Drag, ol.interaction.Pointer);
          /**
           * @param {ol.MapBrowserEvent} evt Map browser event.
           * @return {boolean} `true` to start the drag sequence.
           */
          app.Drag.prototype.handleDownEvent = function(evt) {
            try {
              var feature = evt.map.forEachFeatureAtPixel(evt.pixel, function(
                feature
              ) {
                return feature;
              });

              //console.log(map.getTarget());
              if (feature) {
                if (feature.getProperties().name === 'MyBox') {
                  this.action = 'translation';
                  this.lastCoordinate_ = evt.coordinate;
                  /* for (var i=0; i < this.features.selection.length; i++){
                        scope.geom2 = this.features.selection[i].getGeometry().clone();
                        scope.geoms2.push(scope.geom2);
                      } */
                }
              }
              return !!feature;
            } catch (e) {}
          };
          app.Drag.prototype.handleDragEvent = function(evt) {
            if (this.lastCoordinate_ && this.action === 'translation') {
              //calcul des distances dernières coordonnées et les coordonnées courantes du curseur
              var deltaX = evt.coordinate[0] - this.lastCoordinate_[0];
              var deltaY = evt.coordinate[1] - this.lastCoordinate_[1];

              // mise à jour de la box geom en fonction des distances calculées
              var geomBox = this.features.box.getGeometry();
              geomBox.translate(deltaX, deltaY);
              // mise à jour de la geom du feature à transformer en fonction des distances calculées
              for (var i = 0; i < this.features.selection.length; i++) {
                var geom = this.features.selection[i].getGeometry();
                geom.translate(deltaX, deltaY);
                this.features.selection[i].setGeometry(geom);
              }

              this.lastCoordinate_[0] = evt.coordinate[0];
              this.lastCoordinate_[1] = evt.coordinate[1];
            }
          };

          /**
           * @return {boolean} `false` to stop the drag sequence.
           */
          app.Drag.prototype.handleUpEvent = function() {
            // this.lastCoordinate_ = null;
            if (this.lastCoordinate_) {
              this.lastCoordinate_ = undefined;
              $timeout(function() {

                // met à jour le statut de la session d'édition
                updateGeometryStatus(scope.editdescription);
              }, 0);
              return true;
            }
            return false;
          };

          /*************Fin fonction interaction de transformation***********/

          // création d'une interaction de transformation
          scope.interactionTransform = new app.Drag();
          // ajout de l'interaction de transformation à la map
          gcInteractions.setCurrentToolBar(scope.toolbarwidget);
          scope.map.addInteraction(scope.interactionTransform);
        };

        var Valider = [
          'Valider',
          function() {
            //alert('Valider ?')
            scope.ClickedButtonValider = true;
            scope.onModifyEnd();
          },
        ];
        /**
         * [boutonDroit Menu bouton droit : varie selon le type de geometry des objets selectionnés]
         * @param  {ol.source.Vector} source          [source contenant les objets selectionnes]
         * @param  {ol.Feature[]} features        [l'ensemble des features selectionnées]
         * @param  {object} editdescription [description]
         */
        function boutonDroit(source, features, editdescription) {
          const ext = source.getExtent();
          // Recupérarion des flat Coordinates
          // Attention : A modifier avec la version OL3.17.1 => geom.j
          //var flatCoordinates = box.j;
          //scope.baryCenter = defBaryCenter(flatCoordinates);
          scope.baryCenter = new ol.extent.getCenter(ext);
          scope.geoms = [];
          scope.geoms2 = [];

          for (let i = 0; i < features.length; i++) {
            scope.geom2 = features[i].getGeometry().clone();
            scope.geoms2.push(scope.geom2);
          }

          var copier = [
            $filter('translate')('bizedition.menuContext.copier'),
            function() {
              // mettre le mode d'edition en 'add' pour tous les fetures selectionnes
              editdescription.editType = 'add';
              if (editdescription.relatedfeatures) {
                for (let relatedfeature of editdescription.relatedfeatures) {
                  relatedfeature.editType = 'add';
                }
              }
              //remplir un tableau avec des copies de toutes les geometries  des features selectionnes
              for (var i = 0; i < features.length; i++) {
                scope.geom = features[i].getGeometry().clone();
                scope.geoms.push(scope.geom);
              }
            },
          ];

          var coller = [
            $filter('translate')('bizedition.menuContext.coller'),
            function(event) {
              // map.K coordonnees de la souris , A modifier
              const deltaX = scope.map.Y[0] - scope.baryCenter[0];
              const deltaY = scope.map.Y[1] - scope.baryCenter[1];
              // Pour chaque feature on fait un clone de sa geometrie et on lui applique la translation (calculé en fct des coordonnées de la souris)
              for (let i = 0; i < features.length; i++) {
                const geom = scope.geoms[i].clone();
                geom.translate(deltaX, deltaY);
                features[i].setGeometry(geom);
              }
              //si un seul feature est selectionne on ouvre une popup de mise a jour des attributs
              if (features.length === 1) {
                scope.openpopupattribute2(features[0], editdescription.fti);
              } else {

                // met à jour le statut de la session d'édition
                updateGeometryStatus(scope.editdescription);
              }
            },
          ];
          //A revoir
          var deplacement = [
            $filter('translate')('bizedition.menuContext.deplacer'),
            function() {
              scope.deplacementMultiple(source, features);
            },
          ];
          var union = [
            $filter('translate')('bizedition.menuContext.fusion'),
            function() {
              //ouvre une popup de choix entre 3 type de fusion
              scope.feats = features;
              scope.edit = editdescription;
              scope.myFeature = {};
              scope.p = gcPopup.open({
                scope: scope,
                title: $filter('translate')('bizedition.merge'),
                template:
                  'js/XG/widgets/mapapp/bizedition/views/fusion_popup.html',
                showClose: true,
                minWidth: 350,
                maxHeight:250
              });
            },
          ];
          var trou = [
            $filter('translate')('bizedition.menuContext.creerTrou'),
            function() {
              const ext1 = features[0].getGeometry().getExtent();
              const ext2 = features[1].getGeometry().getExtent();
              if (features.length === 2 &&
                (ol.extent.containsExtent(ext2, ext1) || ol.extent.containsExtent(ext1, ext2))) {
                let featSel;
                let featTrou;
                if (ol.extent.containsExtent(ext1, ext2)) {
                  featSel = features[0];
                  featTrou = features[1];
                } else {
                  featSel = features[1];
                  featTrou = features[0];
                }
                const coords = featTrou.getGeometry().getCoordinates();

                const polygon = featSel.getGeometry().getPolygon(0);

                polygon.appendLinearRing(new ol.geom.LinearRing(coords[0][0]));

                const newgeom = new ol.geom.MultiPolygon([
                  polygon.getCoordinates(),
                ]);

                featSel.setGeometry(newgeom);

                if (featTrou.getId() === editdescription.editedfeature.getId()) {
                  editdescription.editType = 'delete';
                } else {
                  editdescription.relatedfeatures[0].editType = 'delete';
                }
              } else {
                alert(
                  'erreur de selection, veuillez renouvelez votre selection pour effectuer le trou'
                );
              }
            },
          ];

          const menu = scope.menuContext;
          if (scope.menuContext && scope.menuContext.length >= 3) {
            scope.menuContext.splice(0, scope.menuContext.length - 2);
          }
          if (editdescription.editedfeature.getGeometry().getType() === 'MultiLineString' ||
            editdescription.editedfeature.getGeometry().getType() === 'LineString') {
            menu.unshift(copier, coller, union, deplacement, null);
          } else if (
            editdescription.editedfeature.getGeometry().getType() === 'MultiPolygon' ||
            editdescription.editedfeature.getGeometry().getType() === 'Polygon') {
            menu.unshift(copier, coller, union, trou, deplacement, null);
          } else {
            menu.unshift(copier, coller, deplacement, null);
          }
        }

        function getPropertiesOf(feat) {
          return feat.getProperties();
        }


        function onSelectionResult(res, evt) {
          //Instanciation de l'objet editdescription à chaque nouvelle sélection si on veut prendre en compte
          //dynamiquement les changement de type de sélection
          //                    scope.createeditdescription();
          //                    scope.editdescription.editType = EditTypesFactory.editTypes.update.name;
          //                    scope.editdescription.fti = scope.selectfti;
          //                    //Enregistrement de la reference vers l'interaction pour la retirer de la carte au besoin.
          //                    scope.editdescription.interactions.push(dragBox);
          //
          require('toastr').clear();
          if (res.data.features == undefined || res.data.features.length === 0) {
            require('toastr').warning(noResultMsg);
            return;
          }

          // On ne peut pas modifier plusieurs objets ponctuels/linéaires en mode d'édition "par coordonnées" ou "positionnement linéaire"
          if((isEditingPointByCoordinates() || isEditingPointByDistance() || isEditingLineByCoordinates()
              || isEditingLineByDistance()) && preventMultiUpdateWhenCoordinatesMode(res.data)) {
            return;
          }

          gclayers.getDrawLayer().getSource().clear();

          //Decodage de la featureCollection, (le decodage retourne un tableau de ol.feature)
          if (scope.selectionType.value === 'new') {
            scope.selectedFeatures = GEOJSON_FORMAT.readFeatures(res.data);
          }
          //Si la sélection actuelle d'objets doit s'ajouter à la précedente sélection
          else if (scope.selectionType.value === 'add') {
            //Récupération de la nouvelle sélection
            let partialSelection = GEOJSON_FORMAT.readFeatures(res.data);
            //Filtrage pour ne récupérer que des nouveaux features non précedement sélectionnés
            partialSelection = partialSelection.filter(isFeatureToAdd);
            //Ajout des nouveaux features à la sélection
            scope.selectedFeatures = scope.selectedFeatures.concat(partialSelection);
          }
          //Par defaut, nouvelle sélection
          else {
            scope.selectedFeatures = GEOJSON_FORMAT.readFeatures(res.data);
          }

          //Mise en evidence des features sélectionnés
          gclayers.getselectSource().clear();
          gclayers.getselectSource().addFeatures(scope.selectedFeatures);
          if (scope.selectfti.typeInfo !== 'POINT' && scope.selectfti.typeInfo !== 'MULTIPOINT') {
            const vertStyle = gcStyleFactory.getStyle('verticeShow');
            for (let ind = 0; ind < scope.selectedFeatures.length; ind++) {
              scope.selectedFeatures[ind].setStyle(vertStyle);
            }
          }
          //Suppression des eventuels precedents features presents
          //dans editDescription
          if (!scope.editdescription.relatedfeatures0) {
            scope.editdescription.relatedfeatures0 = [];
          }
          scope.editdescription.editedfeature = undefined;
          scope.editdescription.relatedfeatures.splice(0);
          scope.editdescription.relatedfeatures0.splice(0);
          scope.editdescription.shareObjects.splice(0);
          scope.editdescription.geometryStatus = '';

          if (scope.selectedFeatures.length === 0) {
            scope.resetMenuContext();
          }
          //EditDescription: On ne prend en compte qu'un seul objet,
          //le premier sélectionné.

          if (scope.selectedFeatures.length > 0) {
            scope.fCollection = new ol.Collection();

            scope.editdescription.editedfeature = scope.selectedFeatures[0];
            scope.editdescription.editedfeature0 = getPropertiesOf(
              scope.selectedFeatures[0]
            );
            //-- Si on resélectionne le même objet, saved sera à "true" et
            //-- ce n'est pas bon. Il faut donc forcer la valeur à "false"
            //-- afin de prendre en compte les prochaines modifications.
            scope.editdescription.editedfeature.saved = false;
            // ajout des differentes actions au niveau du bouton droit (les actions dependent du type de geometry)
            if (scope.menuContext) {
              boutonDroit(
                gclayers.getselectSource(),
                scope.selectedFeatures,
                scope.editdescription
              );
            }

            scope.fCollection.push(scope.editdescription.editedfeature);
            //Visualisation

            for (var i = 1; i < scope.selectedFeatures.length; i++) {
              var relatFeature = scope.selectedFeatures[i];
              scope.fCollection.push(relatFeature);
              var newObject = {
                shareObject: '',
                editType: EditTypesFactory.editTypes.update.name,
                feature: relatFeature,
                fti: scope.editdescription.fti,
              };
              scope.editdescription.relatedfeatures.push(newObject);
              scope.editdescription.relatedfeatures0.push(
                getPropertiesOf(newObject.feature)
              );
            }

            if (isEditingLineByDistance() && !scope.isEditionPopupOpened) {
              // ouvre la popup d'édition d'une ligne "par positionnement linéaire"
              openEditLineByDistance();

            } else if (isEditingPointByDistance() && !scope.isEditionPopupOpened) {
              // ouvre la popup d'édition d'un point "par coordonnées"
              openEditPointByDistance();

            } else if (isEditingPointByCoordinates() && !scope.isEditionPopupOpened) {
              // ouvre la popup d'édition d'un point "par positionnement linéaire"
              openEditPointByCoordinates();

            } else if (isEditingLineByCoordinates() && !scope.isEditionPopupOpened) {
              // ouvre la popup d'édition d'un point "par positionnement linéaire"
              openLineEditByCoordinates();

            } else {
              //Interaction de modification
              scope.modifyInteraction = new ol.interaction.Modify({
                features: scope.fCollection,
                //condition: map.on('moveend',scope.onModifyEnd),
                // the SHIFT key must be pressed to delete vertices, so
                // that new vertices can be drawn at the same position
                // of existing vertices
                deleteCondition: (event) => {
                  return (
                      ol.events.condition.shiftKeyOnly(event) &&
                      ol.events.condition.singleClick(event)
                  );
                },
              });

              scope.modifyInteraction.set('gctype', 'kis');
              scope.modifyInteraction.set('interaction', 'Modify');
              scope.modifyInteraction.set('widget', 'Edition');
              scope.modifyInteraction.on('modifyend', (event) => {
                scope.editdescription.geometryStatus = 'modifiedAndNotSaved';
                console.log('modifyend');
                const modifiedFeatures = findModifiedFeatures(event.features, event.mapBrowserEvent.coordinate);
                for (const modifiedFeature of modifiedFeatures) {
                  modifiedFeature.geometryChanged = true;
                }
                if (EditRulesFactory.applyRules()) {
                  // Affichage du bouton "Exécuter les règles métier onEnd"
                  scope.editdescription.geometryStatus = 'readyToApplyEndRule';

                  // clignotement du bouton "Exécuter les règles métier onEnd"
                  bizeditProvider.startApplyRulesButtonBlinking();
                } else {
                  scope.editdescription.geometryStatus = 'modifiedAndNotSaved';
                  scope.$emit('geometryHasBeenModified');
                }
              });
              scope.modifyInteraction.on('modifystart', () => {
                console.log('modifystart');
              });

              scope.modifyInteraction.setActive(false);
              gcInteractions.setCurrentToolBar(scope.toolbarwidget);
              //Ajout de l'interaction de modification à la map.
              scope.map.addInteraction(scope.modifyInteraction);
              //Enregistrement de la reference vers l'interaction pour la retirer de la carte au besoin.
              scope.editdescription.interactions.push(scope.modifyInteraction);
            }

            //The snap interaction must be added after the Modify and Draw interactions
            // SnapOn ne doit pas être chargé pour l'édition d'un point "par positionnement linéaire"
            // car il ne peut pas y avoir 1 intéraction KIS active supplémentaire en plus de l'intéraction select du parcours réseau
            // cf. swal gcmap $scope.map.getInteractions().on('add') L.738
            EditRulesFactory.executeInitRules(scope.editdescription,scope.selectfti,scope.map).then(
                () => {
                  const params = {evt: evt};
                  EditRulesFactory.executeStartRules(
                      scope.editdescription,
                      scope.selectfti,
                      scope.map,
                      params
                  ).then(() => {
                    if (!isEditingPointByCoordinates() && !isEditingPointByDistance()
                        && !isEditingLineByCoordinates() && !isEditingLineByDistance()) {
                      scope.modifyInteraction.setActive(true);
                    }

                    // gère l'affichage du bouton "Exécuter les règles métier" (engrenage)
                    scope.applyRules = EditRulesFactory.applyRules();

                    if (scope.applyRules) {
                      // déplace le bouton "Exécuter les règles métier" (engrenage) dans la ligne du bouton "Valider"
                      moveApplyRulesButton();
                    }
                  });
                }
            );
          }
        }

        scope.$watch('interactionOn.value', (newValue, oldValue)=>{
          if(angular.isDefined(oldValue) && angular.isDefined(newValue) && 
             scope.editdescription && Array.isArray(scope.editdescription.interactions)){
            for (const interaction of scope.editdescription.interactions) {
              if (interaction && (interaction instanceof ol.interaction.DragBox)) {
                    interaction.setActive(newValue);
              }
            }
          }
        });


        scope.$on('removeDeplMultiple', () => {
          // supprimer les layers contenant les features box et point rotation
          // appliqué au niveau du reset
          scope.map.removeLayer(scope.layerBoxDep);
        });

        /**
         *
         */
        scope.getMarkerPosition = function() {
          if (scope.isPointCoordinatesValid()) {
            // copie les variables draftCoords.x/y dans x/yconstraint
            // l'objet draftCoords n'existe que parce que angularjs n'est pas capable de récupérer les variables de popup
            setPointCoordinatesFromPopup();
            const marker = new ol.Feature({
              geometry: new ol.geom.Point([scope.xconstraint, scope.yconstraint]),
            });
            let iconStyle = new ol.style.Style({
              image: new ol.style.Icon({
                anchor: [0.5, 36],
                anchorXUnits: 'fraction',
                anchorYUnits: 'pixels',
                src: 'img/widget/adressLocation/marker.png',
              }),
            });
            marker.setStyle(iconStyle);
            const vectorSource = new ol.source.Vector({
              features: [marker],
            });
            const markerPositionLayer = mapJsUtils.addOrGetLayerByProperty(scope.map, 'id', bizeditProvider.MARKER_POSITION_LAYER_ID);
            markerPositionLayer.setSource(vectorSource);

            // positionne la puce de localisation au-dessus de tous les dessins vectoriels
            const zIndexMax = gaJsUtils.getZIndexMax(scope.map);
            if (zIndexMax) {
              markerPositionLayer.setZIndex(zIndexMax +1);
            }

            scope.map.getView().setCenter(marker.getGeometry().getCoordinates());
          }
        };

        /**
         *
         * @param clicEvent
         */
        scope.onModifyEnd = function(clicEvent) {

          //désactivation du clignotement du bouton "Exécuter les règles onEnd"
          bizeditProvider.stopApplyRulesButtonBlinking();

          if (
            (angular.isUndefined(clicEvent) ||
              !clicEvent.originalEvent.shiftKey) &&
            scope.modifyInteraction
          )
            scope.map.removeInteraction(scope.modifyInteraction);

          if (scope.editdescription !== undefined && scope.editdescription.editedfeature !== undefined) {
            const markerPositionLayer = mapJsUtils.getLayerByProperty(scope.map, 'id', bizeditProvider.MARKER_POSITION_LAYER_ID);
            if (markerPositionLayer) {
              markerPositionLayer.setSource(null);
            }

            if (isEditingLineByCoordinates()) {
              scope.editdescription.editedfeature.getGeometry().setCoordinates([scope.lineByCoords]);
            } else if(isEditingPointByDistance() && scope.selectedFeatures.length === 1 && Array.isArray(scope.pointByDistance.coords)) {
              scope.editdescription.editedfeature.getGeometry().setCoordinates(scope.pointByDistance.coords);
            } else if (isEditingPointByCoordinates() || (scope.selectedFeatures.length === 1 &&
              scope.isxconstraint && scope.isyconstraint)) {
              scope.editdescription.editedfeature
                .getGeometry()
                .setCoordinates([scope.xconstraint, scope.yconstraint]);
            } else {
              if (scope.selectedFeatures.length === 1 && scope.isyconstraint) {
                let x = scope.editdescription.editedfeature
                  .getGeometry()
                  .getCoordinates()[0];
                scope.editdescription.editedfeature
                  .getGeometry()
                  .setCoordinates([x, scope.yconstraint]);
              } else {
                if (scope.selectedFeatures.length === 1 && scope.isxconstraint) {
                  let y = scope.editdescription.editedfeature
                    .getGeometry()
                    .getCoordinates()[1];
                  scope.editdescription.editedfeature
                    .getGeometry()
                    .setCoordinates([scope.xconstraint, y]);
                }
              }
            }

            // cas de l'inversion de sens d'une ligne (scope.reversingLineData)
            let toBypassRules = [''];
            let isReversingLine = false;

            if (EditRulesFactory.applyRules()) {
              if (typeof scope.reversingLineData === 'object' && scope.reversingLineData !== null
                  && Object.keys(scope.reversingLineData) > 0) {
                isReversingLine = true;
                toBypassRules = scope.reversingLineData.bypassRules;
              }
            }

            //Execution des règles 'onend'.
            EditRulesFactory.executeEndRules(scope.editdescription, scope.editdescription.fti, scope.map, toBypassRules).then(
              function() {
                console.info('endRules executed');
                scope.editdescription.geometryStatus = 'endRulesExecuted';

                if (scope.menuContext) {
                  const index = scope.menuContext.findIndex(fn => Array.isArray(fn) && fn[0] === Valider[0]);
                  if (index > -1) {
                    scope.menuContext.splice(index, 1);
                  }
                }
                if (
                  scope.ClickedButtonValider &&
                  !scope.editdescription.fti.historicFtiUid
                ) {
                  scope.save();
                  scope.ClickedButtonValider = false;
                } else if (
                  scope.ClickedButtonValider &&
                  scope.editdescription.fti.historicFtiUid
                ) {
                  var ans = confirm(
                    $filter('translate')(
                      'bizedition.menuContext.validateHistory'
                    )
                  );
                  if (ans) scope.save();
                  scope.ClickedButtonValider = false;
                }

                scope.$emit('setUpdatesToSave', { value: true });
              },
              function(errorReason) {
                if (errorReason && errorReason.type === 'zoneInterdite') {
                  require('toastr').error('Annulation du dessin');
                } else if (errorReason && typeof errorReason === 'string') {
                  console.error(
                      'EditRulesFactory.executeEndRules, error:' + errorReason
                  );
                }
                $timeout(() => {
                  scope.reset();
                });
              }
            );
          }
        };

        /**
         * Factorisation de code qui semble mort
         * @param editdescription
         */
        const openAttributChoicePopup = (editdescription) => {
          scope.intersectionlayer = editdescription;
          scope.result = {};
          scope.AttributChoiseDialog = extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/bizedition/views/attributesChoice_popup.html',
            scope: scope,
            title: $filter('translate')('bizedition.mergeChoicePopupTitle'),
            showClose: false
          });
        };

        /*********************************
         EDITION DE POINT PAR COORDONNEES
         ********************************/

        /**
         * Méthode exécutée à l'évènement drawend d'une sélection d'objets ponctuels quand le mode d'édition est "Par coordonnées"
         * @param curSelFeatures objets contenus dans la dernière sélection effectuée par l'utilisateur (par polygone, par rectangle de sélection...)
         * @return {boolean} true s'il y a plusieurs objets actuellement sélectionnés,
         * false s'il n'y a qu'un seul objet sélectionné ou bien si le mode "Main levée" est sélectionné
         */
        const preventMultiUpdateWhenCoordinatesMode = (curSelFeatures) => {
          let featurestoCount;
          const currentSelectionFeatures = GEOJSON_FORMAT.readFeatures(curSelFeatures);
          switch(scope.selectionType.value) {
            case 'new':
              featurestoCount = currentSelectionFeatures.length;
              break;
            case 'add':
              // on ajoute les objets dernièrements sélectionnés à la selection existante
              const selectedFeatures = scope.selectedFeatures.slice();
              featurestoCount = selectedFeatures.concat(currentSelectionFeatures.filter(isFeatureToAdd)).length;
              break;
            default:
              featurestoCount = currentSelectionFeatures.length;
          }
          if (featurestoCount > 1) {
            swal({
                  title: "",
                  text: $filter('translate')
                  ('bizedition.bycoords.multiSelectForbidden'),
                  type: 'error',
                  confirmButtonColor: '#F50072',
                  showCancelButton: false,
                  confirmButtonText: $filter('translate')('common.ok'),
                  showConfirmButton: true,
                });
            return true;
          }
          return false;
        };

        /**
         * Vérifie si le mode d'édition actuel est "Par coordonnées"
         * et si la géométrie du fti sélectionné dans l'autocomplete est bien un ponctuel
         * @return {boolean} true si le mode d'édition est "Par coordonnées" et si le fti courant est un ponctuel
         */
        const isEditingPointByCoordinates = () => {
          return gaJsUtils.notNullAndDefined(scope.drawMode) && scope.drawMode.point === 'coord'
              && (scope.selectfti.typeInfo === 'POINT' || scope.selectfti.typeInfo === 'MULTIPOINT');
        };

        /**
         * Transforme en nombre les coordonnées saisis dans les inputs de la popup d'édition d'un point par coordonnées
         */
        const setPointCoordinatesFromPopup = () => {
          scope.xconstraint = scope.draftPointCoords.x;
          scope.yconstraint = scope.draftPointCoords.y;
        };

        /**
         * Dans la popup d'édition d'un point par coordonnées, vérifie si le texte saisi dans les inputs sont bien des nombres
         * @return {boolean} true si le texte saisi dans les deux inputs sont des nombres
         */
        scope.isPointCoordinatesValid = () => {
          return Number.isFinite(scope.draftPointCoords.x) && Number.isFinite(scope.draftPointCoords.y);
        };

        /**
         * Au clic sur le bouton "Déplacer le point" de la popup d'édition d'un point par coordonnées:<ul><li>
         * Créé un objet ponctuel dans la couche de dessin temporaire</li><li>
         * Créé un objet ponctuel dans la couche de sélection</li><li>
         * Ajoute l'objet créé dans l'objet d'édition <code>editdescription.feature</code></li><li>
         * Active le bouton de sauvegarde des modification (disquette)</li></ul>
         */
        scope.movePointByCoordinates = () => {
          gclayers.getDrawLayer().getSource().clear();
          gclayers.getselectSource().clear();
          setPointCoordinatesFromPopup();

          const hasSelectDistinctSrid = gaJsUtils.notNullAndDefined(scope.selectedsrid, 'name')
              && typeof scope.selectedsrid.name === 'string' && scope.selectedsrid.name.length > 0
              && scope.selectedsrid.name !== mapProjCode;
          const editedPointCoords = [scope.xconstraint, scope.yconstraint];
          const pointCoordsInMapProj = hasSelectDistinctSrid ? ol.proj.transform(editedPointCoords,
              scope.selectedsrid.name, mapProjCode) : editedPointCoords;

          const tempFeature = new ol.Feature({
            geometry: new ol.geom.Point(pointCoordsInMapProj),
          });
          gclayers.getDrawLayer().getSource().addFeature(tempFeature);
          gclayers.getselectSource().addFeatures([tempFeature]);
          if (EditRulesFactory.applyRules()) {

            // Affichage du bouton "Exécuter les règles métier onEnd"
            scope.editdescription.geometryStatus = 'readyToApplyEndRule';

            // Clignotement du bouton "Exécuter les règles métier onEnd"
            bizeditProvider.startApplyRulesButtonBlinking();
          } else {
            scope.onModifyEnd();
          }
        };

        /**
         * Au clic sur le bouton "Annuler" de la popup d'édition des coordonnées d'un point:<ul><li>
         * Supprime la puce géogragraphique.</li><li>
         * Désactive la fonction de modification géographique</li></ul>
         */
        scope.cancelPointByCoordinates = () => {
          scope.reset();
        };

        /**
         * Après sélection rectangulaire d'un objet ponctuel,
         * prépare les variables nécessaires à la modification d'un objet par coordonnées
         * puis ouvre la popup d'édition d'un point par coordonnées
         */
        const openEditPointByCoordinates = () => {
          const coords = scope.editdescription.editedfeature.getGeometry().getCoordinates();
          scope.draftPointCoords = {
            x: coords[0],
            y: coords[1]
          };

          // popup unique pour la création et la modification de point par coordonnées
          // popupToEdit est la variable permettant de faire varier le texte du bouton success et les méthodes exécutées au clic
          scope.popupToEdit = true;
          scope.isEditionPopupOpened = true;

          // désactive la sélection polygonale pendant l'ouverture de la popup
          // pour faciliter le déplacement de la popup sur la carte
          dragBox.setActive(false);
          let isClosingPopup = false;
          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/bizedition/views/modals/modal.bizeditpoint.coords.html',
            className: 'ngdialog-theme-plain bizeditpoint-modal',
            closeByDocument: false,
            draggable: true,
            showClose: false,
            title: $filter('translate')('bizedition.bycoords.editModalTitle'),
            scope: scope,
            preCloseCallback: () => {
              if (!isClosingPopup) {
                bizeditProvider.removeMarkerLayer(scope.map);
                scope.popupToEdit = false;
                scope.isEditionPopupOpened = false;
                isClosingPopup = true;
              }
            }
          });
        };

        /*******************************************************
         EDITION DE POINT PAR DISTANCE (POSITIONNEMENT LINEAIRE)
         ******************************************************/

        /**
         * Vérifie si le mode d'édition actuel est "Par coordonnées"
         * et si la géométrie du fti sélectionné dans l'autocomplete est bien un ponctuel
         * @return {boolean} true si le mode d'édition est "Par coordonnées" et si le fti courant est un ponctuel
         */
        const isEditingPointByDistance = () => {
          return gaJsUtils.notNullAndDefined(scope.drawMode) && scope.drawMode.point === 'lineaire'
              && (scope.selectfti.typeInfo === 'POINT' || scope.selectfti.typeInfo === 'MULTIPOINT');
        };

        /**
         * A la fin du parcours réseau,
         * on passe la variable à true pour permettre l'activation du bouton "Créer le point"
         * de la popup "Positionnement de l'objet ponctuel"
         */
        scope.onNetworkPathFinish = () => {
          if (scope.editdescription.editedfeature) {
            switch (scope.editdescription.editedfeature.getGeometry().getType()) {
              case 'LineString':
              case 'MultiLineString':
                scope.lineByDistance.validators.hasConnection = false;
                scope.lineByDistance.validators.hasPath = true;
                break;
              case 'Point':
              case 'MultiPoint':
                scope.pointByDistance.validators.hasPosition = false;
                scope.pointByDistance.validators.hasPath = true;
                break;

            }
          }
        };

        /**
         * Après un clic sur le bouton "Sélectionner le noeud amont" (random) pour démarrer la saisie d'un parcours réseau,
         * le composant du parcours réseau envoie cet évèmenent.<br>
         * Il permet de détecter quand l'utilisateur démarre une session de dessin de parcours.
         * Ré-initialise la variable qui gère l'activation et le clignotement du bouton "Calculer"
         */
        scope.$on('networkPathDrawActivation',(event, isActivated) => {
          if (isActivated && scope.editdescription.editedfeature) {
            switch (scope.editdescription.editedfeature.getGeometry().getType()){
              case 'LineString':
              case 'MultiLineString':
                scope.lineByDistance.validators.hasPath = false;
                break;
              case 'Point':
              case 'MultiPoint':
                scope.pointByDistance.validators.hasPath = false;
                break;
            }
          }
        });

        /**
         * Gère l'activation du bouton "Calculer" de la popup "Positionnement de l'objet ponctuel"
         * @return {boolean|boolean} true si une distance est saisie et si le parcours réseau est valide
         */
        scope.isPointDistanceFormValid = () => {
          return Number.isFinite(scope.pointByDistance.distance) && scope.pointByDistance.validators.hasPath;
        };

        /**
         * Au clic sur le bouton "Calculer" de la popup "Positionnement de l'objet ponctuel"
         * Place un marqueur à l'emplacement calculé du point sur le parcours réseau
         * Centre la carte sur le marqueur
         */
        scope.drawMarkerOnPathByDistance = () => {
          if (gaJsUtils.notNullAndDefined(scope.networkPath, 'fullData.path.geometry')) {
            bizeditProvider.drawMarkerOnPathByDistance(scope.map,
                scope.networkPath.fullData.userDirectionPath, scope.pointByDistance);
          } else {
            console.error('Aucun parcours réseau. networkPath = ', scope.networkPath);
          }
        };

        /**
         * Au clic sur le bouton "Déplacer le point" de la popup "Positionnement de l'objet ponctuel",
         * déplace le point sélectionné
         */
        scope.movePointByDistance = () => {

          gclayers.getDrawLayer().getSource().clear();
          gclayers.getselectSource().clear();

          const tempFeature = new ol.Feature({
            geometry: new ol.geom.Point(scope.pointByDistance.coords),
          });

          gclayers.getDrawLayer().getSource().addFeature(tempFeature);
          gclayers.getselectSource().addFeatures([tempFeature]);

          if (EditRulesFactory.applyRules()) {

            // Affichage du bouton "Exécuter les règles métier onEnd"
            scope.editdescription.geometryStatus = 'readyToApplyEndRule';

            // Clignotement du bouton "Exécuter les règles métier onEnd"
            toggleApplyRulesButtonBlinking();
          } else {
            scope.onModifyEnd();
          }
        };

        /**
         * Au clic sur le bouton "Annuler" de la popup "Positionnement d'un objet ponctuel",
         * purge et retire la layer du marqueur de l'emplacement du point
         * purge et retire la layer du parcours réseau
         * puis re-initialise le widget
         */
        scope.cancelPointByDistance = () => {
          scope.reset();
        };

        /**
         * Après sélection rectangulaire d'un objet ponctuel à modifier,
         * prépare les variables nécessaires à la modification par positionnement linéaire
         * puis ouvre la popup de modification d'un point par positionnement linéaire
         */
        const openEditPointByDistance = () => {
          // distance entre le noeud de départ du parcours réseau et la position sur le tronçon
          scope.pointByDistance = {
            distance: null,
            validators: {
              hasPath: false,
              hasPosition: false
            },
            coords: scope.editdescription.editedfeature.getGeometry().getCoordinates()
          };

          // popup unique pour la création et la modification de point par coordonnées
          // popupToEdit est la variable permettant de faire varier le texte du bouton success et les méthodes exécutées au clic
          scope.popupToEdit = true;

          // désactive la sélection polygonale pendant l'ouverture de la popup
          // pour faciliter le déplacement de la popup sur la carte
          dragBox.setActive(false);

          // variables fournies au composant gcpathselect
          scope.networkPath = {};
          scope.config = {
            netname: scope.network,
            minnodes: 2,
            maxnodes: 50,
            nodesincr: 1
          }
          // empêche une double-exécution du preCloseCallback
          let isClosingPopup = false;

          // empêche d'ouvrir des popups supplémentaires
          scope.isEditionPopupOpened = true;

          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/bizedition/views/modals/modal.bizeditpoint.distance.html',
            className: 'ngdialog-theme-plain noclose bizeditpoint-modal',
            closeByDocument: false,
            draggable: true,
            showClose: false,
            title: $filter('translate')('bizedition.bydist.editModalTitle'),
            scope: scope,
            preCloseCallback: () => {
              if (!isClosingPopup) {
                bizeditProvider.removeMarkerLayer(scope.map);
                bizeditProvider.networkPathLayersCleanRemoval(scope.map);
                bizeditProvider.networkSelectInteractionRemoval(scope.map);
                scope.popupToEdit = false;
                scope.isEditionPopupOpened = false;
                isClosingPopup = true;
              }
            }
          });
        };

        /********************************
         EDITION DE LIGNE PAR COORDONNEES
         ********************************/

        /**
         * Vérifie si le mode d'édition actuel est "Par coordonnées"
         * et si la géométrie du fti sélectionné dans l'autocomplete est bien un ponctuel
         * @return {boolean} true si le mode d'édition est "Par coordonnées" et si le fti courant est un ponctuel
         */
        const isEditingLineByCoordinates = () => {
          return gaJsUtils.notNullAndDefined(scope.drawMode) && scope.drawMode.line === 'coord'
              && (scope.selectfti.typeInfo === 'LINE' || scope.selectfti.typeInfo === 'MULTILINE');
        };

        /**
         * Exécuté après la sélection d'une ligne à modifier au moment de l'ouverture de la popup "Créer une ligne par coordonnées".<br>
         * Exécuté aussi à la suppression d'un sommet de ligne.<br>
         * Affiche provisoirement la ligne en cours de création si le tableau de coordonnées a une longueur supérieure à 1.
         * Si la longueur du tableau de coordonnées de la directive est inférieure à 2 alors la couche du tracé est enlevée de la carte.
         * @param {number|null} index rang du sommet de ligne dont on modifie les coordonnées XY.
         * Cela permet d'éviter de déclencher le tracé de ligne après saisie de la coordonnée X alors que Y n'est pas encore saisi (null).
         * @param {boolean} hasDeletedVertex est true quand la méthode est exécutée au clic sur un bouton "supprimer le sommet" (corbeille) {@link deleteVertex}
         * puisque le tracé doit être rafraîchi après suppression d'un sommet de ligne.
         * @param {boolean} isStartingEditLine est true quand la méthode est exécutée à l'ouverture de la popup "Edition d'une ligne par coordonnées" après sélection d'un objet ligne
         */
        scope.buildDraftLineByCoords = (index, hasDeletedVertex, isStartingEditLine = false) => {
          bizeditProvider.buildDraftLineByCoords(scope.map, scope.lineByCoords, scope.selectedsrid, index, hasDeletedVertex, isStartingEditLine, mapProjDescription);
        };

        /**
         * Après sélection rectangulaire d'un objet ponctuel,
         * prépare les variables nécessaires à la modification d'un objet par coordonnées
         * puis ouvre la popup d'édition d'un point par coordonnées
         */
        const openLineEditByCoordinates = () => {
          // lineByCoords contient les coordonnées sous forme de float ET aussi de string
          scope.lineByCoords = scope.editdescription.editedfeature.getGeometry().getCoordinates()[0];

          scope.buildDraftLineByCoords(null, false, true);

          // popup unique pour la création et la modification de point par coordonnées
          // popupToEdit est la variable permettant de faire varier le texte du bouton success et les méthodes exécutées au clic
          scope.popupToEdit = true;

          scope.isEditionPopupOpened = true;

          // désactive la sélection polygonale pendant l'ouverture de la popup
          // pour faciliter le déplacement de la popup sur la carte
          dragBox.setActive(false);

          let isClosingPopup = false;
          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/bizedition/views/modals/modal.bizeditline.coords.html',
            className: 'ngdialog-theme-plain bizeditline-modal',
            closeByDocument: false,
            draggable: true,
            showClose: false,
            title: $filter('translate')('bizedition.bycoords.line.editModalTitle'),
            scope: scope,
            preCloseCallback: () => {
              if (!isClosingPopup) {
                scope.popupToEdit = false;
                scope.isEditionPopupOpened = false;
                bizeditProvider.removeMarkerLayer(scope.map);
                bizeditProvider.draftLineByCoordsCleanRemoval(scope.map);
                isClosingPopup = true;
              }
            }
          });
        };

        /**
         * Ajoute un nouveau sommet dans la ligne en cours de création
         * depuis la popup "Création d'une ligne par coordonnées"
         */
        scope.addVertex = () => {
          scope.lineByCoords.push([null, null]);
        };

        /**
         * Au clic sur le bouton "Supprimer le sommet" (poubelle) dans la popup "Créer une ligne par coordonnées".
         * Supprime un sommet de la ligne en cours de construction.<br>
         * Rafraîchit le dessin provisoire de la ligne
         * @param {number} index rang du sommet à supprimer
         */
        scope.deleteVertex = (index) => {
          if (Number.isInteger(index) && Array.isArray(scope.lineByCoords) && scope.lineByCoords.length > index) {
            scope.lineByCoords.splice(index, 1);

            // le tracé doit être rafraîchi après suppression d'un sommet de ligne
            scope.buildDraftLineByCoords(null, true);
          }
        };

        /**
         * Vérifie si les coordonnées XY du sommet de ligne respecte un format numérique
         * @param index rang du sommet dans les coordonnées de la ligne.
         * Si aucun index fourni alors index est égal au dernier rang du tableau de coordonnées de la ligne
         * @return {boolean} true si les coordonnées du sommet respectent un format numérique
         */
        scope.isVertexValid = (index) => {
          if (Array.isArray(scope.lineByCoords)) {

            // si aucun index est fourni, on teste le dernier sommet de la ligne
            if (!Number.isInteger(index)) {
              index = scope.lineByCoords.length -1;
            }

            if (scope.lineByCoords.length > index) {
              return Number.isFinite(scope.lineByCoords[index][0])
                  && Number.isFinite(scope.lineByCoords[index][1]);
            }
          }
          return false;
        };

        /**
         * Positionne un marqueur sur le sommet de la ligne en cours de création
         * @param {number} index rang du sommet parmi les sommets de la ligne
         */
        scope.getVertexPosition = (index) => {
          bizeditProvider.getVertexPosition(scope.map, scope.lineByCoords, scope.selectedsrid, index);
        };


        /**
         * Au clic sur le bouton "Annuler" dans la popup "Créer une ligne par coordonnées".
         * Enlève les couches du marqueur et du tracé provisoire de la ligne.
         * Ré-initialise le widget.
         */
        scope.cancelLineByCoordinates = () => {
          scope.reset();
        };

        /**
         * Au clic sur le bouton "Modifier la ligne"
         * de la popup "Editer une ligne par coordonnées"
         */
        scope.editLineByCoordinates = () => {
          gclayers.getDrawLayer().getSource().clear();
          gclayers.getselectSource().clear();

          // création de la feature ol MultiLiString
          const lineGeometry = new ol.geom.MultiLineString([scope.lineByCoords]);
          const lineFeature = new ol.Feature({
            geometry: lineGeometry,
          });

          gclayers.getDrawLayer().getSource().addFeature(lineFeature);
          gclayers.getselectSource().addFeatures([lineFeature]);
          scope.editdescription.editedfeature.getGeometry().setCoordinates([scope.lineByCoords]);

          if (EditRulesFactory.applyRules()) {

            // Affichage du bouton "Exécuter les règles métier onEnd"
            scope.editdescription.geometryStatus = 'readyToApplyEndRule';

            // Clignotement du bouton "Exécuter les règles métier onEnd"
            bizeditProvider.startApplyRulesButtonBlinking();
          } else {
            scope.editdescription.geometryStatus = 'modifiedAndNotSaved';
            scope.$emit('geometryHasBeenModified');
          }
        };

        /**
         * Dans la popup "Création de la ligne par coordonnées".
         * Teste si deux points valides sont saisis pour activer/désactiver le bouton "Modifier la ligne"
         */
        scope.hasTwoCoordinatesValid = () => {
          return bizeditProvider.hasTwoCoordinatesValid(scope.lineByCoords);
        };

        /***********************************************************+***
         EDITION DE LIGNE PAR POSITIONNEMENT LINEAIRE (branchements ass)
         **************************************************************/

        const CONNECTION_LAYER_ID = bizeditProvider.CONNECTION_LAYER_ID;

        /**
         * Vérifie si le mode d'édition actuel est "Par coordonnées"
         * et si la géométrie du fti sélectionné dans l'autocomplete est bien un ponctuel
         * @return {boolean} true si le mode d'édition est "Par coordonnées" et si le fti courant est un ponctuel
         */
        const isEditingLineByDistance = () => {
          return gaJsUtils.notNullAndDefined(scope.drawMode) && scope.drawMode.line === 'lineaire'
              && (scope.selectfti.typeInfo === 'LINE' || scope.selectfti.typeInfo === 'MULTILINE');
        };

        /**
         * Au clic sur le bouton "Edition géométrique" (curseur)
         * pour démarrer l'édition d'une ligne en mode "par positionnement linéaire" :<ul><li>
         * initialise un tableau de coordonnées</li><li>
         * exécute les règles métiers <code>onInit</code></li><li>
         * ouvre la popup "Edition de ligne par positionnement linéaire"</li></ul>
         */
        const openEditLineByDistance = () => {
          const editedFeatGeometry = scope.editdescription.editedfeature.getGeometry();
          let connection;
          if (editedFeatGeometry.getType() === 'LineString') {
            connection = scope.editdescription.editedfeature.clone();
          } else {
            connection = new ol.Feature({
              geometry: editedFeatGeometry.getLineStrings()[0].clone()
            });
          }

          connection.setStyle(bizeditProvider.CONNECTION_PATH_STYLE);

          const startNode = new ol.Feature({
            geometry: new ol.geom.Point(editedFeatGeometry.getFirstCoordinate())
          });
          const endNode = new ol.Feature({
            geometry: new ol.geom.Point(editedFeatGeometry.getLastCoordinate())
          });
          startNode.setStyle(bizeditProvider.CONNECTION_NODE_STYLE);
          endNode.setStyle(bizeditProvider.CONNECTION_NODE_STYLE);

          const connectionLayer = mapJsUtils.addOrGetLayerByProperty(scope.map, 'id', CONNECTION_LAYER_ID);
          const source = new ol.source.Vector({
            features: [connection, startNode, endNode]
          });
          connectionLayer.setSource(source);
          connectionLayer.setZIndex(10006);

          // centre la carte sur la ligne à éditer
          centerMapOnEditedGeometry(editedFeatGeometry);

          // Initialise les variables de la popup
          scope.lineByDistance = {
            side: 'left',
            angle: null,
            distance: null,
            length: roundEditedGeometryLength(editedFeatGeometry),
            validators: {
              hasPath: false,
              hasConnection: false
            }
          };

          // Initialise les données du parcours réseau
          scope.networkPath = {};
          scope.config = {
            netname: scope.network,
            minnodes: 2,
            maxnodes: 50,
            nodesincr: 1
          }
          // permet au template HTML d'appeler les méthodes pour l'édition et d'afficher les textes relatifs à l'édition
          // car le HTML est partagé avec la fonction de création
          scope.popupToEdit = true;

          // change la classe CSS du bouton
          scope.isActive = true;

          // désactive les intéractions pour faciliter le déplacement de la carte en arrière-plan
          draw.setActive(false);
          dragBox.setActive(false);

          scope.isEditionPopupOpened = true;
          let isClosingPopup = false;
          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/bizedition/views/modals/modal.bizeditline.distance.html',
            className: 'ngdialog-theme-plain noclose bizeditline-distance-modal',
            closeByDocument: false,
            draggable: true,
            showClose: false,
            title: $filter('translate')('bizedition.bydist.line.editModalTitle'),
            scope: scope,
            preCloseCallback: () => {
              if (!isClosingPopup) {
                scope.isEditionPopupOpened = false;
                bizeditProvider.removeConnectionLayer(scope.map);
                bizeditProvider.networkPathLayersCleanRemoval(scope.map);
                scope.map.getInteractions().forEach( interaction => {
                  if (interaction.get('id') === 'network-path-select' || interaction.get('id') === 'network-node-select') {
                    interaction.setActive(false);
                    scope.map.removeInteraction(interaction);
                  }
                });
                isClosingPopup = true;
                scope.popupToEdit = false;
              }
            }
          });
        };

        /**
         * Dans la popup "Création de ligne par positionnement linéaire",
         * vérifie que la valeur de distance saisie soit un nombre et que la valeur soit comprise entre 0 et 100 (bornes comprises)
         * @return {boolean} true si la distance est un nombre compris entre 0 et 100 (bornes comprises)
         */
        scope.isLineDistanceValid = () => {
          return Number.isFinite(scope.lineByDistance.distance)
              && scope.lineByDistance.distance >= 0 && scope.lineByDistance.distance <= 100;
        };

        /**
         * Dans la popup "Création de ligne par positionnement linéaire",
         * vérifie que la valeur d'angle saisie soit un nombre et que celui-ci soit compris entre 0 et 180 (bornes comprises)
         * @return {boolean} true si l'angle est un nombre compris entre 0 et 180 (bornes comprises)
         */
        scope.isLineAngleValid = () => {
          return Number.isFinite(scope.lineByDistance.angle)
              && scope.lineByDistance.angle >= 0 && scope.lineByDistance.angle <= 180;
        };

        /**
         * Dans la popup "Création de ligne par positionnement linéaire",
         * vérifie que la valeur de longueur saisie soit un nombre et que celui-ci soit compris entre 0 et 1000.
         * @return {boolean} true si la longueur est un nombre compris entre 0 et 1000 (strictement supérieur à 0, 1000 inclus)
         */
        scope.isLineLengthValid = () => {
          return Number.isFinite(scope.lineByDistance.length)
              && scope.lineByDistance.length > 0 && scope.lineByDistance.length <= 1000;
        };

        /**
         * Gère l'activation du bouton "Calculer" de la popup "Positionnement de l'objet linéaire"
         * @return {boolean} true si les champs sont renseignés et si le parcours réseau est valide
         */
        scope.isLineFormValid = () => {
          return scope.isLineDistanceValid() && scope.isLineAngleValid() && scope.isLineLengthValid() && scope.lineByDistance.validators.hasPath;
        };

        /**
         * Au clic sur le bouton "Calculer" de la popup "Positionnement de l'objet linéaire"
         * Affiche la ligne calculée à partir des données saisies dans la popup.
         * La ligne est recalculée à chaque changement de valeur d'un input (hormis la distance)
         */
        scope.calculateAndDrawConnection = () => {
          if (gaJsUtils.notNullAndDefined(scope.networkPath, 'fullData.userDirectionPath')
              && scope.lineByDistance.validators.hasPath) {
            bizeditProvider.calculateAndDrawConnection(scope.map, scope.networkPath, scope.lineByDistance);
          }
        };

        /**
         * Au clic sur le bouton "Annuler" de la popup "Positionnement linéaire d'une ligne":<ul><li>
         * purge et retire la layer du marqueur de l'emplacement du raccord</li><li>
         * purge et retire les layers du parcours réseau</li><li>
         * puis re-initialise le widget</li></ul>
         */
        scope.cancelLineByDistance = () => {
          scope.reset();
        };

        /**
         * Au clic sur le bouton "Modifier la ligne"
         * de la popup "Editer une ligne par positionnement linéaire"
         */
        scope.editLineByDistance = () => {
          gclayers.getDrawLayer().getSource().clear();
          gclayers.getselectSource().clear();

          const connectionLayer = scope.map.getLayers().getArray().find(layer => layer.get('id') === CONNECTION_LAYER_ID);
          if (connectionLayer && connectionLayer.getSource() && connectionLayer.getSource().getFeatures().length > 0) {
            // copie de la géométrie
            const tempFeature = connectionLayer.getSource().getFeatures().find(feat => feat.get('id') === 'connection-feature');
            if (tempFeature) {

              // supprime la propriété 'id' pour ne pas provoquer de ClassCastException
              tempFeature.unset('id');

              scope.editdescription.editedfeature.setGeometry(tempFeature.getGeometry());

              // supprime le style particulier du branchement pour prendre le style par défaut des couche de dessin et de sélection
              tempFeature.setStyle(null);

              gclayers.getDrawLayer().getSource().addFeature(tempFeature);
              gclayers.getselectSource().addFeatures([tempFeature]);

              if (EditRulesFactory.applyRules()) {

                // Affichage du bouton "Exécuter les règles métier onEnd"
                scope.editdescription.geometryStatus = 'readyToApplyEndRule';

                // Clignotement du bouton "Exécuter les règles métier onEnd"
                bizeditProvider.startApplyRulesButtonBlinking();
              } else {
                // envoie à bizeditwidget un évènement de fin de mise à jour géométrique
                scope.editdescription.geometryStatus = 'modifiedAndNotSaved';
                scope.$emit('geometryHasBeenModified');
              }
            } else {
              require('toastr').error($filter('translate')('bizedition.bydist.line.noCurrentLine'));
              console.error('editLineByDistance : aucune ligne dans la layer \'connectionLayer\'');
            }
          }
        };

        /**
         * Après sélection d'un objet linéaire à éditer par positionnement linéaire.
         * Centre la carte sur la ligne à éditer
         * @param {ol.geom.LineString|ol.geom.MultiLineString} line ligne à éditer par positionnement linéaire
         */
        const centerMapOnEditedGeometry = (line) => {
          let lineCenter;
          if (line.getType() === 'LineString') {
            lineCenter = line.getCoordinateAt(0.5);
          } else {
            const editedLineLength = mapJsUtils.getMultiLineStringLength(line);
            lineCenter = mapJsUtils.getMultiLineStringCoordinatesAt(line, null, editedLineLength / 2)
          }
          scope.map.getView().setCenter(lineCenter);
        };

        /**
         * Récupère la longueur de la ligne à éditer et arrondit la valeur à 3 décimales ou à l'entier le plus proche
         * @param line ligne à éditer par positionnement linéaire
         * @return {number} nombre double ou entier correspondant à la longueur de la ligne à éditer par positionnement linéaire
         */
        const roundEditedGeometryLength = (line) => {
          let editedGeomLength;
          if (line.getType() === 'LineString') {
            editedGeomLength = line.getLength();
          } else {
            editedGeomLength = mapJsUtils.getMultiLineStringLength(line);
          }
          let lengthString = editedGeomLength.toFixed(3);
          if (lengthString.endsWith('000') && lengthString.includes('.')) {
            lengthString = lengthString.split('.').shift();
          }
          return Number.parseFloat(lengthString);
        };

        /**
         * Récupère les objets dont la géométrie vient d'être modifiée
         * par l'intéraction Modify
         * @param {ol.Collection} featureCollection features ol déclarés dans l'intéraction
         * @param {ol.Coordinate} coordinate coordonnées du curseur lorsque le clic est relâché
         * @return {ol.Feature[]} features openlayers qui ont subi la modification géométrique
         */
        const findModifiedFeatures = (featureCollection, coordinate) => {
          const modifiedFeatures = [];
          for (const feature of featureCollection.getArray()) {
            const geometry = feature.getGeometry();
            if (mapJsUtils.geometryContainsCoordinate(geometry, coordinate)) {
              modifiedFeatures.push(feature);
            }
          }
          return modifiedFeatures;
        };

        /**
         * Affiche et déplace le bouton "Exécuter les règles métier" vers la ligne du bouton "Valider"
         * Ce déplacement JS évite de déplacer du vieux code de bizeditmultiupdate vers bizeditsave
         */
        const moveApplyRulesButton = () => {
          // à l'initialisation de bizeditwidget, le bouton est contenu dans le template de bizeditwidget
          let button = elt[0].querySelector('#onModifyEnd');
          if (button) {
            const widget = button.closest('.EditWidgetLocal');
            if (widget) {
              const applyRulesContainer = widget.querySelector('#bizedit-applyRulesContainer');
              if (applyRulesContainer) {
                button.classList.remove('hidden');
                applyRulesContainer.appendChild(button);
              }
            }
          } else {
            // après réinitialisation, le bouton est contenu dans le template de bizeditsave
            button = document.getElementById('onModifyEnd');
            if (button && button.classList.contains('hidden')) {
              button.classList.remove('hidden');
            }
          }
        };
        // Si l'utilisateur coche la case "Appliquer les règles après une sélection d'objets
        scope.$on('bizeditmultiupdate_moveApplyRulesButton',moveApplyRulesButton);

        /**
         * Met à jour le statut de la session d'édition.
         * Le comportement varie suivant la case à cocher "Appliquer les règles métier"
         * Indique au composant parent (bizeditwidget/bizeditsave) le traitement restant:<ul><li>
         *   <code>readyToApplyEndRule</code> => application des règles (bouton engrenage) (case cochée)</li><li>
         *   <code>modifiedAndNotSaved</code> => Sauvegarde (bouton "Valider") sans application des règles (case non cochée)</li></ul>
         * <a href="https://altereo-informatique.atlassian.net/browse/KIS-3273">KIS-3273 Forcer l'exécution des règles métiers avant la validation des mises à jour géométriques</a>
         * @param {object} editdescription session d'édition métier
         */
        const updateGeometryStatus = (editdescription) => {
          if (EditRulesFactory.applyRules()) {
            editdescription.geometryStatus = 'readyToApplyEndRule';
            // KIS-3319
            bizeditProvider.startApplyRulesButtonBlinking();
          } else {
            editdescription.geometryStatus = 'modifiedAndNotSaved';
            scope.$emit('geometryHasBeenModified');
          }
        };

        /**
         *Dès que le bouton d’exécution des règles devient actif
         * alors il devient clignotant jusqu'à ce que l’utilisateur ait cliqué dessus.
         * <a href="https://altereo-informatique.atlassian.net/browse/KIS-3319">KIS-3319 [DEA - Edition] : Amélioration lors de la Mise à jour géométrique</a>
         */
        const toggleApplyRulesButtonBlinking = () => {
          bizeditProvider.toggleApplyRulesButtonBlinking();
        };
      },
    };
  };

  gcelement.$inject = [
    'EditRulesFactory',
    'ogcFactory',
    'EditTypesFactory',
    'gcStyleFactory',
    'gclayers',
    'SelectManager',
    '$translate',
    'gcPopup',
    '$rootScope',
    'GeometryFactory',
    '$filter',
    'gcInteractions',
    '$timeout',
    'SridFactory',
    'extendedNgDialog',
    'gaJsUtils',
    'ObjectFilesFactory',
    'mapJsUtils',
    'bizeditProvider'
  ];
  return gcelement;
});
