'use strict';
define(function() {
  var gcelement = function(gclayers, gcInteractions, $timeout) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/bizedition/views/bizeditpolygon.html',
      restrict: 'A',
      scope: {
        map: '=map',
        drawinteraction: '=drawinteraction',
        isActive: '=isactive',
        toolbarwidget: '=?toolbarwidget',
        execrules: '&execrules', //correspond à 'performRules' dans le widget d'édition
        reset: '&',
        isGuide: '=isguide',
        createGuide: '&createguide',
        updateGuide: '&updateguide',
        guide: '&',
        stopGuide: '&stopguide',
        isGuideOrth: '=isguideorth',
        penteLine: '&penteline',
        updateGuideOrth: '&updateguideorth',
        startGuideOrth: '&startguideorth',
        stopGuideOrth: '&stopguideorth',
        srid: '=?', // sans srid, les dessins de cercles, ellipses et lignes ne respectent pas les distances
        isAttributePopupOpen: '=?'
      },
      link: function(scope) {
        scope.drawinteraction = {};

        function sqr(a) {
          return a * a;
        }
        /**
         * [createEllipsePointCoords fonction de calcul des coordonnées d'un ellipse]
         * @param  {number} ellipseCenterX [description]
         * @param  {number} ellipseCenterY [description]
         * @param  {number} ellipseRadius  [description]
         * @param  {number} pointsToFind  [description]
         * @return {[array]}               [description]
         */
        scope.createEllipsePointCoords = function(
          ellipseCenterX,
          ellipseCenterY,
          ellipseRadius,
          pointsToFind
        ) {
          var angleToAdd = 360 / pointsToFind;
          var coords = [];
          // on choisit un deuxième rayon de l'ellipse égale à la moitié du premier
          var ellipseRadius2 = ellipseRadius / 2;
          var angle = 0;
          for (var i = 0; i < pointsToFind; i++) {
            angle = angle + angleToAdd;
            var coordX =
              ellipseCenterX +
              ellipseRadius * Math.cos((angle * Math.PI) / 180);
            var coordY =
              ellipseCenterY +
              ellipseRadius2 * Math.sin((angle * Math.PI) / 180);
            coords.push([coordX, coordY]);
          }
          return coords;
        };

        scope.isDistanceConstraint = false;
        scope.distanceConstraint = 5;

        /**
         * Au changement de sélection d'une forme régulière
         */
        scope.$watch('typeSelect', (newval, oldval) => {
          if (newval !== oldval) {
            scope.map.removeInteraction(scope.drawinteraction);
            scope.isActive = false;
            scope.add();
          }
        });

        /**
         * Méthode appelée au clic sur le bouton correspondant à cette directive.
         */
        scope.add = function() {
          //Activation si désactivé et desactivation si activé
          scope.isActive = !scope.isActive;

          // réinitialise la case à cocher "Rayon" du dessin de cercle
          scope.isDistanceConstraint = false;

          if (!scope.isActive) {
            scope.reset();
            return;
          }

          var map = scope.map;

          //scope.isActive = true;

          if (scope.isActive) {
            /***** Ajout des choix regular shape (cercle, ellipse, carré , rectangle) *****/
            /// définition de la géometry pour chaque cas
            var value1;
            var geometryFunction, maxPoints;
            if (scope.typeSelect === 'Circle') {
              value1 = 'Circle';
              geometryFunction = function(inputCoordinates, geometry) {
                if (!geometry) {
                  geometry = new ol.geom.Polygon(null);
                }
                const mapProjection = map.getView().getProjection().getCode();
                // re-projection avant calcul: du srid de la map vers srid du fti
                const coordinates = scope.srid ? transformCoordinates(inputCoordinates,
                    mapProjection, scope.srid) : inputCoordinates;

                var center = coordinates[0];
                var last = coordinates[1];
                var dx = center[0] - last[0];
                var dy = center[1] - last[1];
                let radius;
                if (
                  scope.isDistanceConstraint &&
                  angular.isDefined(scope.distanceConstraint)
                ) {
                  radius = scope.distanceConstraint;
                } else {
                  radius = Math.sqrt(dx * dx + dy * dy);
                }

                var rotation = Math.atan2(dy, dx);
                var newCoordinates = [];
                var numPoints = 360;
                for (var i = 0; i < numPoints; ++i) {
                  var angle = rotation + (i * 2 * Math.PI) / numPoints;
                  var fraction = 1;
                  var offsetX = radius * Math.cos(angle);
                  var offsetY = radius * Math.sin(angle);
                  // console.log(Math.sqrt(offsetX * offsetX + offsetY * offsetY));
                  newCoordinates.push([
                    center[0] + offsetX,
                    center[1] + offsetY,
                  ]);
                }
                newCoordinates.push(newCoordinates[0].slice());
                // // re-projection après calcul : du srid du fti vers la projection de la carte
                const outputCoordinates = scope.srid ? transformCoordinates(newCoordinates,
                    scope.srid, mapProjection) : newCoordinates;
                geometry.setCoordinates([outputCoordinates]);
                return geometry;
              };
            } else if (scope.typeSelect === 'Ellipse') {
              value1 = 'LineString';
              maxPoints = 2;
              geometryFunction = function(coordinates, geometry) {
                if (!geometry) {
                  geometry = new ol.geom.Polygon(null);
                }
                var centerCoord = coordinates[0];
                var refCoord = coordinates[1];
                var dX = centerCoord[0] - refCoord[0];
                var dY = centerCoord[1] - refCoord[1];
                var rayon = Math.sqrt(sqr(dX) + sqr(dY));
                var ellipseCoords = scope.createEllipsePointCoords(
                  centerCoord[0],
                  centerCoord[1],
                  rayon,
                  360
                );

                geometry.setCoordinates([ellipseCoords]);

                return geometry;
              };
            } else if (scope.typeSelect === 'Square') {
              value1 = 'Circle';
              geometryFunction = ol.interaction.Draw.createRegularPolygon(4);
            } else if (scope.typeSelect === 'Box') {
              value1 = 'LineString';
              maxPoints = 2;
              geometryFunction = function(coordinates, geometry) {
                if (!geometry) {
                  geometry = new ol.geom.Polygon(null);
                }
                var start = coordinates[0];
                var end = coordinates[1];
                geometry.setCoordinates([
                  [start, [start[0], end[1]], end, [end[0], start[1]], start],
                ]);
                return geometry;
              };
            } else value1 = 'Polygon';

            // definition de la l'interaction draw en fonction du type et de la geometry
            scope.drawinteraction = new ol.interaction.Draw({
              source: gclayers.getDrawLayer().getSource(),
              type: value1,
              geometryFunction: geometryFunction,
              maxPoints: maxPoints,
            });

            scope.drawinteraction.set('gctype', 'kis');
            scope.drawinteraction.set('interaction', 'Draw');
            scope.drawinteraction.set('widget', 'Edition');

            if (scope.isGuide) {
              scope.guide();
            }
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            map.addInteraction(scope.drawinteraction);

            //on start
            scope.drawinteraction.on('drawstart', function(evt) {
              /*sketchFeature = evt.feature;*/
              //console.log(evt.feature);
              console.log('drawstart');

              if (scope.isGuide) {
                scope.guide();
              }
              if (scope.isGuideOrth) {
                scope.startGuideOrth();
              }
              // si le rayon est défini alors on termine le dessin après le 1er clic
              if (scope.isDistanceConstraint && scope.distanceConstraint){
                scope.drawinteraction.finishDrawing();
              }
            });

            // on end
            scope.drawinteraction.on('drawend', function(evt) {
              // pour le cas d'un cercle => transformer la geometry en cercle pour pouvoir l'enregistrer  en format GeoJson
              if (evt.feature.getGeometry().getType() === 'Circle') {
                var geomCircle = evt.feature.getGeometry();
                if (
                  scope.isDistanceConstraint &&
                  angular.isDefined(scope.distanceConstraint)
                ) {
                  var geomPoly = new ol.geom.Circle(
                    geomCircle.getCenter(),
                    scope.distanceConstraint,
                    0
                  );
                } else {
                  var geomPoly = ol.geom.Polygon.fromCircle(geomCircle, 360, 0);
                }
                evt.feature.setGeometry(geomPoly);
                //geometryFunction=ol.geom.Polygon.fromCircle(evt.feature.getGeometry,32,0);

                //console.log(evt.feature.getGeometry().getCoordinates());
              }
              /// pour le cas d'une ellipse => il faut avoir le premier point et le dernier égaux
              if (scope.typeSelect === 'Ellipse') {
                var coords = evt.feature.getGeometry().getCoordinates();
                if (coords[0][0] !== coords[0][359]) {
                  coords[0][359] = coords[0][0];
                  evt.feature.getGeometry().setCoordinates(coords);
                }
              }
              scope.stopGuideOrth();
            });
          }

          // wait for any digest cycle to end
          // at the end of the digest cycle, variables that we need are set
          $timeout (() => scope.execrules());
        };

        scope.$on('runAdd', function(event, p1) {
          if (p1.geomtype == 'POLYGON') scope.add();
        });

        /**
         * Reprojète un tableau de coordonnées avec le srid d'entrée et le srid de sortie en paramètre
         * @param coordinates tableau à reprojeter
         * @param inputSrid srid d'entrée (celui de la carte ou du fti)
         * @param outputSrid srid de sortie (celui de la carte ou du fti)
         * @return {[coordinates]} tableau de coordonnées établies dans la projection ayant pour srid outputSrid
         */
        const transformCoordinates = (coordinates, inputSrid, outputSrid) => {
          let outputCoordinates = [];
          if (inputSrid === outputSrid){
            outputCoordinates = coordinates
          } else {
            for (const inputCoordinate of coordinates) {
              const outputCoordinate = ol.proj.transform(inputCoordinate, inputSrid, outputSrid);
              outputCoordinates.push(outputCoordinate);
            }
          }
          return outputCoordinates;
        };
      },
    };
  };

  gcelement.$inject = ['gclayers', 'gcInteractions', '$timeout'];
  return gcelement;
});
