'use strict';
define(function() {
  var exportxlsxfactory = function(
      PortalsFactory,
      $http
  ) {

    let portalId = PortalsFactory.getPortalId();

    /**
     * Lance l'export de fichier xlsx
     * @param territoryValue valeur du territoire à exporter
     * @param systemValue valeur du systeme à exporter
     * @param imageName nom de l'image que l'on veut ajouter
     * @param configName  nom de la configuration du widget
     * @returns {string} URL d'export qui permet d'ouvrir directement le fichier xlsx
     */
    const exportXlsxFileUrl = (territoryValue, systemValue, imageName, configName) => {
      /** KIS-3701: localStorage stocke une valeur fixe et ne change pas dynamiquement 
       * lorsque l'on ouvre plusieurs applications (aep et ass).
      **/
      let appName = angular.module('gcMain').app;
      return '/services/' + portalId + '/' + appName + '/systemsheets/exportSystemSheet' +
          '?territoryValue=' + territoryValue +
          '&systemValue=' + systemValue +
          '&imageName=' + imageName +
          '&configName=' + configName;
    };

    /**
     * Enregistre la capture d'écran passée en paramètre dans le fichier TEMP du répo
     * et nous renvoie son nom
     * @param screenshot
     * @returns {*}
     */
    const saveScreenshot = (screenshot) => {
      let appName = angular.module('gcMain').app;
      return $http.post('/services/' + portalId + '/' + appName + '/systemsheets/saveScreenshot',
        screenshot);
    };

    return {
      exportXlsxFileUrl: exportXlsxFileUrl,
      saveScreenshot: saveScreenshot
    };
  };
  exportxlsxfactory.$inject = [
      'PortalsFactory',
      '$http'
  ];
  return exportxlsxfactory;
});