'use strict';
define(function() {
  var NominatimFactory = function($http, ogcFactory, gaUrlUtils) {
    var NominatimFactory = {};
    /**
     * Class : NominatimFactory
     * Factory WebServices
     * Access to nominatim
     */

    var getSearchUrl = function(q) {
      return (
        'https://nominatim.openstreetmap.org/search?q=' +
        q +
        '&format=json&polygon_geojson=1&addressdetails=1'
      );
    };

    /**
     * Function: search
     */
    function search(q) {
      var promise = $http.get(getSearchUrl(q));

      return promise;
    }
    /**
     * Function: reverse
     */
    function reverse(coords) {
      var promise = $http.get(
        'https://nominatim.openstreetmap.org/reverse?format=json&lat=' +
          coords[1] +
          '&lon=' +
          coords[0] +
          '&zoom=18&addressdetails=1'
      );

      return promise;
    }

    /**
     * Same thing as search but via ogcproxy proxy
     */
    function searchViaProxy(q) {
      var searchUrl = getSearchUrl(encodeURIComponent(q));
      return ogcFactory.proxy(gaUrlUtils.encodeUriQuery(searchUrl));
    }

    return {
      NominatimFactory: NominatimFactory,
      search: search,
      reverse: reverse,
      searchViaProxy: searchViaProxy,
    };
  };

  NominatimFactory.$inject = ['$http', 'ogcFactory', 'gaUrlUtils'];
  return NominatimFactory;
});
