'use strict';
define(function() {
  var basemapwidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    gcPopup,
    extendedNgDialog,
    gaDomUtils,
    GeoTreatmentFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/geotreatment/views/treatments/treatGeocalcul.html',
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        scope.activetreatment = '';
        scope.res = {};
        scope.attributes_select = [];
        scope.geometricoperand = [
          'EQUALS',
          'DISJOINT',
          'INTERSECTS',
          'TOUCHES',
          'CROSSES',
          'WITHIN',
          'CONTAINS',
          'OVERLAPS',
        ];
        scope.selectedGeomOperand = 'INTERSECTS';
        scope.calculoperand = [
          'COUNT',
          'AREA',
          'LENGTH',
          'SUM',
          'MIN',
          'MAX',
          'MEDIAN',
        ];
        scope.selectedCalcul = 'COUNT';
        scope.inprogress = false;
        scope.interrupt = false;
        scope.geoLimit = GeoTreatmentFactory.DATABASE;
        scope.typeOfGeotreatment = 'geoCalcul';
        scope.attributesTochange = '';

        function getAttrListOfFti1() {
          var aliases = [];
          aliases.push('ID');
          aliases.push(scope.attributesTochange);
          aliases.push(scope.attributesTochange + ' NEW');
          return aliases;
        }

        let handlePromiseError= () =>{
          scope.inprogress = false;
        };

        scope.stop = function() {
          GeoTreatmentFactory.stoptreatment(scope.state).then(function() {
            scope.inprogress = false;
            scope.interrupt = true;
          }).catch(handlePromiseError);
        };

        scope.correction = function(obj) {
          scope.currentobj = obj;
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/geotreatment/views/modals/modal.correct.fusionLine.html',
            className: 'ngdialog-theme-plain width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: {
              title: 'Corrections',
            },
          });
        };

        scope.attributeChse2 = '';
        scope.run = function(
          fti1,
          OperandGeo,
          fti2,
          expression,
          attrexp,
          attibute
        ) {
          scope.attributesTochange = attibute;
          scope.inprogress = true;
          const featureCollections = [];
          const spatialClause = 
            GeoTreatmentFactory.getSpatialClause(
              scope.geoLimit,
              scope.map,
              scope.limitZoneGeometry,
              [fti1.name],
              featureCollections);
          var param = {
            spatialclause: spatialClause,
            featureCollections: featureCollections,
            fti1: fti1.uid,
            fti2: fti2.uid,
            operand: OperandGeo,
            expression: expression,
            attributeexpression: attrexp,
            attribute: attibute,
            srid: scope.map.getView().getProjection().getCode()
          };
          var run_promise = GeoTreatmentFactory.treatment(
            param,
            'GeoCalcul'
          ).then(function(data) {
            scope.state = data.data;
            scope.httpStatus=data.status;
            GeoTreatmentFactory.tick(scope, getAttrListOfFti1());
          }).catch(handlePromiseError);
        };
      },
    };
  };

  basemapwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'gcPopup',
    'extendedNgDialog',
    'gaDomUtils',
    'GeoTreatmentFactory',
  ];
  return basemapwidget;
});
