/**@module layerManager*/
'use strict';
define(function() {
  var templatebasewidget = function ($rootScope, gclayers, $filter, ParametersFactory,
      FeatureTypeFactory, gaJsUtils, $q, PortalsFactory, layersService) {
    return {
      /**@property {String} templateUrl Url of the directive UI*/
      templateUrl:
        'js/XG/widgets/mapapp/layerManager/mapmodel/views/mapModelMgt.html',
      /** @type {String} [description] */
      restrict: 'AE',

      /**
       * link
       * @param scope
       * @param element
       * @param attrs
       * @param ctrl
       */
      link: function(scope) {
        scope.models = {
          selected: null,
          lists: {
            A: [
              {
                label: 'Item A1',
              },
              {
                label: 'Item A2',
              },
              {
                label: 'Item A3',
              },
            ],
            B: [
              {
                label: 'Item B1',
              },
              {
                label: 'Item B2',
              },
              {
                label: 'Item B3',
              },
            ],
          },
        };

        // Model to JSON for demo purpose
        scope.$watch('models', function(model) {
          scope.modelAsJson = angular.toJson(model, true);
        }, true);

        scope.legendurl =
          '/services/' +
          PortalsFactory.getPortalId() +
          '/geoserver/ows?service=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=20&LAYER=';
        // The ngRepeat collection is the map's array of layers. ngRepeat
        // uses $watchCollection internally. $watchCollection watches the
        // array, but does not shallow watch the array items! The array
        // items are OpenLayers layers, we don't want Angular to shallow
        // watch them.
        scope.tabs = [
          { title: 'layermanager.theme' },
          { title: 'layermanager.affichage' },
          { title: 'layermanager.mapconfig' },
        ];

        scope.currentuser = $rootScope.xgos.user;
        const MAP_MODEL_CONFIGURATION_NAME = layersService.MAP_MODELS_USERS;
        const MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME = layersService.MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME;


        const getFtiForMapModel = (mm) => {
          let iFti;
          for (iFti = 0; iFti < mm.data.length; iFti++) {
            if (!mm.data[iFti].fti && mm.data[iFti].ftiUid) {
              mm.data[iFti].fti
                = FeatureTypeFactory.getFeatureByUid(mm.data[iFti].ftiUid);
            }
          }
        };


        /**
         * Sur un portail existant, on simplifie tous les modèles de carte.
         * La fonction de simplification retourne FAUX dés la première
         * description de couche simplifiée trouvée. ceci évite de parcourir
         * toute la description d'un modèle s'il a déjà été simplifié.
         *
         * @param {*} modelList : liste des modèle de carte du portail.
         */
        const simplifyModels = (modelList, iMm, defer) => {
          if (!defer) {
            defer = $q.defer();
          }
          if (iMm < modelList.length) {
            if (!gaJsUtils.simplifyMapModel(modelList[iMm].data)) {
              simplifyModels(modelList, ++iMm, defer);
            }
            else {
              //-- Effectivement simplifié donc sauvegarder la modification.
              ParametersFactory.remove(modelList[iMm].id).then(() => {
                ParametersFactory.add(
                  modelList[iMm].data,
                  MAP_MODEL_CONFIGURATION_NAME,
                  modelList[iMm].name
                ).then((res) => {
                  modelList[iMm] = res.data;
                }).finally(() => {
                  simplifyModels(modelList, ++iMm, defer);
                });
              },
              () => {
                simplifyModels(modelList, ++iMm, defer);
              });
            }
          }
          else {
            defer.resolve();
          }
          return defer.promise;
        };


        const loadModelList = () => {
          var promise = ParametersFactory.getbytype(
            MAP_MODEL_CONFIGURATION_NAME,
            scope.map.getView().getProjection().getCode()
          );
          promise.then(
            (res) => {
              const modelList = angular.copy(res.data);
              simplifyModels(modelList,0).then(() => {
                if (scope.mapModels == undefined) scope.mapModels = [];
                else scope.mapModels.splice(0, scope.mapModels.length);
                for (let ii = 0; ii < modelList.length; ii++) {
                  if (!modelList[ii].category ||
                    modelList[ii].category == $rootScope.MapLeftMenucategory
                  ) {
                    getFtiForMapModel(modelList[ii].data);
                    scope.mapModels.push(modelList[ii]);
                  }
                }
              });
            },
            () => {
              console.error('no config user');
            }
          );
          return promise;
        };


        loadModelList().then(
          function() {
            getLastEditedMapModel();
          },
          function() {
            getLastEditedMapModel();
          }
        );

        scope.currentMapModel = {
          id: Math.floor(Math.random() * 100000000000),
          name: undefined,
        };

        /**
         *
         */
        function getmapconfig() {
          var size = scope.map.getSize();
          var propmap = {};
          propmap.extent = scope.map.getView().calculateExtent(size);
          propmap.zoom = scope.map.getView().getZoom();
          propmap.srid = scope.map.getView().getProjection().getCode();
          propmap.bcklayer = [];
          gclayers.getBackGroundLayer().forEach(function(ft) {
            if (!ft.name) {
              ft.name = ft.label;
            }
            propmap.bcklayer.push({ label: ft.label, name: ft.name });
          });
          if (propmap && propmap.bcklayer && propmap.bcklayer.length > 0)
            propmap.bcklayer = [propmap.bcklayer[propmap.bcklayer.length - 1]];

          return propmap;
        }

        function getMapModelOperational() {
          let ind = 0;
          const data = [];
          angular.forEach(gclayers.layersGroupedByStore.layerGroups,
            (group) => {
              angular.forEach(group.layers,
                function (lay) {
                  if (lay.fti) {
                    var a = {
                      name: lay.name,
                      index: ind++,
                      maxScale: lay.maxScale,
                      minScale: lay.minScale,
                      selected: lay.selected,
                      invertedOpacity: lay.invertedOpacity,
                      minResolution: lay.minResolution,
                      maxResolution: lay.maxResolution,
                      visible: lay.visible,
                      cql_filter: '1=1',
                      layerDefs: lay.layerDefs,
                      theme: lay.theme,
                      style: lay.style,
                      fti: lay.fti,
                    };
                    data.push(a);
                  }
                }
              );
            }
          );
          return data;
        }


        function getLastEditedMapModel(noReload) {
          ParametersFactory.getbytype(
            MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME,
            scope.map.getView().getProjection().getCode()
          ).then(
            function(res) {
              if (res.data.length > 0) {
                scope.lasteditedMapModel = res.data[0];

                // défini le modèle par défaut comme modèle actif quand aucun modèle actif n'est enregistré dans le service
                if (scope.lasteditedMapModel && !Number.isInteger(layersService.resources.activeModel)) {
                  scope.activeModel = scope.lasteditedMapModel.data.id;
                }

                getFtiForMapModel(res.data[0].data);
                if (
                  !noReload &&
                  scope.mapModels &&
                  scope.mapModels.length > 0
                ) {
                  scope.mapModels.map(function(x) {
                    if (x.data.id === scope.lasteditedMapModel.data.id) {
                      scope.lasteditedMapModel.data = x.data;
                    }
                  });
                }
              } else scope.lasteditedMapModel = undefined;
            },
            function() {
              console.error('no config user');
            }
          );
        }


        function updateLastEditedMapModel(data, fromDefault, action) {
          if (!scope.lasteditedMapModel) {
            gaJsUtils.simplifyMapModel(data);
            ParametersFactory.add(
              data,
              MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME,
              MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME
            ).then(
              function(res) {
                scope.lasteditedMapModel = res.data;
                $rootScope.$broadcast('mapModelListUpdated', scope.$id);
                if (fromDefault)
                  $rootScope.$broadcast(
                    'mapModeldefaultUpdated',
                    scope.$id,
                    action
                  );
              },
              function() {
                $rootScope.$broadcast('mapModelListUpdated', scope.$id);
                if (fromDefault)
                  $rootScope.$broadcast(
                    'mapModeldefaultUpdated',
                    scope.$id,
                    action
                  );
              }
            );
          } else {
            ParametersFactory.remove(scope.lasteditedMapModel.id).then(
              function() {
                gaJsUtils.simplifyMapModel(data);
                ParametersFactory.add(
                  data,
                  MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME,
                  MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME, undefined,
                  undefined, scope.lasteditedMapModel.id
                ).then(
                  function(res) {
                    scope.lasteditedMapModel = res.data;
                    getFtiForMapModel(res.data);
                    $rootScope.$broadcast('mapModelListUpdated', scope.$id);
                    if (fromDefault)
                      $rootScope.$broadcast(
                        'mapModeldefaultUpdated',
                        scope.$id,
                        action
                      );
                  },
                  function() {
                    $rootScope.$broadcast('mapModelListUpdated', scope.$id);
                    if (fromDefault)
                      $rootScope.$broadcast(
                        'mapModeldefaultUpdated',
                        scope.$id,
                        action
                      );
                  }
                );
              },
              function() {
                $rootScope.$broadcast('mapModelListUpdated', scope.$id);
                if (fromDefault)
                  $rootScope.$broadcast(
                    'mapModeldefaultUpdated',
                    scope.$id,
                    action
                  );
              }
            );
          }
          //-- Broadcast pour envoyer à autre occurence du widget
          //-- info comme quoi la liste est actualisée.
        }


        function removeLastEditedMapModel(fromDefault, action) {
          ParametersFactory.remove(scope.lasteditedMapModel.id).then(
            function() {
              scope.lasteditedMapModel = undefined;
              if (fromDefault)
                $rootScope.$broadcast(
                  'mapModeldefaultUpdated',
                  scope.$id,
                  action
                );
            },
            function() {}
          );
        }




        function saveMapModelConfig() {
          gaJsUtils.simplifyMapModel(scope.currentMapModel);
          ParametersFactory.add(
            scope.currentMapModel,
            MAP_MODEL_CONFIGURATION_NAME,
            scope.currentMapModel.name,
            scope.toolBarWidget.widgetCategory
          ).then(
            () => {
              loadModelList();
              $rootScope.$broadcast('mapModelListUpdated', scope.$id);
              require('toastr').success($filter('translate')('common.saved'));
            },
            () => {
              require('toastr').error(
                $filter('translate')('elastic.search.save_nok')
              );
              $rootScope.$broadcast('mapModelListUpdated', scope.$id);
            }
          );
        }

        function updateMapModelConfig(mapmodel) {
          var callback = function(isConfirm) {
            if (isConfirm) {
              if (
                scope.lasteditedMapModel &&
                scope.lasteditedMapModel.data &&
                mapmodel.data.id === scope.lasteditedMapModel.data.id
              )
                updateLastEditedMapModel(mapmodel.data);
              ParametersFactory.remove(mapmodel.id,true).then(
                function() {
                  gaJsUtils.simplifyMapModel(mapmodel.data);
                  mapmodel.datecreation = null;
                  ParametersFactory.add(
                    mapmodel, undefined, undefined, undefined, true, mapmodel.id
                  ).then(
                    function (res) {
                      //-- Ne pas prendre en compte un message d'erreur
                      //-- comme un mapmodel.
                      if (typeof res.data!=='string') {
                        var idx = scope.mapModels.map(function (x) {
                          return x.id;
                        }).indexOf(mapmodel.id);
                        if (idx !== -1) scope.mapModels[idx] = res.data;
                        //-- Broadcast pour envoyer à autre occurence du widget
                        //-- info comme quoi la liste est actualisée.
                        $rootScope.$broadcast('mapModelListUpdated', scope.$id);
                        //updateLastEditedMapModel(res.data.data);
                        require('toastr').success(
                          $filter('translate')('common.updated')
                        );
                      }
                    },
                    function() {
                      require('toastr').error(
                        $filter('translate')('elastic.search.save_nok')
                      );
                      $rootScope.$broadcast('mapModelListUpdated', scope.$id);
                    }
                  );
                },
                function() {
                  require('toastr').error(
                    $filter('translate')('elastic.search.save_nok')
                  );
                  $rootScope.$broadcast('mapModelListUpdated', scope.$id);
                }
              );
            }
          };
          swal(
            {
              title: $filter('translate')('gcmap.information'),
              text: $filter('translate')('common.surupdate'),
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#5cb85c',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
              closeOnCancel: true,
            },
            callback
          );
        }

        function removeMapModelConfig(mapmodel) {
          if (
            scope.lasteditedMapModel &&
            scope.lasteditedMapModel.data &&
            mapmodel.data.name === scope.lasteditedMapModel.data.name
          )
            removeLastEditedMapModel();
          var promise = ParametersFactory.remove(mapmodel.id).then(
            function() {
              $rootScope.$broadcast('mapModelListUpdated', scope.$id);
            },
            function() {
              require('toastr').error(
                $filter('translate')('elastic.search.save_nok')
              );
              $rootScope.$broadcast('mapModelListUpdated', scope.$id);
            }
          );
          return promise;
          //-- Broadcast pour envoyer à autre occurence du widget
          //-- info comme quoi la liste est actualisée.
        }

        scope.addMapModel = function() {
          scope.currentMapModel.propmap = getmapconfig();
          scope.currentMapModel.data = getMapModelOperational();
          scope.currentMapModel.lastEdited = true;
          scope.mapModels.map(function(x) {
            x.lastEdited = false;
          });
          saveMapModelConfig();
          scope.currentMapModel = {
            id: Math.floor(Math.random() * 100000000000),
            name: undefined,
          };
          //-- Broadcast pour envoyer à autre occurence du widget
          //-- info comme quoi la liste est actualisée.
          // $rootScope.$broadcast("mapModelListUpdated",scope.$id);
        };

        scope.updateMapModel = function(mapmodel) {
          mapmodel.data.propmap = getmapconfig();
          mapmodel.data.data = getMapModelOperational();
          for (let ind = 0; ind < scope.mapModels.length; ind++) {
            if (scope.mapModels[ind].data) {
              scope.mapModels[ind].data.lastEdited = false;
            }
          }
          mapmodel.data.lastEdited = true;
          updateMapModelConfig(mapmodel);
          //-- Broadcast pour envoyer à autre occurence du widget
          //-- info comme quoi la liste est actualisée.
          // $rootScope.$broadcast("mapModelListUpdated",scope.$id);
        };

        scope.removeMapModel = function(mapmodel) {
          swal(
            {
              title: mapmodel.state == 'private'?$filter('translate')('layermanager.deleteModel'):
                                                 $filter('translate')('layermanager.deleteModelAllUser'),
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
              closeOnClickOutside: false,
            },(confirmOk) => {
              if (confirmOk) {
                removeMapModelConfig(mapmodel).then(function() {
                  var idx = scope.mapModels
                    .map(function(x) {
                      return x.id;
                    })
                    .indexOf(mapmodel.id);
                  if (idx !== -1) scope.mapModels.splice(idx, 1);
                });
              }});
        };

        /**
         * Au clic sur le bouton "Activer le modèle de carte" (oeil),
         * exécute la méthode de layersService pour appliquer à la carte le mapModel fourni en paramètre.
         * L'id du mapModel est enregistré dans le service en tant que modèle actif.<ul><li>
         * mapmodelmgtwidget => layersService => gcMainController => mapmodelmgtwidget : met en évidence le modèle actif</li><li>
         * @param {object} mapmodel paramètre KIS de type mapModel
         */
        scope.setMapModel = (mapmodel) => {
          layersService.setMapModel(mapmodel);
        };


        scope.setDefaultMapModel = function(mapmodel) {
          let action;
          if (
            angular.isUndefined(scope.lasteditedMapModel) ||
            angular.isUndefined(scope.lasteditedMapModel.data) ||
            mapmodel.data.id !== scope.lasteditedMapModel.data.id
          ) {
            action = 'set';
            updateLastEditedMapModel(mapmodel.data, true, action);
          } else {
            action = 'remove';
            removeLastEditedMapModel(true, action);
          }
        };

        scope.nameexists = function() {
          var b = false;
          if (scope.mapModels && scope.mapModels.length > 0)
            scope.mapModels.map(function(x) {
              if (x.name === scope.currentMapModel.name) b = true;
            });
          return b;
        };

        //getLastEditedMapModel();

        scope.$on('mapModelListUpdated', function(evt, scopeId) {
          if (scope.$id != scopeId)
            //-- Une autre occurence du widget a modifié la liste des modéles de carte.
            //-- Il faut un timeout, car on risque de reonstruire la liste avant
            //-- que les requêtes de suppression et ajout en cas de modification ne soient effectives.
            // setTimeout(loadModelList,500);
            loadModelList();
        });

        scope.$on('mapModeldefaultUpdated', function(evt, scopeId, action) {
          if (scope.$id != scopeId)
            //-- Une autre occurence du widget a modifié la liste des modéles de carte.
            switch (action) {
              case 'remove':
                scope.lasteditedMapModel = undefined;
                break;
              case 'set':
                getLastEditedMapModel(true);
                break;
            }
        });

        /**
         * Reception de l'évènement de changement de modèle de carte envoyé par le service
         * Met en évidence le nom du nouveau modèle de carte actif dans le widget
         */
        scope.$on('mapModelChange', (evt) => {
          scope.activeModel = layersService.resources.activeModel;
        });

        /**
         * Met en évidence le nom du modèle de carte actif dans le widget à l'initialisation de la directive.
         * Le modèle actif peut être celui par défaut ou bien le modèle activé avant la précédente fermeture de la directive
         */
        scope.$on('mapModelReady', (evt) => {
          scope.activeModel = layersService.resources.activeModel;
        });

        /**
         * INITIALISATION / APRES NAVIGATION
         * Met en évidence le nom du modèle de carte actif dans le widget à l'initialisation de la directive.
         * Le modèle actif peut être celui par défaut ou bien le modèle activé avant la précédente fermeture de la directive
         */

        if (Number.isInteger(layersService.resources.activeModel)) {
          // récupère le modèle actif du service
          scope.activeModel = layersService.resources.activeModel;
        } else if (scope.lasteditedMapModel) {
          // le modèle actif est celui par défaut
          scope.activeModel = scope.lasteditedMapModel.data.id;
        }
      },
    };
  };

  templatebasewidget.$inject = ['$rootScope', 'gclayers', '$filter', 'ParametersFactory',
    'FeatureTypeFactory', 'gaJsUtils', '$q', 'PortalsFactory', 'layersService'];
  return templatebasewidget;
});
