'use strict';
define(function() {
  var getRoles = function(
    $window,
    $rootScope,
    $timeout,
    $location,
    RolesFactory,
    gaJsUtils,
    $filter
  ) {
    return {
      scope: {
        curtool: '=',
        comptitle: '=?'
      },
      templateUrl: 'js/XG/widgets/mapapp/main/views/roleconfig.html',
      restrict: 'EA',
      replace: true,
      link: function($scope) {

        if (!$scope.comptitle){
          $scope.comptitle = $filter('translate')('intervflowwidget.rolerestriction');
        }

        $scope.getAllRoles = () => {
          RolesFactory.get().then(() => {
            $scope.roles = RolesFactory.resources.roles;
            gaJsUtils.sortDataByNameIgnoreCase($scope.roles);
          });
        };
        $scope.getAllRoles();

        $scope.addRolesTool = function(tool, nRole) {
          if (nRole){
            if (!tool.roles) {
              tool.roles = [];
            }
            const deleteIndex = tool.roles.findIndex(roleName => roleName === nRole.name);
            if (deleteIndex === -1) {
              tool.roles.push(nRole.name);
            }
          }
        };

        $scope.removeRolesTool = function(tool, nRole, deleteIndex) {
          tool.roles.splice(deleteIndex, 1);
        };
      },
    };
  };
  getRoles.$inject = [
    '$window',
    '$rootScope',
    '$timeout',
    '$location',
    'RolesFactory',
    'gaJsUtils',
    '$filter'
  ];
  return getRoles;
});
