'use strict';
define(function() {
  var measuretoolbarDirective = function(
    gcPopup,
    gclayers,
    extendedNgDialog,
    $filter,
    gcInteractions,
    $timeout,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/measure/views/toolbarmeasurewidget.html',
      restrict: 'A',

      link: function(scope, element, attrs, ctrl) {
        const CONST_ARROW_COEFF = 40;
        var m = scope.map;
        var cf = scope.config;
        var wgs84Sphere = new ol.Sphere(6378137);
        scope.noTrash = attrs.noTrash == '1';
        scope.preserveFeaturesOnClose = attrs.preserveFeaturesOnClose == '1';
        var isAncRepFiliere = attrs.isAncRepFiliere == '1';

        scope.continuePolygonMsg = $filter('translate')(
          'toolbarmeasuredirective.startdrawingPolygon'
        );
        scope.continueLineMsg = $filter('translate')(
          'toolbarmeasuredirective.startdrawingline'
        );
        scope.typemeasure = '';
        scope.currentmode = '';
        scope.isActive = false;
        var i=0;
        scope.$on('closeToolsBar_toolbarmeasuredirective', function(event) {
         
          //scope.reset();
          // $timeout(function() {
          if (scope.isActive) {
            $('#toolbar_measuredirective_popover').click();
          }
          scope.isActive = false;
        // });
        });

        var btnElt = $(element.children()[0]);
        btnElt.bind('click', function() {
          if (scope.isActive) {
            // preserveFeaturesOnClose = on ne supprime pas les features a la fermeture du widget
            //if (!scope.preserveFeaturesOnClose) {
            scope.reset();
           
              scope.isActive = false;
           
            //}
          } else {
           
              scope.isActive = true;
          
          }
        });

        var getMiddleCoords = function(geom) {
          //-- retourne le point centre à partir des coordonées de la ligne et de sa longueur.
          return getPointAtDistance(
            geom.getCoordinates(),
            geom.getLength() / 2
          );
        };
        /**
         * [fct description]
         * @param  {[type]} evt [description]
         * @return {[type]}     [description]
         */
        var fct = function(evt) {
          if (evt.dragging) {
            return;
          }
          /** @type {string} */
          var helpMsg = $filter('translate')(
            'toolbarmeasuredirective.helpMessage'
          );
          /** @type {ol.Coordinate|undefined} */
          var tooltipCoord = evt.coordinate;

          if (scope.sketch) {
            var output;
            var geom = scope.sketch.getGeometry();
            if (geom instanceof ol.geom.Polygon) {
              output = scope.formatArea(/** @type {ol.geom.Polygon} */ (geom));
              helpMsg = scope.continuePolygonMsg;
              tooltipCoord = geom.getInteriorPoint().getCoordinates();
            } else if (geom instanceof ol.geom.LineString) {
              output = scope.formatLength(
                /** @type {ol.geom.LineString} */ (geom)
              );
              helpMsg = scope.continueLineMsg;
              tooltipCoord = geom.getLastCoordinate();

              if (isAncRepFiliere) {
                var middleCoords = getMiddleCoords(geom);
                if (middleCoords != null) {
                  tooltipCoord = middleCoords;
                }
              }
            }
            scope.measureTooltipElement.innerHTML = output;
            // svg distance
            scope.sketch.set('distance', output);
            scope.measureTooltip.setPosition(tooltipCoord);
          }

          scope.helpTooltipElement.innerHTML = helpMsg;
          scope.helpTooltip.setPosition(evt.coordinate);
        };

        function getPointAtDistance(lineCoordinates, distance) {
          var tmpDistance = distance;

          for (var i = 0; i < lineCoordinates.length - 1; i++) {
            var p1 = lineCoordinates[i];
            var p2 = lineCoordinates[i + 1];

            var dist = gaJsUtils.distanceBetweenPoints(p1, p2);

            if (tmpDistance < dist) {
              var coeff = tmpDistance / dist;

              var x = (1 - coeff) * p1[0] + coeff * p2[0];
              var y = (1 - coeff) * p1[1] + coeff * p2[1];

              return [x, y];
            } else {
              tmpDistance = tmpDistance - dist;
            }
          }

          return null;
        }


        function convertLineToArrow(lineGeom) {
          var lineCoords = lineGeom.getCoordinates();

          var resGeom = new ol.geom.MultiLineString([lineCoords]);

          var lineSegment = resGeom.getCoordinates()[
            resGeom.getCoordinates().length - 1
          ];

          if (lineSegment.length > 1) {
            var arrowCoeff = lineGeom.getLength() / CONST_ARROW_COEFF;

            //arrow at the end of the line
            var start = lineSegment[lineSegment.length - 2];

            var end = resGeom.getLastCoordinate();

            var dx = end[0] - start[0];
            var dy = end[1] - start[1];
            var rotation = Math.atan2(dy, dx);

            var lineStr1 = new ol.geom.LineString([
              end,
              [end[0] - arrowCoeff, end[1] + arrowCoeff],
            ]);
            lineStr1.rotate(rotation, end);
            resGeom.appendLineString(lineStr1);

            var lineStr2 = new ol.geom.LineString([
              end,
              [end[0] - arrowCoeff, end[1] - arrowCoeff],
            ]);
            lineStr2.rotate(rotation, end);
            resGeom.appendLineString(lineStr2);

            //arrow at the start of the line
            var start2 = lineSegment[1];

            var end2 = resGeom.getFirstCoordinate();

            var dx2 = end2[0] - start2[0];
            var dy2 = end2[1] - start2[1];

            var rotation2 = Math.atan2(dy2, dx2);

            var lineStr1_2 = new ol.geom.LineString([
              end2,
              [end2[0] - arrowCoeff, end2[1] + arrowCoeff],
            ]);
            lineStr1_2.rotate(rotation2, end2);
            resGeom.appendLineString(lineStr1_2);

            var lineStr2_2 = new ol.geom.LineString([
              end2,
              [end2[0] - arrowCoeff, end2[1] - arrowCoeff],
            ]);
            lineStr2_2.rotate(rotation2, end2);
            resGeom.appendLineString(lineStr2_2);
          }

          return resGeom;
        }

        /**
         * [description]
         * @param  {[type]} e        [description]
         * @param  {[type]} $dialog) {                                                 console.log('ngDialog closed: ' );                                      scope.map.un('pointermove',fct );                                      map.removeInteraction(scope.drawinteraction);                                      if (scope.helpTooltipElement ! [description]
         * @return {[type]}          [description]
         */

        (scope.line = function() {
          console.log('lin');
        }),
          (scope.polygon = function() {
            console.log('poly');
          }),
          (scope.reset = function() {
            scope.currentmode = '';
            scope.map.un('pointermove', fct);
            if (scope.drawinteraction != null) {
              scope.map.removeInteraction(scope.drawinteraction);
            }

            if (scope.preserveFeaturesOnClose) return;

            if (scope.helpTooltipElement != null) {
              scope.helpTooltipElement.remove();
            }
            //scope.map.getOverlays().clear();
            if (scope.overlayMeasure.length) {
              scope.overlayMeasure.forEach(function(lay) {
                scope.map.removeOverlay(lay);
              });
            }
            scope.helpTooltipElement = null;
            gclayers
              .getMeasureLayer()
              .getSource()
              .clear();
          });

        /**
         * format length output
         * @param {ol.geom.LineString} line
         * @return {string}
         */
        scope.formatLength = function(line) {
          var length;
          const sourceProj = scope.map.getView().getProjection();
          if (sourceProj.getCode() === 'EPSG:3857') {
            var coordinates = line.getCoordinates();
            length = 0;
            for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
              var c1 = ol.proj.transform(
                coordinates[i],
                sourceProj,
                'EPSG:4326'
              );
              var c2 = ol.proj.transform(
                coordinates[i + 1],
                sourceProj,
                'EPSG:4326'
              );
              length += wgs84Sphere.haversineDistance(c1, c2);
            }
          } else {
            length = Math.round(line.getLength() * 100) / 100;
          }
          var output;
          if (length > 1000) {
            output = Math.round((length / 100) * 10) / 100 + ' ' + 'km';
          } else {
            output = Math.round(length * 100) / 100 + ' ' + 'm';
          }
          return output;
        };

        /**
         * format length output
         * @param {ol.geom.Polygon} polygon
         * @return {string}
         */
        scope.formatArea = function(polygon) {
          var area;
          if (true) {
            var sourceProj = scope.map.getView().getProjection();
            var geom = /** @type {ol.geom.Polygon} */ (polygon
              .clone()
              .transform(sourceProj, 'EPSG:4326'));
            var coordinates = geom.getLinearRing(0).getCoordinates();
            area = Math.abs(wgs84Sphere.geodesicArea(coordinates));
          } else {
            area = polygon.getArea();
          }
          var output;
          if (area > 100000) {
            output =
              Math.round((area * 100) / 1000000) / 100 +
              ' ' +
              'km² <br>' +
              Math.round(area * 100) / 100 +
              'm²';
          } else {
            output = Math.round(area * 100) / 100 + ' ' + 'm²';
          }
          return output;
        };
        /**
         * Handle pointer move.
         * @param {ol.MapBrowserEvent} evt
         */
        //scope.pointerMoveHandler =
        scope.createHelpTooltip = function() {
          if (scope.helpTooltipElement) {
            scope.helpTooltipElement.parentNode.removeChild(
              scope.helpTooltipElement
            );
          }
          scope.helpTooltipElement = document.createElement('div');
          scope.helpTooltipElement.className = 'tooltip';
          scope.helpTooltip = new ol.Overlay({
            element: scope.helpTooltipElement,
            offset: [15, 0],
            positioning: 'center-left',
          });
          scope.map.addOverlay(scope.helpTooltip);
          if (angular.isUndefined(scope.overlayMeasure))
            scope.overlayMeasure = [];
          scope.overlayMeasure.push(scope.helpTooltip);
        };

        /**
         * Creates a new measure tooltip
         */
        scope.createMeasureTooltip = function(deletePreviousTooltip, uniqid) {
          // vrai par defaut, on ne garde les tooltips precedents que dans le cas où ils sont chargés programmatiquement
          deletePreviousTooltip = angular.isDefined(deletePreviousTooltip)
            ? deletePreviousTooltip
            : true;

          if (scope.measureTooltipElement && deletePreviousTooltip) {
            scope.measureTooltipElement.parentNode.removeChild(
              scope.measureTooltipElement
            );
          }
          scope.measureTooltipElement = document.createElement('div');
          scope.measureTooltipElement.className = 'tooltip tooltip-measure';
          if (uniqid)
            scope.measureTooltipElement.setAttribute('data-uniqid', uniqid);
          scope.measureTooltip = new ol.Overlay({
            element: scope.measureTooltipElement,
            offset: [0, -15],
            positioning: 'bottom-center',
          });
          scope.map.addOverlay(scope.measureTooltip);
          if (angular.isUndefined(scope.overlayMeasure))
            scope.overlayMeasure = [];
          scope.overlayMeasure.push(scope.measureTooltip);
        };

        var arrowLayerAdded = false;

        var arrowLayer = new ol.layer.Vector({
          source: new ol.source.Vector({
            //create empty vector
          }),
          style: new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'rgba(32,32,32, 0.5)',
              lineDash: [5, 5],
              width: 2,
            }),
          }),
        });

        /**
         * Dessin de lignes aux extremités des flèches
         */
        function drawArrows() {
          if (!arrowLayerAdded) {
            scope.map.addLayer(arrowLayer);
            arrowLayerAdded = true;
          }
          arrowLayer.getSource().clear();

          var fts = gclayers
            .getMeasureLayer()
            .getSource()
            .getFeatures();
          for (var i in fts) {
            var drawGeometry = fts[i].getGeometry();
            if (drawGeometry instanceof ol.geom.LineString) {
              //gclayers.getMeasureLayer().getSource().clear();
              var arrowGeometry = convertLineToArrow(drawGeometry);
              var newFeature = new ol.Feature({
                geometry: arrowGeometry,
              });
              arrowLayer.getSource().addFeature(newFeature);
              //gclayers.getMeasureLayer().getSource().addFeature(newFeature);
            }
          }
        }

        /**
         * [measurelength description]
         * @return {[type]} [description]
         */
        scope.measure = function(type, btnid, isPlanear = false) {
          var map = scope.map;
          map.removeInteraction(scope.drawinteraction);
          if (scope.currentmode == btnid) {
            scope.currentmode = '';
          } else {
            scope.currentmode = btnid;
            //scope.isActive =false;
          }
          //var btnElt = element.find('#'+btnid);
          /**
           * Gestion du bouton
           */
          if (!scope.isActive) {
            //btnElt.removeClass('btn-info')
            //btnElt.addClass("btn-default");
            //scope.isActive =false;
            map.un('pointermove', fct);
            scope.helpTooltipElement.remove();
            scope.helpTooltipElement = null;
          } else {
            // btnElt.removeClass('btn-default')
            //btnElt.addClass("btn-info");
            //scope.isActive =true;
            map.on('pointermove', fct);
          }
          /** la mesure  */
          if (scope.isActive) {
            scope.drawinteraction = new ol.interaction.Draw({
              source: gclayers.getMeasureLayer().getSource(),
              type: type,
              style: new ol.style.Style({
                fill: new ol.style.Fill({
                  color: 'rgba(255, 255, 255, 0.2)',
                }),
                stroke: new ol.style.Stroke({
                  color: 'rgba(255,165,0, 0.5)',
                  lineDash: [10, 10],
                  width: 2,
                }),
                image: new ol.style.Circle({
                  radius: 5,
                  stroke: new ol.style.Stroke({
                    color: 'rgba(255,165,0, 0.7)',
                  }),
                  fill: new ol.style.Fill({
                    color: 'rgba(255, 255, 255, 0.2)',
                  }),
                }),
              }),
            });

            scope.drawinteraction.set('gctype', 'kis');
            scope.drawinteraction.set('interaction', 'Draw');
            scope.drawinteraction.set('widget', 'select');
            map.on('pointermove', fct);
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            map.addInteraction(scope.drawinteraction);

            scope.createMeasureTooltip(false);
            scope.createHelpTooltip();
            //on start
            scope.drawinteraction.on('drawstart', function(evt) {
              /*sketchFeature = evt.feature;*/
              scope.sketch = evt.feature;
              // console.log("drawstart");
            });

            // on end
            scope.drawinteraction.on('drawend', function(evt) {
              //scope.features = evt.feature;
              scope.measureTooltipElement.className = 'tooltip tooltip-static';
              scope.measureTooltip.setOffset([0, -7]);

              // ajout d'un id unique
              var guid = gaJsUtils.guid();
              scope.sketch.set('uid', guid);
              scope.measureTooltipElement.setAttribute('data-uniqid', guid);

              // unset sketch
              scope.sketch = null;
              // unset tooltip so that a new one can be created
              scope.measureTooltipElement = null;
              scope.createMeasureTooltip();

              $timeout(function() {
                scope.$emit('measureToolbarDrawEnd', {
                  data: gclayers
                    .getMeasureLayer()
                    .getSource()
                    .getFeatures(),
                });
                if (isAncRepFiliere) {
                  drawArrows();
                }
              });
            });
          }
        };

        /*
          Load des mesures depuis une autre partie de l'application
          Par exemple representationFiliere ANC
        */
        var formatter = new ol.format.GeoJSON();
        scope.$on('loadDataIntoMesasureToolbar', function(event, args) {
          gclayers
            .getMeasureLayer()
            .getSource()
            .clear();

          // clear tooltips
          $('.tooltip-measure').remove();
          $('.tooltip-static').remove();

          scope.measureTooltipElement = false;

          for (var i in args.data) {
            var olft = formatter.readFeature(args.data[i]);
            gclayers
              .getMeasureLayer()
              .getSource()
              .addFeature(olft);

            scope.createMeasureTooltip(false, args.data[i].properties.uid);
            $('.tooltip-measure')
              .addClass('tooltip-static')
              .removeClass('tooltip-measure');

            var output, tooltipCoord;
            var geom = olft.getGeometry();
            if (geom instanceof ol.geom.Polygon) {
              output = scope.formatArea(/** @type {ol.geom.Polygon} */ (geom));
              tooltipCoord = geom.getInteriorPoint().getCoordinates();
            } else if (geom instanceof ol.geom.LineString) {
              output = scope.formatLength(
                /** @type {ol.geom.LineString} */ (geom)
              );
              tooltipCoord = geom.getLastCoordinate();

              if (isAncRepFiliere) {
                var middleCoords = getMiddleCoords(geom);
                if (middleCoords != null) {
                  tooltipCoord = middleCoords;
                }
              }
            }

            scope.measureTooltipElement.innerHTML =
              args.data[i].properties.distance;
            scope.measureTooltip.setPosition(tooltipCoord);
          }

          drawArrows();
        });

        // integration sans map sur le scope parent
        if (!angular.isDefined(scope.map) && angular.isDefined(attrs.mapId)) {
          scope.map = document.getElementById(attrs.mapId).data;
          gclayers.createmeasurelayer();
          scope.createHelpTooltip();
        }
        // integration avec map sur scope parent mais pas sans gcmap/gclayers (ex ANC)
        if (angular.equals({}, gclayers.getMeasureLayer())) {
          gclayers.createmeasurelayer();
        }

        // si pas de measure layer
        var mapHasMeasureLayer = false;
        scope.map.getLayers().forEach(function(lay) {
          if (lay.get('name') == 'Mesure' && lay.get('gctype') == 'g2c')
            mapHasMeasureLayer = true;
        });
        if (!mapHasMeasureLayer) {
          scope.map.addLayer(gclayers.getMeasureLayer());
        }

        if (!angular.isDefined(scope.helpTooltipElement)) {
          scope.createHelpTooltip();
        }
      },
    };
  };

  measuretoolbarDirective.$inject = [
    'gcPopup',
    'gclayers',
    'extendedNgDialog',
    '$filter',
    'gcInteractions',
    '$timeout',
    'gaJsUtils'
  ];
  return measuretoolbarDirective;
});
