'use strict';
define([
  'angular',
  'widgets/mapapp/printv2/controllers/printCtrl',
  'widgets/mapapp/printv2/directives/printv2widget',
  'widgets/mapapp/printv2/directives/printv2widgetisole',
  'widgets/mapapp/printv2/directives/report.config.reportonly',
  'widgets/mapapp/printv2/services/PrintLegendFactory',
  'widgets/mapapp/printv2/services/pv2layerservices',
  'widgets/mapapp/printv2/services/pv2config',
  'widgets/mapapp/printv2/services/pv2annotations',
  'angular-strap',
  'angular-strap.tpl',

  'angular-route',

  'toastr',
  'ol3js',
  'ng-table',
], function (angular, printV2Ctrl, printv2widget, ggaprintdirv2,
  configreportonly, PrintLegendFactory, pv2LayerServices,
  pv2Config, pv2annotations
) {
  var Print = function() {
    this.htmlPrintout = function(body, head) {
      var windowPrint = window.open('', '', 'height=400, width=600');
      windowPrint.document.write(buildHtml(body, head));
      windowPrint.document.close();
    };

    var buildHtml = function(body, head) {
      var html = '';
      html += '<html><head>';
      html += typeof head == 'undefined' ? getStylesheetString() : head;
      html += '</head><body onload="window.print(); window.close();">';
      html += body;
      html += '</body></html>';
      return html;
    };

    var getStylesheetString = function() {
      var html = '';
      var cssElement = $('link[href*="app.css"]');
      var cssLink = cssElement.attr('href');
      html += '<link href="' + cssLink + '" rel="stylesheet" type="text/css">';
      return html;
    };
  };
  // generation du module
  var printManager = angular.module('gc_printv2', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
    'ngDialog',
  ]);

  // ajout service
  printManager.factory('PrintLegendFactory', PrintLegendFactory);
  printManager.factory('pv2LayerServices', pv2LayerServices);
  printManager.factory('pv2Config', pv2Config);
  printManager.factory('pv2Annotations', pv2annotations);

  // ajout controller
  printManager.controller('printV2Ctrl', printV2Ctrl);

  // ajout directive
  printManager.directive('gaprintv2', printv2widget);

  // ajout directive
  printManager.directive('configreportonly', configreportonly);

  // ajout directive avec scope isolé (le nom de directive gaprintdirv2
  // pose problème, confusion avec nouvelle version d'angularjs).
  printManager.directive('ggaprintdirv2', ggaprintdirv2);

  // ajout factory

  //route provider
  printManager.provider('gaPrintService', function() {
    this.$get = function() {
      return new Print();
    };
  });
  return printManager;
});
