'use strict';
define([
  'angular',

  /**
   * directives
   */
  'widgets/mapappv2/home_admin_data/directives/listeDataCarte',
  'widgets/mapappv2/home_admin_data/directives/addComponentConfigCarte',

  'widgets/mapappv2/home_admin_data/directives/adminCarte',

  /**
   * utilities
   */
  'widgets/mapappv2/home_admin_data/directives/utilities/data/dashboardCarte',

  /**
   * Services
   */
  'widgets/mapappv2/home_admin_data/services/CarteAppServices',

  /**
   * dependencies
   */
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'ngDragDrop',
], function(
  angular,
  listeDataCarte,
  addComponentConfigCarte,
  adminCarte,
  dashboardCarte,
  CarteAppServices
) {
  // generation du module
  var gcMain = angular.module('gcMainCarteHomeAdminData', [
    'model',
    'ga_urlutils_service',
    'ngRoute',
    'ngDragDrop',
  ]);

  /**
   * Directives
   */
  gcMain.directive('listeDataCarte', listeDataCarte);
  gcMain.directive('addComponentConfigCarte', addComponentConfigCarte);
  gcMain.directive('adminCarte', adminCarte);

  /**
   * utilities
   */
  gcMain.directive('dashboardCarte', dashboardCarte);

  /**
   * Services
   */
  gcMain.factory('CarteAppServices', CarteAppServices);

  return gcMain;
});
