'use strict';
define(function() {
  var CarteUserAppFactory = function(
    $http,
    FeatureTypeFactory,
    $filter,
    $rootScope,
    $location,
    CarteInitProvider
  ) {
    function getUser() {
      return CarteInitProvider.getUser();
    }

    function getUserRoles() {
      var user = CarteInitProvider.getUser();
      return user.roles;
    }

    function isKisRootUser() {
      var user = CarteInitProvider.getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return user.name === 'root';
    }

    function isRootUser() {
      var user = CarteInitProvider.getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('rootUser') !== -1;
    }

    function isSuperRootUser() {
      var user = CarteInitProvider.getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('sRootUser') !== -1;
    }

    function isMulticriteriaAnalyst() {
      var user = CarteInitProvider.getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('MulticriteriaAnalyst') !== -1;
    }

    function getNavigationHpo() {
      var navigations = [];

      var title = {
        main_title: 'hpo.home.title',
        label: 'hpo.home.title',
        icon: 'home',
        template:
          'js/XG/widgets/mapappv2/main/views/templates/hpo.home.tpl.html',
        visible: true,
        description: '',
      };

      var admin = {
        main_title: 'hpo.admin.title',
        label: 'hpo.admin.title',
        icon: 'cogs',
        template:
          'js/XG/widgets/mapappv2/main/views/templates/hpo.admin.tpl.html',
        visible: true,
        description: '',
      };

      var dataCheck = {
        label: 'hpo.data.check.title',
        icon: 'table',
        template:
          'js/XG/widgets/mapappv2/main/views/templates/hpo.data.check.tpl.html',
        visible: true,
        description: '',
      };
      var dataExchange = {
        label: 'hpo.data.exchange.title',
        icon: 'exchange',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.exchange.tpl.html',
        visible: true,
        description: '',
      };
      var dataPrepare = {
        label: 'hpo.data.prepare.title',
        icon: 'pencil',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.tpl.html',
        visible: true,
        description: '',
      };
      var dataAnalyse = {
        label: 'hpo.data.analyse.title',
        icon: 'pie-chart',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.analyse.tpl.html',
        visible: true,
        description: '',
      };
      var checkvalidation = {
        label: 'hpo.data.checkvalidation.title',
        icon: 'check',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.checkvalidation.tpl.html',
        visible: true,
        description: '',
      };
      var data = {
        main_title: 'hpo.data.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'database',
        subs: [],
      };

      var multicritereAutomatisation = {
        label: 'hpo.multicritere.automatisation.title',
        icon: 'laptop',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.automatisation.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereParameters = {
        label: 'hpo.multicritere.parameters.title',
        icon: 'cog',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.parameters.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereConstruct = {
        label: 'hpo.multicritere.construct.title',
        icon: 'plus',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.construct.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereAnalyse = {
        label: 'hpo.multicritere.analyse.title',
        icon: 'edit',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.analyse.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereIndicateur = {
        label: 'hpo.multicritere.indicateur.title',
        icon: 'plus-square',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.indicateur.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereCompare = {
        label: 'hpo.multicritere.compare.title',
        icon: 'line-chart',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.compare.tpl.html',
        visible: true,
        description: '',
      };

      var multicritereCorrespondance = {
        label: 'hpo.multicritere.correspondance.title',
        icon: 'arrows-h',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.correspondance.tpl.html',
        visible: true,
        description: '',
      };

      var multicritereRetenu = {
        label: 'hpo.multicritere.retenu.title',
        icon: 'mouse-pointer',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.retenu.tpl.html',
        visible: true,
        description: '',
      };

      var multicritere = {
        main_title: 'hpo.multicritere.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'code-fork',
        subs: [],
      };

      var chantiersCreate = {
        label: 'hpo.chantiers.creation.title',
        icon: 'plus',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/chantiers/chantiers.tpl.html',
        visible: true,
        description: '',
      };
      var chantiersListe = {
        label: 'hpo.chantiers.liste.title',
        icon: 'list',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/chantiers/liste.chantiers.tpl.html',
        visible: true,
        description: '',
      };
      var chantiers = {
        main_title: 'hpo.chantiers.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'cubes',
        subs: [],
      };

      var carte = {
        main_title: 'mapv2.carte.title',
        label: 'mapv2.carte.title',
        icon: 'map',
        template:
          'js/XG/widgets/mapappv2/main/views/templates/hpo.carte.tpl.html',
        visible: true,
        description: '',
      };

      data.subs = data.subs.concat([
        dataCheck,
        dataExchange,
        dataPrepare,
        dataAnalyse,
      ]);
      multicritere.subs = multicritere.subs.concat([
        multicritereAutomatisation,
        multicritereParameters,
        multicritereConstruct,
        multicritereIndicateur,
        multicritereAnalyse,
        multicritereCompare,
        multicritereRetenu,
      ]);
      chantiers.subs = chantiers.subs.concat([
        multicritereCorrespondance,
        chantiersCreate,
        chantiersListe,
      ]);
      navigations = navigations.concat([title]);
      if (isSuperRootUser() || isRootUser() || isKisRootUser())
        navigations.push(admin);
      navigations.push(data);
      if (
        CarteInitProvider.hasMulticritere() &&
        (isMulticriteriaAnalyst() ||
          isSuperRootUser() ||
          isRootUser() ||
          isKisRootUser())
      ) {
        navigations.push(multicritere);
        navigations.push(chantiers);
      }
      navigations.push(carte);
      return navigations;
    }

    return {
      getUser: getUser,
      getUserRoles: getUserRoles,
      isRootUser: isRootUser,
      getNavigationHpo: getNavigationHpo,
    };
  };
  CarteUserAppFactory.$inject = [
    '$http',
    'FeatureTypeFactory',
    '$filter',
    '$rootScope',
    '$location',
    'CarteInitProvider',
  ];
  return CarteUserAppFactory;
});
