'use strict';
define([
  'angular',
  /**
   * Controller
   */
  'widgets/mapappv2/main/controllers/gcMainCarteController',

  /**
   * Factories
   */
  'widgets/mapappv2/main/factory/HpoCarteAppFactory',
  'widgets/mapappv2/main/factory/CarteAppFactory',
  'widgets/mapappv2/main/factory/CarteUserAppFactory',

  /**
   * Providers
   */
  'widgets/mapappv2/main/providers/CarteInitProvider',

  /**
   * dependencies
   */
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'ngDragDrop',
], function(
  angular,
  gcMainCarteController,
  HpoCarteAppFactory,
  CarteAppFactory,
  CarteUserAppFactory,
  CarteInitProvider
) {
  // generation du module
  var gcMain = angular.module('gcMainMapV2', [
    'model',
    'ga_urlutils_service',
    'ngRoute',
    'ngDragDrop',
  ]);

  /**
   * Controller
   */
  gcMain.controller('gcMainCarteController', gcMainCarteController);

  /**
   * Factories
   */
  gcMain.factory('HpoCarteAppFactory', HpoCarteAppFactory);
  gcMain.factory('CarteAppFactory', CarteAppFactory);
  gcMain.factory('CarteUserAppFactory', CarteUserAppFactory);

  /**
   * Providers
   */
  gcMain.provider('CarteInitProvider', CarteInitProvider);

  return gcMain;
});
