'use strict';
define(function() {
  var supervisionCtrl = function(
    $scope,
    $timeout,
    ConfigFactory,
    $filter,
    SirocoFactory
  ) {
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));

    // mainConfig editor
    $scope.mainCfg = JSON.stringify(sirocoCfg.mainConfig, null, 5); // 5 spaces for indentation

    $timeout(function() {
      $scope.codeEditor = CodeMirror.fromTextArea(
        document.getElementById('mainCfgCodeEditor'),
        {
          matchBrackets: true,
          autoCloseBrackets: true,
          mode: 'application/ld+json',
          lineWrapping: true,
          lineNumbers: true,
        }
      );
      $scope.codeEditor.setSize('100%', '100%');
    }, 0);

    /**
     * saveCfg
     */
    $scope.saveCfg = function() {
      var cfg = $scope.codeEditor.getDoc().getValue();
      ConfigFactory.add(cfg, 'main', 'mainConfig', sirocoCfg.appname).then(
        function(res) {
          SirocoFactory.getSirocoCfg();
          require('toastr').success($filter('translate')('common.saved'));
        }
      );
    };
  };

  supervisionCtrl.$inject = [
    '$scope',
    '$timeout',
    'ConfigFactory',
    '$filter',
    'SirocoFactory',
  ];
  return supervisionCtrl;
});
