'use strict';
define(function() {
  var gcelement = function(
    ImportExportFactory,
    SridFactory,
    ngDialog,
    $filter,
    gaJsUtils,
    PortalsFactory,
    RegionalFactory,
    $rootScope
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/data/views/gcexport.html',
      restrict: 'EA',
      scope: {
        selection: '=',
        fti: '=?',
        onlySrid: '=?',
        currentsridName: '=?',
      },

      link: function(scope) {

        scope.getMap = function(aScope) {
          if (aScope == null) return undefined;
          if (aScope.map != undefined) return aScope.map;
          else return scope.getMap(aScope.$parent);
        };

        const map = scope.getMap(scope);
        if (map !== null) {
          scope.currentsridName = scope.getMap(scope).getView().getProjection().getCode();
        } else {
          scope.currentsridName = '';
        }
        scope.wait = false;
        scope.exportFormats = [
          {
            value: 'KML',
            label: 'KML',
          },
          {
            value: 'GML',
            label: 'GML',
          },
          {
            value: 'SHAPEFILE',
            label: 'ShapeFile',
          },
          {
            value: 'MapInfo File',
            label: 'MapInfo File',
          },
          {
            value: 'GPS',
            label: 'GPS',
          },
          {
            value: 'DXF',
            label: 'DXF',
          },
          {
            value: 'CSV',
            label: 'CSV',
          },
        ];

        scope.selectedFormat = scope.exportFormats[0];
        scope.srids = SridFactory.sridsList;
        scope.specialcsv = {
          geometrie: $filter('translate')(
            'importexportwidget.specialcsv.nothing'
          ),
          currentsridName: scope.currentsridName,
        };
        if (scope.fti && scope.fti.geographic) {
          scope.csvoptions =
            scope.fti.typeInfo === 'POINT'
              ? [
                $filter('translate')('importexportwidget.specialcsv.nothing'),
                'XY',
                'WKT',
              ]
              : [
                $filter('translate')('importexportwidget.specialcsv.nothing'),
                'WKT',
              ];
          scope.showMessage = scope.fti.typeInfo === 'POINT';
        } else {
          scope.csvoptions = [
            $filter('translate')('importexportwidget.specialcsv.nothing'),
            'XY',
            'WKT',
          ];
          scope.showMessage = true;
        }

        scope.exportSelection = function() {
          scope.wait = true;

          // récupère le type de géométrie si CSV, sinon special = ''
          const special = getSpecialCsv();

          if (scope.selection.crs == undefined) {
            //-- Récupération du nom du système de projection de la carte.
            var map = scope.getMap(scope);
            scope.selection.crs = {};
            scope.selection.crs.type = 'name';
            scope.selection.crs.properties = {
              name: map
                .getView()
                .getProjection()
                .getCode(),
            };
          }

          // récupération des paramètres régionaux (encodage de texte, séparateur de champ csv)
          const { encoding, separator }
            = RegionalFactory.getPortalRegionalData($rootScope.xgos.portal);

          ImportExportFactory.exportfeaturecollection(
            scope.selection,
            scope.selectedFormat.value,
            scope.currentsridName,
            undefined,
            special,
            encoding,
            separator
          ).then(
            function(exportResult) {
              scope.wait = false;
              var resultFileName = exportResult.data;

              var downloadurl =
                '/services/' +
                localStorage.portal +
                '/export/downloadexportedfile?f=json' +
                '&exportedFileId=' +
                resultFileName;
              window.open(downloadurl);
            },
            function(res) {
              scope.wait = false;
              require('toastr').error($filter('translate')(res.data));
            }
          );
        };

        scope.selectFormat = function(exportFormat) {
          scope.selectedFormat = exportFormat;
        };

        scope.propertiestoexclude = {};
        scope.getReturnedTemplate = function(data) {
          if (data) {
            var attributes = [];
            scope.attributesToExport.map(function(x) {
              if (x && x.uid === scope.layersToExport && x.mapping)
                x.mapping.map(function(y) {
                  if (y) {
                    data.savedata.map(function(k) {
                      if (k && k.uid === scope.layersToExport && k.mapping)
                        k.mapping.map(function(z, i) {
                          if (y.name === z.name) Object.assign(y, z);
                        });
                    });
                  }
                });
            });
          }
        };

        scope.mappingExportLayers = function() {
          if (scope.fti) {
            scope.layersToExport = scope.fti.uid;
            var obj = {
              uid: scope.fti.uid,
              name: scope.fti.name,
              alias: scope.fti.alias,
              mapping: angular.copy(scope.fti.attributes),
            };
            scope.attributesToExport = [obj];

            if (scope.layersToExport) {
              scope.ConfigNameExport =
                'config_export_mapping_' + scope.layersToExport;
            } else {
              scope.ConfigNameExport = 'config_export_mapping';
            }
            var dial = ngDialog.openConfirm({
              template:
                'js/XG/widgets/mapapp/importexport/views/importExportWidgetAdvanced.html',
              className: 'ngdialog-theme-plain width800 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
            });
            dial.then(function(data) {
              scope.wait = true;

              // récupère le type de géométrie si CSV, sinon special = ''
              const special = getSpecialCsv();

              // récupération des paramètres régionaux (encodage de texte, séparateur de champ csv)
              const { encoding, separator }
                = RegionalFactory.getPortalRegionalData($rootScope.xgos.portal);

              ImportExportFactory.exportfeaturecollection(
                scope.selection,
                scope.selectedFormat.value,
                scope.currentsridName,
                data[0],
                special,
                encoding,
                separator
              ).then(
                function(exportResult) {
                  scope.wait = false;
                  var resultFileName = exportResult.data;
                  const portalid = PortalsFactory.getPortalId();

                  var downloadurl =
                    '/services/' + portalid +'/export/downloadexportedfile?f=json' +
                    '&exportedFileId=' +
                    resultFileName;
                  window.open(downloadurl);
                },
                function(res) {
                  scope.wait = false;
                  require('toastr').error($filter('translate')(res.data));
                }
              );
            });
          }
        };

        scope.emptyAnalysisTools = function(attributesToExport) {
          if (attributesToExport && attributesToExport.length > 0) {
            attributesToExport.map(function(x) {
              if (x && x.mapping && x.mapping.length > 0) {
                x.mapping.map(function(mapi) {
                  if (mapi && mapi.mapping) mapi.mapping = undefined;
                });
              }
            });
            require('toastr').info(
              $filter('translate')('importexportwidget.mapping.initconfi')
            );
          }
        };

        scope.filterFunc = gaJsUtils.filterFunc;
        scope.checkMapping = function(attribute) {
          attribute.mapping =
            scope.selectedFormat &&
            (scope.selectedFormat.value === 'SHAPEFILE' ||
              scope.selectedFormat.value === 'GPS') &&
            attribute.mapping &&
            attribute.mapping.length > 10
              ? attribute.mapping.substring(0, 10)
              : attribute.mapping;
        };

        /**
         * Défini le type de géométrie d'un export csv
         * Affecte la variable de l'input du srid du csv à la variable du srid de destination
         * @return {string} type de géométrie si export csv, sinon ''
         */
        const getSpecialCsv = () => {
          let specialcsv = '';
          if (scope.selectedFormat.value === 'CSV' && scope.specialcsv
            && scope.specialcsv.geometrie) {
            specialcsv =
                scope.specialcsv.geometrie ===
                $filter('translate')('importexportwidget.specialcsv.nothing')
                  ? '' : scope.specialcsv.geometrie;
            if (scope.specialcsv.currentsridName) {
              scope.currentsridName = scope.specialcsv.currentsridName;
            }
          }
          return specialcsv;
        };
      },
    };
  };

  gcelement.$inject = [
    'ImportExportFactory',
    'SridFactory',
    'ngDialog',
    '$filter',
    'gaJsUtils',
    'PortalsFactory',
    'RegionalFactory',
    '$rootScope'
  ];
  return gcelement;
});
