'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    $timeout,
    $rootScope,
    gcRestrictionProvider,
    gcInteractions,
    FeatureTypeFactory,
    gcWFS
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/edit/views/gceditpoint.html',

      restrict: 'A',
      scope: {
        map: '=map',
        res: '=res',
        radiomode: '=?radiomode',
        onclick: '&?onclick',
        onfinish: '&?onfinish',
        drawinteraction: '=?drawinteraction',
        isActive: '=?isactive',
        snaptolerance: '=snaptolerance',
        ftid: '=ftid',
        toolbarwidget: '=?toolbarwidget',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.geom = {};
        scope.drawinteraction = {};
        scope.feature = '';
        if (angular.isUndefined(scope.radiomode)) {
          scope.radiomode = true;
        }
        //Recuperation du fti du comosant
        scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        // Functions snap interaction
        function getSnapRule() {
          var fti = scope.fti;
          if (fti == undefined) fti = scope.$parent.$parent.selectfti;
          var rules = fti.rules;
          var ruleSnap = undefined;
          if (rules) {
            for (var i = 0; i < rules.length; i++) {
              if (rules[i].name == 'SnapOn') {
                ruleSnap = rules[i];
                break;
              }
            }
          }
          return ruleSnap;
        }
        function snapOn(ruleConf) {
          //var ruleConf = getSnapRule();
          var layersToLoad = [];
          var layers = gclayers.getOperationalLayer();
          var layerNames = ruleConf.parameters['layers'];
          //Pour chaque nom de layer en config de cette règle
          for (var j = 0; j < layerNames.length; j++) {
            var name = layerNames[j].name;
            //Pour chaque layer opérationelle
            for (var i = 0; i < layers.length; i++) {
              var l = layers[i];
              if (l.name == undefined) continue;
              if (name == l.name) {
                var fti = l.fti;
                layersToLoad.push(fti);
                break;
              }
            }
          }
          //Chargement des objets des couches sur lesquelles s'accrocher
          var wfsLayer = gcWFS.getOlLayerFromFeaturetypeInfoArray(layersToLoad,scope.map);
          //map.addLayer(wfsLayer);
          gclayers.addSnapLayer(wfsLayer);
          var srcDrawedDXF = gclayers.getImportLayer().getSource();
          wfsLayer.getSource().addFeatures(srcDrawedDXF.getFeatures());
          if (scope.snaptolerance == undefined) {
            scope.snaptolerance = 20;
          }
          scope.snap = new ol.interaction.Snap({
            source: wfsLayer.getSource(),
            edge: true,
            vertex: true,
            pixelTolerance: scope.snaptolerance,
          });
        }

        function removeWfsLayers() {
          var layersToRemove = [];
          var layers = scope.map.getLayers().getArray();
          for (var i = 0; i < layers.length; i++) {
            var l = layers[i];
            if (l.type == 'wfs') {
              layersToRemove.push(l);
            }
          }
          for (var j = 0; j < layersToRemove.length; j++) {
            scope.map.removeLayer(layersToRemove[j]);
          }
        }

        /**
         * [removefeatures description]
         * @return {No} [description]
         */
        scope.removefeatures = function() {
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
          scope.features = {};
        };
        scope.add = function() {
          console.log(
            scope.map
              .getInteractions()
              .getArray()
              .indexOf(scope.snap)
          );
          var map = scope.map;
          map.removeInteraction(scope.drawinteraction);
          var ruleConf = getSnapRule();
          if (ruleConf != undefined) {
            scope.map.removeInteraction(scope.snap);
            removeWfsLayers();
          }

          var btnElt = $(element.children()[0]);

          if (
            scope.isActive &&
            scope.drawinteraction &&
            scope.drawinteraction.getActive()
          ) {
            if (
              scope.drawinteraction &&
              scope.drawinteraction instanceof ol.interaction.Draw
            )
              scope.drawinteraction.setActive(false);
            map.removeInteraction(scope.drawinteraction);
            scope.removefeatures();
            scope.isActive = false;
            var ruleConf = getSnapRule();
            if (ruleConf != undefined) {
              scope.map.removeInteraction(scope.snap);
              map.dispatchEvent({ type: 'snapRemovedEvent' });
              removeWfsLayers();
            }
          } else {
            scope.isActive = true;
          }
          //var sketchFeature;
          //
          if (scope.isActive) {
            var a = gclayers.getDrawLayer();

            scope.drawinteraction = new ol.interaction.Draw({
              source: gclayers.getDrawLayer().getSource(),
              type: 'Point',
            });

            scope.drawinteraction.set('gctype', 'kis');
            scope.drawinteraction.set('interaction', 'Draw');
            scope.drawinteraction.set('widget', 'editionoutil' + Math.random());
            scope.drawinteraction.setActive(true);
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            map.addInteraction(scope.drawinteraction);
            var ruleConf = getSnapRule();
            if (ruleConf != undefined) {
              snapOn(ruleConf);
              scope.map.addInteraction(scope.snap);
              if (
                map
                  .getInteractions()
                  .getArray()
                  .indexOf(scope.snap) !== -1
              ) {
                //Envoi de l'information de l'interaction ajoutée.
                map.dispatchEvent({ type: 'snapAddedEvent' });
              }
            }
            // add snap interaction

            //on start
            scope.drawinteraction.on('drawstart', function(evt) {
              /*sketchFeature = evt.feature;*/
              console.log('drawstart');
            });

            // on end
            scope.drawinteraction.on('drawend', function(evt) {
              //scope.features = evt.feature;
              var format = new ol.format.GeoJSON();

              //console.log( );
              var feature = format.writeFeatureObject(evt.feature);
              //Remove snap interaction

              //map.removeInteraction(scope.drawinteraction);
              //scope.res = scope.feature;
              //console.log('da');

              if (gcRestrictionProvider.hasRestrictionEdition()) {
                gcRestrictionProvider
                  .GeometryInRestriction(
                    feature.geometry,
                    map
                      .getView()
                      .getProjection()
                      .getCode()
                  )
                  .then(
                    function(res) {
                      if (JSON.parse(res.data)) {
                        if (scope.radiomode) {
                          scope.radiomode = false;
                          scope.drawinteraction.setActive(false);
                          map.removeInteraction(scope.drawinteraction);
                          var ruleConf = getSnapRule();
                          if (ruleConf != undefined) {
                            scope.map.removeInteraction(scope.snap);
                            map.dispatchEvent({
                              type: 'snapRemovedEvent',
                            });
                            removeWfsLayers();
                          }
                        }
                        $timeout(function() {
                          scope.res = feature.geometry;
                          scope.onfinish(feature.geometry);
                        });
                      } else {
                        gcRestrictionProvider.showErrorMessage();
                        scope.onfinish();
                      }
                    },
                    function(res) {
                      console.error(res.data);
                    }
                  );
              } else {
                if (scope.radiomode) {
                  scope.radiomode = false;
                  scope.drawinteraction.setActive(false);
                  map.removeInteraction(scope.drawinteraction);
                  var ruleConf = getSnapRule();
                  if (ruleConf != undefined) {
                    scope.map.removeInteraction(scope.snap);
                    map.dispatchEvent({
                      type: 'snapRemovedEvent',
                    });
                    removeWfsLayers();
                  }
                }
                $timeout(function() {
                  scope.res = feature.geometry;
                  scope.onfinish(feature.geometry);
                });
              }
            });

            try {
              if (attrs.onclick != undefined) {
                scope.onclick();
              }
            } catch (e) {
              console.error(e);
            }
          }

          /* try{
                     scope.$apply();
                     }
                     catch(e){
                     scope.onclick();
                     }
                     scope.onclick();*/
        };
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    '$timeout',
    '$rootScope',
    'gcRestrictionProvider',
    'gcInteractions',
    'FeatureTypeFactory',
    'gcWFS',
  ];
  return gcelement;
});
