'use strict';
define(function() {
  var formBuilderFunction = function() {
    return {
      templateUrl:
        'js/XG/widgets/utilities/form/views/formBuilderDatatableButtons.html',
      restrict: 'EA',
      scope: {
        res: '=',
        label: '@',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.infos = { label: 'Actions table' };
        if (angular.isDefined(scope.label)) scope.infos.label = scope.label;

        scope.buttons = angular.isDefined(scope.res) ? scope.res : [];
        scope.addButton = function() {
          scope.buttons.push({
            label: 'btn',
            btnclass: 'default',
            cfg: {
              iconOrLabel: 'label',
              label: 'button',
              size: 'btn-xs',
            },
          });
        };

        scope.removeButton = function(index) {
          scope.buttons.splice(index, 1);
        };

        /**
         * Update res
         */
        scope.$watch(
          'buttons',
          function(buttons) {
            scope.res = buttons;
          },
          1
        );
      },
    };
  };

  formBuilderFunction.$inject = [];
  return formBuilderFunction;
});
