'use strict';
define(function() {
  var itvSoumissionEnMasse = function ( $filter, gaDomUtils, itvMassSoumFactory,
    FeatureTypeFactory, $timeout, $q, $rootScope, ConfigFactory,
    extendedNgDialog, itvSoumFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/itv/views/soumissionEnMasse/itvSoumissionEnMasse.html',
      restrict: 'A',

      link: function (scope) {
        // Data for tabs Done and Logs
        scope.ftidDone = FeatureTypeFactory.getFeatureUidByName(
          'evt_inspection_chargement_masse'
        );
        scope.ftidLogs = FeatureTypeFactory.getFeatureUidByName(
          'evt_inspection_log'
        );
        scope.lastLogOnly = 'last_log=\'true\'';

        //-- Nombre de demandes de statuts sur la progression de la soumission
        let getStatusCount;
        //-- Intervale entre 2 demande d'avancement de la progression
        let getStatusInterval;

        // Get configs || REMOVE
        // function getConfigFromWidget() {
        //   if (!scope.ConfigName && scope.$parent.ConfigName) {
        //     scope.ConfigName = scope.$parent.ConfigName;
        //   }
        //   itvMassSoumFactory.getConf(scope.ConfigName).then(function(res) {
        //     if (res.data.etat == 'fini') {
        //       scope.config = res.data.config;
        //       scope.idField = res.data.useoldid.name;
        //     }
        //   });
        // }
        // getConfigFromWidget();

        function getConfigFromIndigau() {
          //-- Nom de la configuration où sont stockés les composants
          //-- du réseau d'assainissement.
          //-- Côté serveur quand le nom du réseau ne fait pas partie de
          //-- la liste des réseaux définis sur le portail, on cherche
          //-- le fichier de configuration correspondant à celui reçu
          //-- dans le nom du réseau sachant qie le point sépare le type et
          //-- le nom du fichier de configuration.
          if (scope.conf == undefined) scope.conf = {};
          if (scope.conf.config == undefined) scope.conf.config = {};
          ConfigFactory.get('main', 'appconfig').then((res) => {
            if (res.data) {
              scope.conf.config.datastore = res.data.datastoreName;
              //-- A priori non utile pour import en masse:
              //-- getItvLayerDescription();
            }
          });
        }

        /**
         *   La config widget est hérité du scope parent (qui est le widgte).
         * Dans le cas d'une application indigau, il ne faut pas utiliser
         * cette configuration, mais celle d'INDIGAU.
         */
        function getitvConfig() {
          if ($rootScope.xgos.sector === 'indigau') {
            getConfigFromIndigau();
          }
        }
        getitvConfig();

        // Refresh all that need to be refreshed in the window


        /**
         * Construction d'une chaîne de caractères qui liste liste les fichiers
         * mis en erreur lors de l'import en masse.
         *
         * @returns Une chaîne de caractères avec un, nom de fichier par ligne.
         */
        const getWrongFilelist = () => {
          let mess
            = $filter('translate')('itv.soumissionEnMasse.wrongFilesAre');
          for (let ind = 0; ind < scope.wrongFiles.length; ind++) {
            mess += '\n' + scope.wrongFiles[ind];
          }
          return mess;
        };


        /**
         * Affichage dans une SWeet Alert de la liste des fichiers ITV mis
         * en erreur lorsde l'import en masse.
         */
        scope.showWrongFiles = () => {

          swal({
            title:
              $filter('translate')('itv.soumissionEnMasse.wrongFilesTitle'),
            text: getWrongFilelist(),
            type: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#5cb85c',
            confirmButtonText: $filter('translate')('common.ok'),
            closeOnConfirm: true,
          });
        };


        /**
         * Prépare les variables de travail pour la gestion des fichiers
         * en erreur concernant le chargement qui a eut lieu dernièrement.
         *
         * @param {*} data : resultat (result.data) du service
         *                   getItvMassLoadingStatus
         */
        const manageWrongFiles = (data) => {
          if (data.wrongFiles && data.wrongFiles != '') {
            scope.wrongFiles = data.wrongFiles.split(',');
            scope.wrongFileButtonLabel = $filter('translate')('itv.soumissionEnMasse.showWrongFiles');
          }
          else {
            scope.wrongFiles = [];
          }
        };


        scope.refreshWindow = (first) => {
          if (first) {
            scope.status = 'noRole';
            scope.prevLoadingStatus = 'noStatus';
            scope.progress = 0;
          }
          if (!scope.locale || scope.locale == null) {
            scope.locale = 'fr';
          }
          let defer = $q.defer();
          itvMassSoumFactory
            .getItvMassLoadingStatus(
              scope.conf.config.datastore,
              scope.conf.config.network,
              scope.ConfigName,
              scope.locale
            )
            .then((result) => {
              if (result.data.status!=null &&
                scope.status != result.data.status
              ) {
                scope.status = result.data.status;
              }
              if (result.data.prevLoadingStatus!=null &&
                scope.prevLoadingStatus != result.data.prevLoadingStatus
              ) {
                scope.prevLoadingStatus = result.data.prevLoadingStatus;
              }
              if (result.data.progress!=null &&
                scope.progress != result.data.progress
              ) {
                scope.progress = result.data.progress;
              }
              if (result.data.progress==null) {
                scope.progress = 0;
              }
              if (result.data.startingDate!=null &&
                scope.startingDate != result.data.startingDate
              ) {
                const date = new Date(parseInt(result.data.startingDate, 10));
                scope.startingDate =
                  date.toLocaleDateString('fr-FR') +
                  ' ' +
                  date.toLocaleTimeString('fr-FR');
              }
              if (result.data.backupState != null) {
                scope.backupIsEmpty = result.data.backupState;
              }
              manageWrongFiles(result.data);
              newStatus();
              defer.resolve();
            });
          return defer.promise;
        };
        scope.refreshWindow(true);

        // Get Date for loadName
        let date = new Date();
        scope.loadName =
          $filter('translate')('itv.soumissionEnMasse.loadingOf') +
          date.toLocaleDateString('fr-FR') +
          ' ' +
          date.toLocaleTimeString('fr-FR');

        // Refresh text when status change
        function newStatus() {
          if (scope.startingDate!=null)
            scope.beginPreviousLoad =
              $filter('translate')('itv.soumissionEnMasse.beginPreviousLoad') +
              scope.startingDate;
          else scope.beginPreviousLoad = '';
          if (scope.statusPreviousLoad!=null)
            scope.statusPreviousLoad =
              $filter('translate')('itv.soumissionEnMasse.statusPreviousLoad') +
              scope.prevLoadingStatus;
          else scope.statusPreviousLoad = '';

          if (scope.status == 'noRole') {
            scope.infoSquareText = $filter('translate')(
              'itv.soumissionEnMasse.statusNoRole'
            );
          }
          else if (scope.status == 'noFile') {
            scope.infoSquareText = $filter('translate')(
              'itv.soumissionEnMasse.statusNoFile'
            );
          }
          else if (scope.status == 'filesUploaded') {
            scope.infoSquareText = $filter('translate')(
              'itv.soumissionEnMasse.statusFilesUploaded'
            );
          }
          else if (scope.status == 'loading') {
            scope.infoSquareText =
              $filter('translate')('itv.soumissionEnMasse.statusLoading') +
              scope.startingDate;
            scope.beginPreviousLoad = '';
            scope.statusPreviousLoad = '';
          }
        }


        // Call getIntegrerITVs and refresh while loading
        scope.chargeITVsIntoKis = () => {
          // Get Date for loadName
          if (
            scope.loadName.startsWith(
              $filter('translate')('itv.soumissionEnMasse.loadingOf')
            )
          ) {
            const date = new Date();
            scope.loadName =
              $filter('translate')('itv.soumissionEnMasse.loadingOf') +
              date.toLocaleDateString('fr-FR') +
              ' ' +
              date.toLocaleTimeString('fr-FR');
          }
          let withIndigauAutmaticCalc = false;
          const oldIdName = scope.conf.useoldid ? scope.conf.useoldid.name : '';
          if (scope.conf.indigau) {
            withIndigauAutmaticCalc = scope.conf.indigau.withIndigauAutmaticCalc == true;
          }
          const itvZipNames = scope.dropzoneComponent.files.map(file => {
            if (file.name.includes('.')) {
              // KIS-2316: remplacer le texte “chargement en cours” par le nom du fichier zip intégré
              return file.name.substring(0, file.name.lastIndexOf("."));
            }
            return file.name;
          }).join(', ');
          itvMassSoumFactory.getIntegrerITVs(scope.conf,
            scope.loadName, oldIdName,
            scope.conf.config.network, scope.conf.config.datastore,
            withIndigauAutmaticCalc, scope.ConfigName, scope.locale,
            itvSoumFactory.arcgisConfToUrl(scope.conf),
            itvSoumFactory.getTolerance(scope), 
            scope.conf.config.useIndigauEngine,
            itvZipNames,
            scope.createConnectionPipes,
            false
          ).then(() => {
            scope.lastLogOnly = 'last_log=\'false\'';
            getStatusCount = 0;
            getStatusInterval = 750;
            timeOutRefresh();
          })
            .catch(() => require('toastr').error('Echec de l\'intégration'))
            .finally(() => scope.dropzoneComponent.removeAllFiles());
        };


        function timeOutRefresh() {
          scope.refreshWindow().then(() => {
            if (scope.status == 'loading') {
              if (scope.progress > 94) {
                getStatusInterval = 750;
              }
              else if (getStatusCount++ === 100) {
                getStatusInterval = 5000;
              }
              else if (getStatusCount++ === 25) {
                getStatusInterval = 2500;
              }

              $timeout(timeOutRefresh, getStatusInterval);
            }
            else {
              scope.lastLogOnly = 'last_log=\'true\'';
              // Data for tabs Done and Logs
              scope.ftidDone = FeatureTypeFactory.getFeatureUidByName(
                'evt_inspection_chargement_masse'
              );
              scope.ftidLogs = FeatureTypeFactory.getFeatureUidByName(
                'evt_inspection_log'
              );
            }
          });
        }

        // Interrupt loading
        scope.askConfirmationInterrupt = () => {
          swal(
            {
              title: $filter('translate')(
                'itv.soumissionEnMasse.confirmInterruptTitle'
              ),
              text: $filter('translate')(
                'itv.soumissionEnMasse.confirmInterruptText'
              ),
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            (isConfirm) => {
              if (isConfirm) {
                itvMassSoumFactory
                  .stopIntegrerITVs()
                  .then(() => {
                    scope.refreshWindow();
                  })
                  .catch(() =>
                    require('toastr').error(
                      'Echec de l\'interruption'
                    )
                  );
              }
            }
          );
        };

        // Empty serveur from ITVs files
        scope.askConfirmationEmptyFiles = () => {
          swal(
            {
              title: $filter('translate')(
                'itv.soumissionEnMasse.confirmEmptyTitle'
              ),
              text: $filter('translate')(
                'itv.soumissionEnMasse.confirmEmptyText'
              ),
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            (isConfirm) => {
              if (isConfirm) {
                itvMassSoumFactory.emptyBackedupITVs().then(() =>{
                  scope.dropzoneComponent.removeAllFiles();
                  scope.refreshWindow();
                });
              }
            }
          );
        };

        // Tabs of the window
        scope.tabs = [
          {
            title: $filter('translate')('itv.soumissionEnMasse.file'),
          },
          {
            title: $filter('translate')('itv.soumissionEnMasse.new'),
          },
          {
            title: $filter('translate')('itv.soumissionEnMasse.done'),
          },
          {
            title: $filter('translate')('itv.soumissionEnMasse.logs'),
          },
        ];
        scope.tabs.activeTab = 0;

        scope.openPendingFilesDialog = () => {
          itvMassSoumFactory
            .pendingFilesList()
            .then((res) => {
              if (res.data.length > 0) {
                scope.pendingFilesList = [];
                for (const absFilePath of res.data) {
                  let filePathArray;
                  if (absFilePath.includes('\\')) {
                    // windows
                    filePathArray = absFilePath.split('\\');
                  }
                  else {
                    // linux
                    filePathArray = absFilePath.split('/');
                  }
                  // nom de l'ITV = nom du fichier txt/xml sans l'extension
                  const filename = filePathArray[
                    filePathArray.length - 1
                  ].split('.')[0];
                  scope.pendingFilesList.push({
                    name: filename,
                    absolutePath: absFilePath,
                  });
                }
                scope.pendingFilesDialog = extendedNgDialog.open({
                  template:
                    'js/XG/widgets/utilities/itv/views/soumissionEnMasse/modal.itvMassSoumPendingFiles.html',
                  className:
                    'ngdialog-theme-plain width350 nopadding miniclose',
                  closeByDocument: false,
                  title: $filter('translate')(
                    'itv.soumissionEnMasse.pendingFilesTitle'
                  ),
                  draggable: true,
                  scope: scope,
                });
              }
              else {
                swal({
                  title: $filter('translate')('gcmap.information'),
                  text: $filter('translate')('featureattachment.empty'),
                  type: 'warning',
                  showCancelButton: false,
                  confirmButtonColor: '#5cb85c',
                  confirmButtonText: $filter('translate')('common.ok'),
                  closeOnConfirm: true,
                });
                scope.refreshWindow();
              }
            })
            .catch(() =>
              require('toastr').error(
                'Impossible de lister les fichiers en attente'
              )
            );
        };
        scope.deleteAllPendingFiles = () => {
          gaDomUtils.showGlobalLoader();
          itvMassSoumFactory
            .emptyUploadedITVs()
            .then(() => {
              scope.pendingFilesList = [];
              scope.dropzoneComponent.removeAllFiles();
              scope.pendingFilesDialog.close();
              scope.refreshWindow();
            })
            .catch(() =>
              require('toastr').error(
                'La suppression des ITV en attente a échoué'
              )
            )
            .finally(() => gaDomUtils.hideGlobalLoader());
        };
        scope.deletePendingFile = (pendingFile, index) => {
          gaDomUtils.showGlobalLoader();
          const path = pendingFile.absolutePath;
          itvMassSoumFactory
            .deletePendingFile(path)
            .then(() => {
              scope.pendingFilesList.splice(index, 1);
              if (scope.pendingFilesList.length == 0) {
                scope.pendingFilesDialog.close();
                scope.dropzoneComponent.removeAllFiles();
                scope.refreshWindow();
              }
            })
            .catch(() =>
              require('toastr').error(
                'La suppression de l\'ITV en attente a échouée'
              )
            )
            .finally(() => gaDomUtils.hideGlobalLoader());
        };
      },
    };
  };

  itvSoumissionEnMasse.$inject = ['$filter', 'gaDomUtils',
    'itvMassSoumFactory', 'FeatureTypeFactory', '$timeout', '$q',
    '$rootScope', 'ConfigFactory', 'extendedNgDialog', 'itvSoumFactory'
  ];
  return itvSoumissionEnMasse;
});
