'use strict';
define(function() {
  var gcrelation = function(FeatureTypeFactory) {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gcrelation.html',
      restrict: 'A',
      scope: {
        result: '=res',
        fti: '=?',
        ftid: '=?',
        typerel: '@',
        onChange:'=?',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.relations = [];
        scope.myfilter = {};

        const updateFtiWithFtid = () => {
          scope.relations = [];
          let ftid;
          if (scope.ftid && scope.ftid.indexOf("'") > -1){
            ftid = scope.ftid.replaceAll("'", '');
          }
          scope.fti = FeatureTypeFactory.getFeatureByUid(ftid);
        };

        if (scope.ftid) {
          updateFtiWithFtid();
        }
        scope.$watch('ftid', updateFtiWithFtid);

        //scope.myfilter.typeInfo = scope.geomtype;
        scope.$watch('fti', () => {
            if (scope.fti && scope.fti.relations) {
              scope.relations = [];
              scope.fti.relations.forEach(function(rel) {
                if (
                  scope.typerel == '*' ||
                  (angular.isDefined(rel.type) && rel.type == scope.typerel)
                ) {
                  scope.relations.push(rel);
                }
              });
            }
          },
          true
        );

        scope.selectRelationChanged = () => {
          if (typeof scope.onChange === 'function') {
            scope.result = scope.onChange(scope.result);
          }
        };
      },
    };
  };

  gcrelation.$inject = ['FeatureTypeFactory'];
  return gcrelation;
});
