'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    extendedNgDialog,
    QueryFactory,
    EditProcessService,
    FeatureTypeFactory,
    FormsHelper,
    AdvancedEditionFactory,
    $filter, gaJsUtils
  ) {
    const UPDATE_MODE = 'UPDATE';
    const ADD_MODE = 'ADD';
    const DELETE_MODE = 'DELETE';

    const TEMPLATE_FEATURE = {
      type: 'Feature',
      geometry: {},
      properties: {},
    };

    const TEMPLATE_FEATURE_COLLECTION = {
      features: [],
      totalFeatures: 0,
      type: 'FeatureCollection',
    };

    const TEMPLATE_QUERY = {
      querydata: {},
      partdata: {},
      selop: '=',
      where: '1=10',
      casesensitive: true,
    };

    return {
      templateUrl: 'js/XG/widgets/utilities/relations/views/formRelation.html',
      restrict: 'A',
      scope: {
        map: '=map',
        fti: '=?fti',
        ftid: '=?ftid',
        fieldData: '=?fieldData',
        relname: '=relname',
        relogcid: '=relogcid',
        rellabel: '@',
        relstyle: '=',
        res: '=res',
        activelabel: '=activelabel',
        current: '=current',
        editsession: '=editsession',
        relationholddata: '=relationholddata',
        chainpopup: '=chainpopup',
        editdescription: '=editdescription',
      },
      link: function(scope) {
        console.log(scope.relogcid);
        console.log(scope.relname);
        scope.editmode = scope.editsession
          ? scope.editsession.editionStarted()
          : false;
        scope.rmap = null;
        scope.nmdata = {
          root: false,
          valid: false,
          relatedfeatures: [],
          relatedfeature: null,
          geojson: angular.copy(TEMPLATE_FEATURE_COLLECTION),
        };

        scope.nmbkp = null;

        scope.query = null;

        scope.currentEditFeature = {
          current: null,
        };
        scope.currentActionMode = null;

        scope.relatedFormTemplate = null;

        if (angular.isUndefined(scope.relstyle)) {
          scope.relstyle = 'btn-default';
        }
        if (angular.isUndefined(scope.ftid)) {
          scope.ftid = scope.fti.uid;
        }
        if (angular.isUndefined(scope.fti) || scope.fti == null) {
          scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        }

        if (angular.isUndefined(scope.res)) scope.res = {};
        /* scope.res ={}; */
        scope.rel = null;

        scope.operandes = [
          {
            name: 'equals',
            value: '=',
          },
          {
            name: 'different',
            value: '<>',
          },
          {
            name: 'gt',
            value: '>',
          },
          {
            name: 'gte',
            value: '>=',
          },
          {
            name: 'lt',
            value: '<',
          },
          {
            name: 'lte',
            value: '<=',
          },
          {
            name: 'like',
            value: '%',
          },
        ];

        if (!angular.isUndefined(scope.initvalue) && scope.initvalue != '') {
          scope.res = scope.initvalue;
        }

        function getRelationByName(relations, relName, ogcId) {
          for (var i = 0; i < relations.length; i++)
            if (relations[i].name == relName && relations[i].ogcId == ogcId)
              return relations[i];

          return null;
        }

        function relationsAreEquals(relation1, relation2) {
          return (
            relation1.name == relation1.name &&
            relation1.type == relation2.type &&
            relation1.ogcId == relation2.ogcId &&
            relation1.composite == relation2.composite &&
            relation1.occurence == relation2.occurence
          );
        }

        function compareRelations(relations1, relations2) {
          if (relations1.length != relations2.length) return false;

          for (var i = 0; i < relations1.length; i++) {
            if (!relationsAreEquals(relations1[i], relations2[i])) return false;
          }

          return true;
        }

        function initCorrespondantRel(relations) {
          for (var i = 0; i < relations.length; i++) {
            var rel = relations[i];
            if (scope.nmdata.root) {
              if (rel.idStart) {
                var ftiStart = FeatureTypeFactory.getFeatureByUid(rel.idStart);
                if (ftiStart) {
                  var ftiValidated = false;
                  if (ftiStart.uid == scope.fti.uid) ftiValidated = true;
                  else if (
                    compareRelations(ftiStart.relations, scope.fti.relations)
                  ) {
                    var ftirel = getRelationByName(
                      ftiStart.relations,
                      scope.rel.name,
                      scope.rel.ogcId
                    );
                    if (ftirel) ftiValidated = true;
                  }

                  if (ftiValidated) return rel;
                }
              }
            } else {
              if (rel.idEnd) {
                var ftiEnd = FeatureTypeFactory.getFeatureByUid(rel.idEnd);
                if (ftiEnd) {
                  var ftiValidated = false;
                  if (ftiEnd.uid == scope.fti.uid) ftiValidated = true;
                  else if (
                    compareRelations(ftiEnd.relations, scope.fti.relations)
                  ) {
                    var ftirel = getRelationByName(
                      ftiEnd.relations,
                      scope.rel.name,
                      scope.rel.ogcId
                    );
                    if (ftirel) ftiValidated = true;
                  }

                  if (ftiValidated) return rel;
                }
              }
            }
          }

          return null;
        }

        for (var i = 0; i < scope.fti.relations.length; i++) {
          if (
            scope.fti.relations[i].name == scope.relname &&
            (scope.relogcid == undefined ||
              scope.fti.relations[i].ogcId == scope.relogcid)
          ) {
            scope.rel = angular.copy(scope.fti.relations[i]);

            scope.nmdata.root = scope.rel.idStart == scope.fti.uid;
            if (scope.nmdata.root) {
              scope.nmdata.ftistart = FeatureTypeFactory.getFeatureByUid(
                scope.rel.idStart
              );
              var ftiend = FeatureTypeFactory.getFeatureByUid(scope.rel.idEnd);
              if (ftiend && ftiend.relations) {
                //if (inverserel) {
                scope.nmdata.ftiend = ftiend;
                scope.nmdata.valid = true;
                //}
              }
            } else {
              scope.nmdata.ftiend = FeatureTypeFactory.getFeatureByUid(
                scope.rel.idEnd
              );
              var ftistart = FeatureTypeFactory.getFeatureByUid(
                scope.rel.idStart
              );
              if (ftistart && ftistart.relations) {
                //var inverserel = initCorrespondantRel(ftistart.relations);
                //if (inverserel) {
                scope.nmdata.ftistart = ftistart;
                scope.nmdata.valid = true;
                if (scope.relationholddata != undefined) {
                  if (
                    angular.isDefined(
                      scope.relationholddata.data[scope.nmdata.ftistart.uid]
                    ) &&
                    scope.relationholddata.data[scope.nmdata.ftistart.uid] !=
                      null
                  ) {
                    if (
                      scope.rel.fieldStart &&
                      scope.relationholddata.data[scope.nmdata.ftistart.uid][
                        scope.rel.fieldStart
                      ] != null
                    ) {
                      var featuresData =
                        scope.relationholddata.data[scope.nmdata.ftistart.uid][
                          scope.rel.fieldStart
                        ];
                      var features = featuresData.features;
                      if (features != null && features.length == 1) {
                        var feat = features[0];
                        if (
                          scope.rel.fieldEnd &&
                          scope.current.properties &&
                          feat &&
                          feat.properties
                        ) {
                          scope.current.properties[scope.rel.fieldStart] =
                            feat.properties[scope.rel.fieldEnd];
                          scope.nmdata.relatedfeature = feat;

                          scope.nmbkp = angular.copy(scope.nmdata);
                        }
                      } else scope.selectList = featuresData;
                    }
                  }
                }
                //scope.inverserel = inverserel;
                //}
              }
            }
            break;
          }
        }

        scope.matchfti = scope.nmdata.root
          ? scope.nmdata.ftiend
          : scope.nmdata.ftistart;
        scope.onematchfti = scope.nmdata.ftiend;

        var formRes = FormsHelper.getFtiForm(scope.matchfti);
        if (formRes && formRes instanceof Object) {
          if (formRes.then)
            formRes.then(function(res) {
              var formTemplate = res.data;
              scope.relatedFormTemplate = formTemplate;
            });
          else scope.relatedFormTemplate = formRes;
        } else {
          scope.relatedAuthorizedAttributes = FormsHelper.getAuthorizedAttributes(
            scope.matchfti
          );
        }

        /* */

        scope.nmbkp = angular.copy(scope.nmdata);

        function checkRelationFromRelatedFeatures() {
          if (
            scope.rel.type == 'REL_SIMPLE' &&
            scope.rel.occurence == '1-1' &&
            scope.editdescription.relatedfeatures.length > 0
          ) {
            var relatedFeature = scope.editdescription.relatedfeatures[0];
            if (relatedFeature.editType == 'add') {
              if (
                scope.nmdata.root &&
                relatedFeature.fti.uid == scope.rel.idEnd
              ) {
                var ogcobjectid = scope.current.properties[scope.rel.fieldEnd];

                var sessionStoreRelatedFeaturesData = scope.editsession.getRelationData(
                  scope.fti,
                  scope.rel.name,
                  ogcobjectid
                );

                /*var sessionRelatedFeaturesData = angular
                                    .copy(sessionStoreRelatedFeaturesData);*/
                if (sessionStoreRelatedFeaturesData)
                  scope.nmdata.relatedfeature = sessionStoreRelatedFeaturesData;
                else {
                  scope.editsession.commitRelation(
                    scope.fti,
                    scope.rel.name,
                    ogcobjectid,
                    [relatedFeature.feature],
                    scope.rel.idEnd
                  );
                  scope.nmdata.relatedfeature = relatedFeature.feature;
                }

                //scope.nmbkp = angular.copy(scope.nmdata);

                return true;
              } else if (
                !scope.nmdata.root &&
                scope.editdescription.fti.uid == scope.rel.idStart
              ) {
                var cOgcobjectid =
                  scope.current.properties[scope.rel.fieldStart];

                var sessionStoreRelatedFeaturesData2 = scope.editsession.getRelationData(
                  scope.fti,
                  scope.rel.name,
                  cOgcobjectid
                );

                /*var sessionRelatedFeaturesData2 = angular
                                    .copy(sessionStoreRelatedFeaturesData2);*/
                if (sessionStoreRelatedFeaturesData2)
                  scope.nmdata.relatedfeature = sessionStoreRelatedFeaturesData2;
                else {
                  scope.editsession.commitRelation(
                    scope.fti,
                    scope.rel.name,
                    cOgcobjectid,
                    [scope.editdescription.editedfeature],
                    scope.rel.idStart
                  );
                  scope.nmdata.relatedfeature =
                    scope.editdescription.editedfeature;
                }

                //scope.nmbkp = angular.copy(scope.nmdata);
                return true;
              }
            }
          }

          return false;
        }

        function queryRelation2() {
          if (!checkRelationFromRelatedFeatures()) {
            if (scope.editmode) advanceQueryRelation();
            else simpleQueryRelation();
          }
        }

        function queryRelation() {
          if (scope.editmode) advanceQueryRelation();
          else simpleQueryRelation();
        }

        function simpleQueryRelation() {
          if (scope.current.id) {
            var fieldName = scope.nmdata.root
              ? scope.rel.fieldStart
              : scope.rel.type == 'REL_SIMPLE'
                ? scope.rel.fieldStart
                : scope.rel.fieldEnd;

            var ogcobjectid = scope.current.properties[fieldName];
            console.log(scope.rel);

            QueryFactory.relation(
              scope.fti.uid,
              scope.rel.name,
              gaJsUtils.getIdInCaseEsriId(scope.current,scope.fti),
              null,
              ogcobjectid,
              scope.rel.ogcId
            ).then(function(res) {
              scope.nmdata.geojson = res.data;
              var features = res.data.features;
              var storeFeatures = angular.copy(features);
              if (scope.editmode)
                scope.editsession.commitRelation(
                  scope.fti,
                  scope.rel.name,
                  ogcobjectid,
                  features,
                  scope.nmdata.root ? scope.rel.idEnd : scope.rel.idStart
                );
              if (scope.rel.type == 'REL_NM' && scope.nmdata.root)
                scope.nmdata.relatedfeatures = storeFeatures;
              else
                scope.nmdata.relatedfeature =
                  res.data.totalFeatures > 0 ? storeFeatures[0] : null;

              scope.nmbkp = angular.copy(scope.nmdata);
            });
          } else {
            var ogcrealid = scope.current.properties[scope.rel.fieldStart];
            if (ogcrealid) {
              scope.current.id = FormsHelper.getOrBuildFeatureId(scope.current);
              scope.current.properties.id = scope.current.id;

              var relftid = scope.nmdata.root
                ? scope.rel.idEnd
                : scope.rel.idStart;
              //var fieldEnd = scope.rel.fieldEnd == 'id' ? 'KISID' : scope.rel.fieldEnd;
              var fieldEnd = scope.rel.fieldEnd;

              var where = fieldEnd + ' = ' + ogcrealid;
              QueryFactory.data(relftid, where).then(function(res) {
                scope.nmdata.geojson = res.data;
                var features = res.data.features;
                var storeFeatures = angular.copy(features);
                if (scope.editmode)
                  scope.editsession.commitRelation(
                    scope.fti,
                    scope.rel.name,
                    ogcrealid,
                    features,
                    scope.nmdata.root ? scope.rel.idEnd : scope.rel.idStart
                  );
                if (scope.rel.type == 'REL_NM' && scope.nmdata.root)
                  scope.nmdata.relatedfeatures = storeFeatures;
                else
                  scope.nmdata.relatedfeature =
                    res.data.totalFeatures > 0 ? storeFeatures[0] : null;

                scope.nmbkp = angular.copy(scope.nmdata);
              });
            }
          }
        }

        function advanceQueryRelation() {
          if (scope.current.properties.id || scope.current.id) {
            //var idToCheck = scope.current.id != null ? scope.current.id : scope.current.properties.id;
            var fieldName = scope.nmdata.root
              ? scope.rel.fieldStart
              : scope.rel.type == 'REL_SIMPLE'
                ? scope.rel.fieldStart
                : scope.rel.fieldEnd;

            var idToCheck = scope.current.properties[fieldName];

            var sessionStoreRelatedFeaturesData = scope.editsession.getRelationData(
              scope.fti,
              scope.rel.name,
              idToCheck
            );
            var sessionRelatedFeaturesData = angular.copy(
              sessionStoreRelatedFeaturesData
            );
            if (sessionRelatedFeaturesData) {
              scope.nmdata.geojson = {
                features: sessionRelatedFeaturesData,
                totalFeatures: sessionRelatedFeaturesData.length,
                type: 'FeatureCollection',
              };

              if (scope.rel.type == 'REL_NM' && scope.nmdata.root)
                scope.nmdata.relatedfeatures = sessionRelatedFeaturesData;
              else
                scope.nmdata.relatedfeature =
                  sessionRelatedFeaturesData.length > 0
                    ? sessionRelatedFeaturesData[
                      sessionRelatedFeaturesData.length - 1
                    ]
                    : null;

              scope.nmbkp = angular.copy(scope.nmdata);
            } else simpleQueryRelation();
          } else simpleQueryRelation();
        }

        if (scope.current && scope.fti && scope.rel) {
          if (
            !scope.nmdata.root &&
            scope.rel.fieldEnd &&
            scope.current.properties
          ) {
            var fieldStartValue =
              scope.current.properties[scope.rel.fieldStart];
            if (fieldStartValue != null && fieldStartValue != '')
              queryRelation();
          } else queryRelation();
        }

        var lastFormRelationNMDataDialog = null;
        scope.openRelatedNMDataModal = function() {
          scope.rmap = scope.nmdata.ftiend.typeInfo == 'NG' ? null : scope.map;
          if (angular.isDefined(scope.chainpopup)) {
            scope.chainpopup.openNext({
              scope: scope,
              template:
                'js/XG/widgets/utilities/relations/views/formRelationNMData.html',
              showClose: true,
              hidemin: true,
            });
            lastAssociateDialogInChain = true;
          } else
            lastFormRelationNMDataDialog = extendedNgDialog.open({
              template:
                'js/XG/widgets/utilities/relations/views/formRelationNMData.html',
              className:
                'ngdialog-theme-plain no_drop_modal width800 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
              title: $filter('translate')(
                'tools.builder.fields.relations.form.relatedeatures'
              ),
              draggable: true,
              preCloseCallback: function() {
                scope.nmdata = angular.copy(scope.nmbkp);
              },
            });
        };

        scope.launch1To1ParentOpenForm = function(callback) {
          if (callback == undefined) {
            scope.currentEditProperties =
              scope.nmdata.relatedfeature instanceof ol.Feature
                ? scope.nmdata.relatedfeature.getProperties()
                : scope.nmdata.relatedfeature.properties;

            scope.currentEditFeature = {
              current: {
                properties: scope.currentEditProperties,
              },
            };

            scope.currentActionMode = UPDATE_MODE;
          }

          if (callback) callback();
          else openTemplateForEdition();
        };

        scope.launch1ToNOpenForm = function(callback) {
          if (callback == undefined) {
            scope.currentEditProperties =
              scope.nmdata.relatedfeature instanceof ol.Feature
                ? scope.nmdata.relatedfeature.getProperties()
                : scope.nmdata.relatedfeature.properties;

            scope.currentEditFeature = {
              current: {
                properties: scope.currentEditProperties,
              },
            };

            scope.currentActionMode = UPDATE_MODE;
          }

          if (callback) callback();
          else openTemplateForEdition();
        };

        scope.launch1To1OpenForm = function(callback) {
          if (callback == undefined) {
            scope.currentEditProperties =
              scope.nmdata.relatedfeature instanceof ol.Feature
                ? scope.nmdata.relatedfeature.getProperties()
                : scope.nmdata.relatedfeature.properties;

            scope.currentEditFeature = {
              current: {
                properties: scope.currentEditProperties,
              },
            };

            scope.currentActionMode = UPDATE_MODE;
          }

          if (callback) callback();
          else openTemplateForEdition();
        };

        scope.launch1ToNResetAction = function() {
          if (scope.rel.fieldEnd && scope.current.properties) {
            scope.current.properties[scope.rel.fieldStart] = null;
            scope.nmdata.relatedfeature = null;

            scope.nmbkp = angular.copy(scope.nmdata);
            console.log(scope.relationholddata);
          }
        };

        scope.launch1To1ResetAction = function() {
          if (scope.rel.fieldEnd && scope.current.properties) {
            scope.current.properties[scope.rel.fieldStart] = null;
            scope.nmdata.relatedfeature = null;

            scope.nmbkp = angular.copy(scope.nmdata);
            console.log(scope.relationholddata);
          }
        };

        var lastAssociateDialog = null;
        var lastAssociateDialogInChain = false;
        scope.launch1To1AssociateForm = function() {
          scope.query = angular.copy(TEMPLATE_QUERY);
          scope.query.datatablemode = 'QUERY';
          scope.query.querydata.filterfield = scope.fieldData.filterfield;
          scope.rmap = scope.nmdata.ftiend.typeInfo == 'NG' ? null : scope.map;
          if (angular.isDefined(scope.chainpopup)) {
            scope.filterFieldWatcher = scope.$watch(
              'query.querydata.filterfield',
              function(newval, oldval) {
                if (newval != oldval)
                  FormsHelper.checkFieldAndOpenRelationSearchForm(
                    scope.matchfti,
                    scope,
                    newval
                  );
              }
            );

            scope.chainpopup.openNext({
              scope: scope,
              template:
                'js/XG/widgets/utilities/relations/views/form1To1RelationAssociateData.html',
              showClose: true,
              hidemin: true,
            });
            lastAssociateDialogInChain = true;
          } else
            lastAssociateDialog = extendedNgDialog.open({
              template:
                'js/XG/widgets/utilities/relations/views/form1To1RelationAssociateData.html',
              className:
                'ngdialog-theme-plain no_drop_modal width800 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
              title: $filter('translate')(
                'tools.builder.fields.relations.form.associateformtitle'
              ),
              draggable: true,
            });
        };

        var lastAssociateDialog = null;
        var lastAssociateDialogInChain = false;
        scope.launch1ToNAssociateForm = function() {
          scope.query = angular.copy(TEMPLATE_QUERY);
          scope.query.datatablemode = 'QUERY';
          scope.query.querydata.filterfield = scope.fieldData.filterfield;
          scope.rmap =
            scope.nmdata.ftistart.typeInfo == 'NG' ? null : scope.map;
          if (angular.isDefined(scope.chainpopup)) {
            scope.filterFieldWatcher = scope.$watch(
              'query.querydata.filterfield',
              function(newval, oldval) {
                if (newval != oldval)
                  FormsHelper.checkFieldAndOpenRelationSearchForm(
                    scope.matchfti,
                    scope,
                    newval
                  );
              }
            );

            scope.chainpopup.openNext({
              scope: scope,
              template:
                'js/XG/widgets/utilities/relations/views/formRelationAssociateData.html',
              showClose: true,
              hidemin: true,
            });
            lastAssociateDialogInChain = true;
          } else
            lastAssociateDialog = extendedNgDialog.open({
              template:
                'js/XG/widgets/utilities/relations/views/formRelationAssociateData.html',
              className:
                'ngdialog-theme-plain no_drop_modal width800 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
              title: $filter('translate')(
                'tools.builder.fields.relations.form.associateformtitle'
              ),
              draggable: true,
            });
        };

        scope.launch1ToNFromListAssociateForm = function() {
          scope.query = angular.copy(TEMPLATE_QUERY);
          scope.query.datatablemode = 'GEOJSON';
          scope.query.selectlist = scope.selectList;
          scope.rmap =
            scope.nmdata.ftistart.typeInfo == 'NG' ? null : scope.map;
          if (angular.isDefined(scope.chainpopup)) {
            scope.chainpopup.openNext({
              scope: scope,
              template:
                'js/XG/widgets/utilities/relations/views/formRelationAssociateData.html',
              showClose: true,
              hidemin: true,
            });
            lastAssociateDialogInChain = true;
          } else
            lastAssociateDialog = extendedNgDialog.open({
              template:
                'js/XG/widgets/utilities/relations/views/formRelationAssociateData.html',
              className:
                'ngdialog-theme-plain no_drop_modal width800 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
              title: $filter('translate')(
                'tools.builder.fields.relations.form.associateformtitle'
              ),
              draggable: true,
            });
        };

        scope.launch1ToNAssociateToNewForm = function() {
          var cTempFeature = angular.copy(TEMPLATE_FEATURE);
          FormsHelper.getOrBuildFeatureId(cTempFeature);
          if (
            scope.nmdata.ftistart &&
            scope.relationholddata.attributes[scope.nmdata.ftistart.uid]
          ) {
            var ftiAttributes =
              scope.relationholddata.attributes[scope.nmdata.ftistart.uid];
            if (ftiAttributes != null) {
              angular.forEach(ftiAttributes, function(value, key) {
                cTempFeature.properties[key] = value;
              });
            }
          }
          scope.currentEditProperties = cTempFeature.properties;

          scope.currentEditFeature = {
            current: {
              properties: scope.currentEditProperties,
            },
          };

          scope.currentActionMode = ADD_MODE;

          openTemplateForEdition();
        };

        scope.processSearch = function() {
          if (
            scope.query.partdata[scope.query.querydata.filterfield.name] &&
            scope.query.partdata[scope.query.querydata.filterfield.name] != ''
          ) {
            var where = '';
            if (scope.query.selop == '%') {
              var likeOper = scope.query.casesensitive ? 'LIKE' : 'ILIKE';
              where =
                scope.query.querydata.filterfield.name +
                ' ' +
                likeOper +
                " '%" +
                scope.query.partdata[scope.query.querydata.filterfield.name] +
                "%'";
            } else
              where +=
                scope.query.querydata.filterfield.name +
                scope.query.selop +
                "'" +
                scope.query.partdata[scope.query.querydata.filterfield.name] +
                "'";

            scope.query.where = where;
          }
          //
        };

        function linkObjectToRelParent(feat) {
          if (
            scope.rel.fieldStart &&
            scope.rel.fieldEnd &&
            scope.current.properties &&
            feat &&
            feat.properties
          ) {
            scope.current.properties[scope.rel.fieldStart] =
              feat.properties[scope.rel.fieldEnd];
            scope.nmdata.relatedfeature = feat;

            var fieldName = scope.nmdata.root
              ? scope.rel.fieldStart
              : scope.rel.type == 'REL_SIMPLE'
                ? scope.rel.fieldStart
                : scope.rel.fieldEnd;

            var ogcobjectid = scope.current.properties[fieldName];

            if (scope.editmode)
              scope.editsession.commitRelation(
                scope.fti,
                scope.rel.name,
                ogcobjectid,
                [scope.nmdata.relatedfeature],
                scope.nmdata.root ? scope.rel.idEnd : scope.rel.idStart
              );

            scope.nmbkp = angular.copy(scope.nmdata);
          }

          scope.closeRelatedData();
        }

        var lastPossibleFormRelationNMFormulaire = null;

        function openPossibleTemplateForEdition() {
          lastPossibleFormRelationNMFormulaire = extendedNgDialog.open({
            template:
              'js/XG/widgets/utilities/relations/views/formViewRelationDestinationFormulaire.html',
            className:
              'ngdialog-theme-plain no_drop_modal width800 nopadding miniclose',
            closeByDocument: false,
            showClose: false,
            scope: scope,
            title: scope.currentEditFeature.current.id,
            draggable: true,
          });
        }

        scope.selectedEditFeature = null;

        function openPossibleRelatedForm(feat) {
          scope.currentEditFeature.current = feat;
          scope.currentActionMode = UPDATE_MODE;

          //scope.launch1ToNOpenForm(openPossibleTemplateForEdition);
          scope.launch1ToNOpenForm(openTemplateForEdition);
        }

        scope.relatedActions = [
          {
            name: 'relateTo',
            icone: 'fa fa-chain',
            callFunction: linkObjectToRelParent,
          },
          {
            name: 'openForm',
            icone: 'fa fa-info',
            callFunction: openPossibleRelatedForm,
          },
        ];

        var lastFormRelationNMFormulaire = null;
        var lastFormRelationNMFormulaireInChain = false;

        function openTemplateForEdition() {
          if (angular.isDefined(scope.chainpopup)) {
            scope.currentEditProperties =
              scope.currentEditFeature.current.properties;
            scope.chainpopup.openNext({
              scope: scope,
              template:
                'js/XG/widgets/utilities/relations/views/formRelationRootFormulaire.html',
              showClose: true,
              hidemin: true,
            });
            lastFormRelationNMFormulaireInChain = true;
          } else
            lastFormRelationNMFormulaire = extendedNgDialog.open({
              template:
                'js/XG/widgets/utilities/relations/views/formRelationRootFormulaire.html',
              className:
                'ngdialog-theme-plain no_drop_modal width800 nopadding miniclose',
              closeByDocument: false,
              showClose: false,
              scope: scope,
              title: scope.currentEditFeature.current.id,
              draggable: true,
            });
        }

        function openSlaveTemplateForEdition() {
          if (angular.isDefined(scope.chainpopup)) {
            scope.currentEditProperties =
              scope.currentEditFeature.current.properties;
            scope.chainpopup.openNext({
              scope: scope,
              template:
                'js/XG/widgets/utilities/relations/views/formRelationDestinationFormulaire.html',
              showClose: true,
              hidemin: true,
            });
            lastFormRelationNMFormulaireInChain = true;
          } else
            lastFormRelationNMFormulaire = extendedNgDialog.open({
              template:
                'js/XG/widgets/utilities/relations/views/formRelationDestinationFormulaire.html',
              className:
                'ngdialog-theme-plain no_drop_modal width800 nopadding miniclose',
              closeByDocument: false,
              showClose: false,
              scope: scope,
              title: scope.currentEditFeature.current.id,
              draggable: true,
            });
        }

        function getIndex(obj) {
          var objId = obj.id ? obj.id : obj.properties.id;
          for (var i = 0; i < scope.nmdata.geojson.features.length; i++) {
            var feat = scope.nmdata.geojson.features[i];
            var featId = obj.id && feat.id ? feat.id : feat.properties.id;
            if (featId == objId) return i;
          }

          return -1;
        }

        function refreshNMData() {
          scope.nmdata.geojson = angular.copy(scope.nmdata.geojson);
        }

        scope.closeRelatedData = function() {
          gclayers.simpleClearhighLightFeatures();
          if (
            angular.isDefined(scope.chainpopup) &&
            lastAssociateDialogInChain == true
          )
            scope.chainpopup.close();
          else if (lastAssociateDialog) {
            lastAssociateDialog.close();
            lastAssociateDialog = null;
          }
        };

        scope.closeNMFormulaire = function(keepEdits) {
          if (
            angular.isDefined(scope.chainpopup) &&
            lastFormRelationNMFormulaireInChain == true
          )
            scope.chainpopup.close();
          else if (lastFormRelationNMFormulaire) {
            lastFormRelationNMFormulaire.close();
            lastFormRelationNMFormulaire = null;
          }

          if (!keepEdits) scope.nmdata = angular.copy(scope.nmbkp);

          scope.currentActionMode = null;
        };

        scope.closeViewNMFormulaire = function(keepEdits) {
          if (lastPossibleFormRelationNMFormulaire) {
            lastPossibleFormRelationNMFormulaire.close();
            lastPossibleFormRelationNMFormulaire = null;
          }

          if (!keepEdits) scope.nmdata = angular.copy(scope.nmbkp);

          scope.currentActionMode = null;
        };

        scope.saveViewNMFormulaire = function() {
          if (
            scope.currentActionMode &&
            scope.currentEditFeature &&
            scope.currentEditFeature.current
          ) {
            switch (scope.currentActionMode) {
            case UPDATE_MODE:
              var currentFeat = scope.currentEditFeature.current;
              scope.editsession.commitEdit(
                currentFeat,
                scope.nmdata.ftistart,
                UPDATE_MODE
              );

              if (scope.nmdata.geojson.features) {
                var index = getIndex(currentFeat);
                if (index != -1) {
                  scope.nmdata.geojson.features.splice(index, 1, currentFeat);

                  scope.nmbkp = angular.copy(scope.nmdata);

                  refreshNMData();
                }
              }
              break;
            case ADD_MODE:
              var currentFeat = scope.currentEditFeature.current;
              currentFeat = scope.editsession.commitEdit(
                currentFeat,
                scope.nmdata.ftistart,
                ADD_MODE
              );

              if (
                scope.rel.fieldStart &&
                  scope.rel.fieldEnd &&
                  scope.current.properties &&
                  currentFeat &&
                  currentFeat.properties
              ) {
                scope.current.properties[scope.rel.fieldStart] =
                    currentFeat.properties[scope.rel.fieldEnd];
                scope.nmdata.relatedfeature = currentFeat;
              }

              if (scope.nmdata.geojson.features) {
                scope.nmdata.geojson.features.push(currentFeat);
                scope.nmdata.geojson.totalFeatures =
                    scope.nmdata.geojson.features.length;

                console.log(scope.nmdata.geojson.features);
                console.log(scope.nmdata.geojson.totalFeatures);
                console.log(scope.nmdata.relatedfeatures);
                scope.nmbkp = angular.copy(scope.nmdata);

                refreshNMData();
              }
              break;

            default:
              break;
            }
          }

          scope.closeViewNMFormulaire(true);
        };

        scope.saveNMFormulaire = function() {
          if (
            scope.currentActionMode &&
            scope.currentEditFeature &&
            scope.currentEditFeature.current
          ) {
            var fieldName = scope.nmdata.root
              ? scope.rel.fieldStart
              : scope.rel.type == 'REL_SIMPLE'
                ? scope.rel.fieldStart
                : scope.rel.fieldEnd;

            var ogcobjectid = scope.current.properties[fieldName];

            switch (scope.currentActionMode) {
            case UPDATE_MODE:
              var currentFeat = scope.currentEditFeature.current;
              // scope.editsession.commitEdit(currentFeat,
              // scope.nmdata.ftistart, 'UPDATE');
              scope.editsession.updateRelationFeature(
                scope.fti,
                scope.rel.name,
                ogcobjectid,
                currentFeat,
                UPDATE_MODE,
                scope.nmdata.root ? scope.rel.idEnd : scope.rel.idStart
              );

              if (scope.nmdata.geojson.features) {
                var index = getIndex(currentFeat);
                if (index != -1) {
                  scope.nmdata.geojson.features.splice(index, 1, currentFeat);

                  scope.nmbkp = angular.copy(scope.nmdata);

                  refreshNMData();
                }
              }
              break;
            case ADD_MODE:
              var currentFeat = scope.currentEditFeature.current;
              // currentFeat = scope.editsession.commitEdit(
              // currentFeat, scope.nmdata.ftistart, 'ADD');
              scope.editsession.updateRelationFeature(
                scope.fti,
                scope.rel.name,
                ogcobjectid,
                currentFeat,
                ADD_MODE,
                scope.nmdata.root ? scope.rel.idEnd : scope.rel.idStart
              );

              if (
                scope.rel.fieldStart &&
                  scope.rel.fieldEnd &&
                  scope.current.properties &&
                  currentFeat &&
                  currentFeat.properties
              ) {
                scope.current.properties[scope.rel.fieldStart] =
                    currentFeat.properties[scope.rel.fieldEnd];

                scope.nmdata.relatedfeature = currentFeat;
              }

              if (scope.nmdata.geojson.features) {
                scope.nmdata.geojson.features.push(currentFeat);
                scope.nmdata.geojson.totalFeatures =
                    scope.nmdata.geojson.features.length;

                if (scope.rel.fieldStart) {
                  scope.relationholddata.data[scope.nmdata.ftistart.uid] = {};
                  scope.relationholddata.data[scope.nmdata.ftistart.uid][
                    scope.rel.fieldStart
                  ] = scope.nmdata.geojson;
                }
                scope.nmbkp = angular.copy(scope.nmdata);

                refreshNMData();
              }
              break;

            default:
              break;
            }
          }

          scope.closeNMFormulaire(true);
        };

        scope.addNewComponent = function() {
          var feature = angular.copy(TEMPLATE_FEATURE);
          if (
            scope.rel.fieldStart &&
            scope.rel.fieldEnd &&
            scope.rel.fieldStart
          ) {
            if (!scope.nmdata.geojson.features) {
              scope.nmdata.relatedfeatures = [];
              scope.nmdata.geojson.features = scope.nmdata.relatedfeatures;
              scope.nmdata.geojson.totalFeatures =
                scope.nmdata.relatedfeatures.length;
              scope.nmdata.geojson.type = 'FeatureCollection';
            }

            FormsHelper.getOrBuildFeatureId(scope.current);

            feature.properties[scope.rel.fieldEnd] =
              scope.current.properties[scope.rel.fieldStart];

            scope.currentEditProperties =
              feature instanceof ol.Feature
                ? feature.getProperties()
                : feature.properties;

            scope.currentEditFeature = {
              current: {
                properties: scope.currentEditProperties,
              },
            };

            scope.currentActionMode = ADD_MODE;

            openSlaveTemplateForEdition();
          }
        };

        scope.updateNMCmp = function(obj) {
          scope.currentEditProperties =
            obj instanceof ol.Feature ? obj.getProperties() : obj.properties;

          scope.currentEditFeature = {
            current: {
              properties: scope.currentEditProperties,
            },
          };

          scope.currentActionMode = UPDATE_MODE;

          openSlaveTemplateForEdition();
        };

        scope.removeNMCmp = function(obj) {
          var index = getIndex(obj);
          if (index != -1) {
            scope.nmdata.geojson.features.splice(index, 1);
            scope.nmdata.geojson.totalFeatures =
              scope.nmdata.geojson.totalFeatures - 1;

            scope.nmbkp = angular.copy(scope.nmdata);

            var fieldName = scope.nmdata.root
              ? scope.rel.fieldStart
              : scope.rel.type == 'REL_SIMPLE'
                ? scope.rel.fieldStart
                : scope.rel.fieldEnd;

            var ogcobjectid = scope.current.properties[fieldName];

            scope.editsession.updateRelationFeature(
              scope.fti,
              scope.rel.name,
              ogcobjectid,
              obj,
              DELETE_MODE,
              scope.nmdata.root ? scope.rel.idEnd : scope.rel.idStart
            );

            refreshNMData();
          }
        };

        scope.closeForm = function(destroyAll) {
          EditProcessService.closeForm(destroyAll);
        };

        scope.hideForm = function() {
          EditProcessService.hideForm();
        };

        scope.updateForm = function() {
          EditProcessService.updateForm();
        };

        scope.saveForm = function() {
          EditProcessService.saveForm();
        };

        scope.buttonNMEditIcon = [
          {
            label: 'Bouton',
            type: 'component',
            description: '',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: {
                name: 'fa fa-edit',
                spinning: false,
              },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-primary cursorHelp',
              label: 'Button',
              title: 'Editer le composant',
            },
          },
          {
            label: 'Bouton',
            type: 'component',
            description: '',
            config: {
              name: 'button',
              click: ['crud_remove'],
            },
            cfg: {
              icon: {
                name: 'fa fa-remove',
                spinning: false,
              },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-danger cursorHelp',
              label: 'Button',
              title: 'Supprimer le composant',
            },
          },
        ];

        scope.nmCrud = {
          update: {
            func: scope.updateNMCmp,
          },
          remove: {
            func: scope.removeNMCmp,
          },
        };
        /* else {
                    scope.buttonNMEditIcon = [];
                    scope.nmCrud = null;
                }*/
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    'extendedNgDialog',
    'QueryFactory',
    'EditProcessService',
    'FeatureTypeFactory',
    'FormsHelper',
    'AdvancedEditionFactory',
    '$filter',
    'gaJsUtils'
  ];
  return gcelement;
});
