'use strict';
define(function() {
  var gcelement = function(
    $timeout,
    extendedNgDialog,
    ConfigFactory,
    $rootScope,
    AssociationFactory,
    gaJsUtils,
    $q,
    $filter,
    QueryFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/select/views/gcselectsearchdata.html',
      restrict: 'E',
      scope: {
        result: '=res',
        geomSelect: '=?',
        formToOpen: '=?',
        confOfFormToOpen: '=?',
        formTitle: '=?',
        associations: '=?',
        templatefields: '=?',
        map: '=?',
        onfinish: '&',
      },
      /**
       * open 'recherche_donnees' form
       */
      link: function(scope) {

        // -- Définition du formulaire de sélection de l'objet à copier
        const FORMULE_NEW = 'js/XG/widgets/mapapp/interventionflow/views/formulaire_new.html';
        const DIALOG_CLASS = 'ngdialog-theme-default  height500'
          + ' nopadding miniclose interventionRenderWrapper';

        // -- Identifiant des messages d'erreur
        const ERR_FORM_NOT_FOUND = 'form_not_found';
        const ERR_CONF_NOT_FOUND_IN_LINK_TABLE = 'configuration_not_found_in_link_table';
        const ERR_NO_FORM_CONFIGURATION = 'no_form_configuration';
        const ERR_NO_SOURCE_VALUE = 'no_source_value';


        /**
         * Affiche une alerte d'erreur (SweetAlert) avec un message traduit.
         * Insère, si fourni, le nom et le type du formulaire dans le message.
         * Réaffiche ensuite la popup parente.
         *
         * @param {string} message
         *   Code du message d'erreur (clé sans le préfixe 'form.selectsearchdata.').
         * @param {{name: string, type: string}=} formDesc
         *   Description du formulaire pour interpolation du message.
         * @returns {void}
         */
        const errorAlert = (message, formDesc) => {
          let messageToDisplay = $filter('translate')('form.selectsearchdata.' + message);
          if (formDesc) {
            messageToDisplay = messageToDisplay.replace('$1',''+formDesc.name);
            messageToDisplay = messageToDisplay.replace('$2',formDesc.type);
          }
          swal(
            {
              title: $filter('translate')('form.selectsearchdata.error_title'),
              type: 'error',
              text: messageToDisplay,
              showCancelButton: false,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.ok'),
              closeOnConfirm: true,
              closeOnClickOutside: false,
            }
          );
          // -- Remettre en place la popup parent
          scope.$parent.dlgPopup.features.show();
        };


        /**
         * Récupère la description du formulaire définie soit par le paramètre formToOpen
         * soit par le paramètre confOfFormToOpen .
         *
         * @param {*} formToOpen : Pointe directement sur le formulaire
         * @param {*} confOfFormToOpen : Contient les éléments de configuration
         *  afin de déterminer le formulaire à ouvrir
         * @returns {Promise} : Promise résolue avec la description du formulaire
         */
        const getFormDesc = (formToOpen, confOfFormToOpen) => {
          const defer = $q.defer();
          const formDesc = {};
          if (!formToOpen && !confOfFormToOpen) {
            errorAlert(ERR_NO_FORM_CONFIGURATION);
            return defer.reject();
          }
          if (formToOpen && formToOpen.name) {
            formDesc.name = formToOpen.name;
            formDesc.type = formToOpen.type;
            defer.resolve(formDesc);
          }
          if (confOfFormToOpen) {
            // -- Identifier la table de liaison et les attributs de travail
            // -- -- Enlever le délimiteur de chaîne de caractères
            let ftiList
              = confOfFormToOpen.linkTable.slice(1, confOfFormToOpen.linkTable.length - 1);
            ftiList = ftiList.split('/');
            // -- -- Cette directive ne travaille que sur un composant
            // -- -- donc, l'UID du FTI est le même pour tous les attributs
            let linkTableUid;
            const attributes = [];
            if (ftiList.length!==0) {
              for (const ftiUidAtt of ftiList) {
                const values = ftiUidAtt.split(';');
                linkTableUid = values[0];
                attributes.push(values[1]);
              }
            }

            // -- Exemple: typeorigine = 'Curage'
            let sourceObject
              = confOfFormToOpen.objectSource.slice(1, confOfFormToOpen.objectSource.length - 1);
            sourceObject = sourceObject.split('.');
            let whereValue = scope.$parent.res;
            for (const prop of sourceObject) {
              whereValue = whereValue[prop];
            }
            if (whereValue===null) {
              errorAlert(ERR_NO_SOURCE_VALUE, {name: confOfFormToOpen.objectSource, type: ''});
              return defer.reject();
            }
            const where = attributes[1] + "='" + whereValue + "'";

            // -- Requêter table liaison pour trouver le formulaire à ouvrir
            QueryFactory.data(linkTableUid, where).then((res) => {
              if (!res.data || !res.data.features || res.data.features.length === 0) {
                errorAlert(ERR_CONF_NOT_FOUND_IN_LINK_TABLE, {name: whereValue, type: ''});
                return defer.reject();
              }
              const linkForm = res.data.features[0].properties[attributes[0]];
              const linkFormElements = linkForm.split('.');
              const elementCount = linkFormElements.length;
              if (elementCount !== 0) {
                formDesc.name = linkFormElements[elementCount - 2];
                formDesc.type = linkFormElements[1];
                defer.resolve(formDesc);
              }
              else {
                defer.reject();
              }
            });
          }
          return defer.promise;
        };


        /**
         * Vérifie si les FTI sont associés et récupère les objets cibles à copier
         *
         * @param {*} ftinames : Liste des FTI à vérifier
         * @returns {Promise} : Promise résolue avec les objets cibles à copier
         */
        const associatedFeatures = (ftinames) => {
          return AssociationFactory
            .allFeatureTypesAreAssociated($rootScope.xgos.portal.parameters.mainDB, ftinames).then(
              (res) => {

                // on lance la récupération également uniquement en présence d'association à charger
                // (sinon getListObjectsCiblesToCopy plante)
                if (typeof res.data === 'boolean' && res.data
                  && Array.isArray(scope.templatefields.association.associationToLoad)
                  && scope.templatefields.association.associationToLoad.length > 0) {
                  AssociationFactory.getListObjectsCiblesToCopy(
                    $rootScope.xgos.portal.parameters.mainDB,
                    scope.templatefields.association.associationToLoad, scope.result.id,
                    scope.templatefields.fti_info.name,true).then((res) => {
                    if (gaJsUtils.notNullAndDefined(scope.associations) &&
                      scope.associations.features && scope.associations.features.length > 0) {
                      scope.associations
                        = gaJsUtils.mergeTwoGetFeatResult(res.data, scope.associations);
                    } else {
                      scope.associations = res.data;
                    }
                  },(err) => {
                    require('toastr').error($filter('translate')(err.data));
                  });
                }
              }
            );
        };


        /**
         * Récupère le nom du FTI du formulaire principal.
         * La manière dont il est stocké dans le cas où ftisData est à utiliser
         * laisse entendre que plusieurs composants peuvent être impliqués.
         *
         * @returns {Array} : Liste des FTI pour gérer les associations
         */
        const mainFtiNames = () => {
          if (scope.templatefields.fti_info) {
            return [scope.templatefields.fti_info.name];
          }
          if (scope.$parent.ftisData) {
            const ftisNames = [];
            for (const ftiUid in scope.$parent.ftisData) {
              ftisNames.push(scope.$parent.ftisData[ftiUid].name);
            }
            return ftisNames;
          }
          return [];
        };


        /**
         * Gestion des associations:
         * -1- empêche les doubles appels
         * -2- copie les résultats du popup enfant vers le parent
         * -3- recharge éventuellement les associations
         * -4- relance les hooks de fin
         * -5- restaure l’UI (affichage du parent).
         */
        const manageAssociatedFeatures = () => {
          //avoid callback to be called twice
          if (!scope.preCloseCallbackExecuted) {
            let promises=[];
            scope.preCloseCallbackExecuted = true;
            if (scope.dlgPopup.scope.doSave && scope.dlgPopup.scope.featureToCopy) {
              scope.result = scope.dlgPopup.scope.featureToCopy;
              scope.geomSelect = scope.dlgPopup.scope.featureToCopy.geometry;
              scope.associations = scope.dlgPopup.scope.associations;

              if (gaJsUtils.notNullAndDefined([$rootScope.xgos, scope.result],
                'portal.parameters.mainDB', true)
                && typeof scope.result.id === 'string' && scope.result.id.includes('.')) {
                const ftinames
                  = [scope.result.id.split('.')[0]].concat(mainFtiNames()).join();

                // KIS-3040: si le composant à copier ou le composant de destination
                // ne possède aucune association, la récupération ne doit pas être lancée
                promises.push(associatedFeatures(ftinames));
              }
            }
            // execute on finish functions
            $q.all(promises).then(()=>{
              $timeout(scope.onfinish);
              //re-display the parent popup
              scope.$parent.dlgPopup.features.show();
            }, error => {
              console.error("Can't get associations objects");
              if (error && typeof error.message === 'string') {
                console.error(error.message);
              }
              scope.$parent.dlgPopup.features.show();
            });
          }
        };


        /**
         * open a dialog containing a 'recherche_donnees'(searchData) form
         *
         * @param {*} formToOpen
         */
        scope.openDialogWithFormSearchData = function(formToOpen, confOfFormToOpen) {

          // hide this popup if we can
          if (scope.$parent.dlgPopup && scope.$parent.dlgPopup.features
            && typeof scope.$parent.dlgPopup.features.hide === 'function') {
            scope.$parent.dlgPopup.features.hide();
          } else {
            // dialog should be hidden but it can't because we don't have the reference
            // to the dialog propertie 'dlgPopup' should be defined in formRender and
            // formFieldRender
            console.error('Impossible de masquer la fenêtre');
          }
          scope.preCloseCallbackExecuted = false;
          getFormDesc(formToOpen, confOfFormToOpen).then((formDesc) => {
            ConfigFactory.get(formDesc.type, formDesc.name + '.form').then((res) => {
              if (res.data=='') {
                errorAlert(ERR_FORM_NOT_FOUND,formDesc);
                return;
              }
              formDesc.template = res.data;
              scope.currentlink = formDesc;
              // generate child popup
              scope.dlgPopup =  extendedNgDialog.open({
                template: FORMULE_NEW,
                className: DIALOG_CLASS,
                formOptions: res.data.options,
                closeByDocument: false,
                scope: scope,
                map: scope.map,
                associations: scope.associations,
                minimizeMaximize: true,
                scrollable: true,
                resizable: true,
                title: scope.formTitle,
                draggable: true,
                minWidth: '570px',
                minHeight: '400px',
                preCloseCallback: manageAssociatedFeatures
              });
            });
          });
        };
      }
    };
  };

  gcelement.$inject = [
    '$timeout',
    'extendedNgDialog',
    'ConfigFactory',
    '$rootScope',
    'AssociationFactory',
    'gaJsUtils',
    '$q',
    '$filter', 'QueryFactory'
  ];
  return gcelement;
});
