#!C:/Python27/python.exe
# -*- coding: utf-8 -*-


import sys , cgi ,cStringIO,socket , json
from StringIO import StringIO
from PIL import Image
#import multiprocessing as mp
import numpy as np
import xml.etree.ElementTree as ET
import urllib3

def createQueryESRI(form):
	keys = form.keys();
	requete = ""

	for s in keys:
		field = form.getvalue(s);
		if s == 'LAYERS':
			field = field.replace(' ','%20');
		query = "%s=%s" %(s,field);
		if "url" in s:
			requete = "%s?%s" %(field,requete)
		else:
			if requete == "":
				requete = "%s" %query
			else:
				requete = "%s&%s" %(requete,query)
	return requete

def getQueryESRI (server , service, boundingBox , crs , size,
	format,transparency,tiled,wmsVersion,layer,
	layerstyle,tilesorigin,cql=""):
	if cql == "":
		return "%s?SERVICE=%s&REQUEST=GetMap&VERSION=%s&FORMAT=%s&TRANSPARENT=%s&LAYERS=%s&STYLES=%s&tiled=%s&WIDTH=%s&HEIGHT=%s&CRS=%s&BBOX=%s,%s,%s,%s&tilesorigin=%s,%s" %(server,service,wmsVersion,format,transparency,layer.replace(' ','%20'),layerstyle,tiled,size[0],size[1],crs,boundingBox[0],boundingBox[1],boundingBox[2],boundingBox[3],tilesorigin[0],tilesorigin[1])
	else:
		return "%s?SERVICE=%s&REQUEST=GetMap&VERSION=%s&FORMAT=%s&TRANSPARENT=%s&LAYERS=%s&STYLES=%s&tiled=%s&WIDTH=%s&HEIGHT=%s&CRS=%s&BBOX=%s,%s,%s,%s&tilesorigin=%s,%s&layerDefs=%s" %(server,service,wmsVersion,format,transparency,layer.replace(' ','%20'),layerstyle,tiled,size[0],size[1],crs,boundingBox[0],boundingBox[1],boundingBox[2],boundingBox[3],tilesorigin[0],tilesorigin[1],cql)


def setOpacityESRI(layer,CQL,wmsSplitted,querySplitted,
	service, boundingBox , crs , size, format,transparency,tiled,
	wmsVersion,tilesorigin,Image_Array): 
	index = wmsSplitted['LAYERS'].index(layer);	
	#if len(wmsSplitted['STYLES']) == 0 :
	layerstyle = "";
	#else:
	#	layerstyle = wmsSplitted['STYLES'][index];
	THECQL = CQL.replace('&','').replace('=','');

	if THECQL in wmsSplitted.keys():
		if wmsSplitted[THECQL][index] == '{}':
			cql = "";
		else:
			cqlObj = json.loads(','.join(wmsSplitted[THECQL]))[str(layer).replace('%20' , ' ')];
			cql = '{"%s":"%s"}' %(layer.replace(' ','%20'),cqlObj)
	else:
		cql = "";

	deuxpt='%2F'
	slach='%3A'
	virgu='%2C'
	sup='%3E'
	inf='%3C';
	query = getQueryESRI(querySplitted[0], service, boundingBox , crs , size, format,transparency,tiled,wmsVersion,layer,layerstyle,tilesorigin,cql);
	if THECQL in wmsSplitted.keys():
		term1 = query.split('?');
		term1[1] = term1[1].replace('/','%s' %deuxpt).replace(':','%s' %slach).replace(',','%s' %virgu).replace('>','%s' %sup).replace('<','%s' %inf).replace(' ','%20');
		query = '%s?%s' %(term1[0],term1[1])
		term1 = query.split('layerDefs');
		term1[1] = term1[1].replace('%s' %slach , ':')
		query = '%slayerDefs%s' %(term1[0],term1[1])

	http = urllib3.PoolManager();
	img = http.request('GET', query.replace(' ','')).data ;
	try:
		tree = ET.parse(StringIO(img));
		root = tree.getroot();
		if "Could not find layer" in root[0].text :
			Image_Array.append("noLayer");
			return Image_Array;
	except:
		image = Image.open(StringIO(img)).convert("RGBA");
		x = np.array(image)
		r, g, b, a = np.rollaxis(x, axis=-1)
		# Opacity traitement
		if 'OPACITY' in wmsSplitted.keys():
			Opacity = float(wmsSplitted['OPACITY'][index]);
			for sel in range(len(a)):
				a[sel] = (a[sel]*float(Opacity)).astype(int);
			x = np.dstack([r, g, b, a])				
			image = Image.fromarray(x , "RGBA")		
		else:
			Opacity = "";

		Image_Array.append(image);
		return Image_Array;

def treatmentESRI(wmsSplitted,CQL,querySplitted,Image_Array):
	if wmsSplitted['REQUEST'] == 'GetMap':
		boundingBox = wmsSplitted['BBOX'];
		crs = wmsSplitted['CRS'];
		size = ( wmsSplitted['WIDTH'] , wmsSplitted['HEIGHT'] );
		format = wmsSplitted['FORMAT'];
		transparency = wmsSplitted['TRANSPARENT'];
		tiled = wmsSplitted['tiled'];
		wmsVersion = wmsSplitted['VERSION'];
		tilesorigin = wmsSplitted['tilesorigin'];
		service = wmsSplitted['SERVICE'];
		
		for layer in wmsSplitted['LAYERS']:
			Image_Array = setOpacityESRI(layer,CQL,wmsSplitted,querySplitted,
						service, boundingBox , crs , size, format,transparency,tiled,
						wmsVersion,tilesorigin,Image_Array)

		if Image_Array[0] != "noLayer":
			image_Final = Image_Array[0];


		index = 1 ;
		while index < len(Image_Array):
			if Image_Array[index-1] != "noLayer" and Image_Array[index] != "noLayer":
				image_Final = Image.alpha_composite(image_Final , Image_Array[index]);
			else:
				if Image_Array[index] != "noLayer":
					image_Final = Image_Array[index];
			index += 1;

		f = cStringIO.StringIO()
		image_Final.save(f, 'png')
		f.seek(0)
		# Renvoie du png
		sys.stdout.write('Content-type: image/png\n\n')
		sys.stdout.write(f.getvalue())

def mainesri(form):
	
	CQL = "&layerDefs="
	if sys.platform == "win32":
		import os, msvcrt
		# sinon \n (0x0A) est transformé en \rn (0xOD 0x0A)
		msvcrt.setmode(1,os.O_BINARY)
	requete = createQueryESRI(form);

	if 'OPACITY' in requete or CQL in requete :
		if len(set(form.getvalue('OPACITY').split(','))) == 1 and list(set(form.getvalue('OPACITY').split(',')))[0] == 1 and len(set(form.getvalue('CQL_FILTER').split(','))) == 1 and list(set(form.getvalue('CQL_FILTER').split(',')))[0] == '1=1':
			http = urllib3.PoolManager()
			# Renvoie du png
			requete = "%s&STYLES=" %requete
			sys.stdout.write('Content-type: image/png\n\n')
			sys.stdout.write(http.request('GET', requete).data);
		else:
			querySplitted = requete.split("?");
			part2 = querySplitted[1];
			Arraydata = part2.split("&");
			wmsSplitted = {};
			for n in Arraydata :
				if "=" not in n :
					n = "%s=" %n;
				ArraySplit = n.split("=",1);
				Array = ArraySplit[1].split(",");
				if len(Array) > 1 or ArraySplit[0] == 'LAYERS' or ArraySplit[0] == 'STYLES' or ArraySplit[0] in CQL or ArraySplit[0] == 'OPACITY':
					wmsSplitted[ArraySplit[0]] = Array;		
				else :
					wmsSplitted[ArraySplit[0]] = ArraySplit[1];
			Image_Array = [];
			treatmentESRI(wmsSplitted,CQL,querySplitted,Image_Array);
	else:
		http = urllib3.PoolManager()
		# Renvoie du png
		requete = "%s&STYLES=" %requete
		sys.stdout.write('Content-type: image/png\n\n')
		sys.stdout.write(http.request('GET', requete).data);

if __name__ == "__main__":
	form = cgi.FieldStorage();
	try:
		#sys.stdout.write('Content-type: text/html\n\n')
		mainesri(form);
	except:
		sys.stdout.write('Content-type: image/png\n\n')