'use strict';
define(function() {
  var ApplyProcedureFactory = function(
    $http,
    $q,
    EditFactory,
    QueryFactory,
    FeatureTypeFactory
  ) {
    var Edit = {};
    /**
         * Class : ApplyProcedureFactory
         * Factory WebServices
         * 
         *        This class role is to create the proceure steps of a project.
         *    The step definition is gottzn from the project type.
         *    All the information is described in the confoguration of the action
         *    which is run in the TypeProjetCtrl controller.
         *    Here is an example of action configuration:
         *    {
         *      //-- ACtion type which trigger the call to this service
                "type": "ApplyProcedureSteps",
                //-- Data store name in order to use the FeatureTypeFactory that retrieves the needed layers.
                "storeName": "yamoussoukro",
                //-- Name of the project table or layer.
                "projectTableName": "day_projet_soumis",
                //-- Name of the identifier field of the project type in the project table.
                "projectIdFieldOfType": "id_type_projet",
                //-- Name of the table storing the steps of the procedure followed by this propject.
                "stepTableName": "day_projet_etape_procedure",
                //-- Predefined steps table where we read the steps to create for this project.
                "predefStepTableName": "day_projet_etapes_predefinies",
                //-- Name of the field containing the type of procedure this project is following.
                "predefStepIdFieldOfType": "id_type_procedure",
                //-- Name of the field containing the identiofier of the project in the step table.
                "projectIdFieldOfStepTable": "id_projet"
              }  
         * 
         */

    /**
     * Function: add
     * Insert the steps of the project.
     */
    function addObjects(fid, senddata, deferred) {
      var features, ind1;

      //-- Build GeoJSON object describing the objects we want to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      for (ind1 = 0; ind1 < senddata.length; ind1++) {
        features.features[ind1] = {};
        features.features[ind1].type = 'feature';
        features.features[ind1].properties = senddata[ind1];
        features.features[ind1].geometry = {};
      }

      //-- Do the insert
      EditFactory.add(fid, features).then(function(res) {
        if (res.statusText != 'OK' || res.data.errors.ERROR != undefined) {
          var errorMsg = '<h4>Erreur</h4> ';
          errorMsg +=
            "<br/><h4>Details</h4>  Echec de l'ajout d'objets en base !";
          errorMsg += '<br/>' + res.data.errors.ERROR;
          require('toastr').error(errorMsg);
          deferred.resolve('not created');
        } else deferred.resolve('created');
      });
    }

    //stepTableDesc,projectTableDesc,projectId,predefStepTable,predefStepId
    function createNewSteps(
      stepTableDesc,
      projectTableDesc,
      projectId,
      predefStepTableDesc,
      res,
      deferred
    ) {
      var ind1,
        senddata = [],
        ind2,
        ind3,
        prop,
        att;

      for (ind1 = 0; ind1 < res.data.features.length; ind1++) {
        //-- Add a step record in the list of the steps to add.
        senddata[ind1] = {};
        prop = res.data.features[ind1].properties;
        //-- Standard (normal) attributes
        for (ind2 = 0; ind2 < stepTableDesc.attributes.length; ind2++) {
          att = stepTableDesc.attributes[ind2].name;
          if (prop.hasOwnProperty(att)) senddata[ind1][att] = prop[att];
        }
        //-- Relation attribute
        for (ind3 = 0; ind3 < projectTableDesc.relations.length; ind3++)
          if (
            projectTableDesc.relations[ind3].componentEnd == stepTableDesc.name
          ) {
            att = projectTableDesc.relations[ind3].fieldEnd;
            senddata[ind1][att] = projectId;
          }
      }
      //-- Create all the copied steps.
      addObjects(stepTableDesc.uid, senddata, deferred);
    }

    function applyCreateSteps(
      config,
      stepTableDesc,
      projectTableDesc,
      predefStepTableDesc,
      deferred
    ) {
      var where = '';
      //-- Read steps associated to the procedure (project type)
      //-- when predefStepTypeId contains "__none__" we take the whole content
      //-- which case corresponds to procedure of marche for example.
      //-- In this case there is one list of steps and the list of steps is in one table.
      if (config.predefStepTypeId != '__none__')
        where = config.predefStepIdFieldOfType + '=' + config.predefStepTypeId;
      QueryFactory.data(predefStepTableDesc.uid, where).then(function(res) {
        //-- Create new steps
        createNewSteps(
          stepTableDesc,
          projectTableDesc,
          config.projectId,
          predefStepTableDesc,
          res,
          deferred
        );
      });
    }

    /**
     * Function: apply
     * config contains:
     *      + storeName
     *      + projectTableName
     *      + projectId
     *      + stepTablename
     *      + predefStepTableName
     *      + predefStepIdFieldOfType
     *      + projectIdFieldOfStepTable
     *      + predefStepTypeId
     *
     */
    function apply(config) {
      var deferred = $q.defer();
      //-- Get the description of each feature type
      var stepTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        config.storeName,
        config.stepTableName
      );
      var projectTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        config.storeName,
        config.projectTableName
      );
      var predefStepTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        config.storeName,
        config.predefStepTableName
      );
      if (config.projectId == undefined)
        //-- No existing steps to remove
        applyCreateSteps(
          config,
          stepTableDesc,
          projectTableDesc,
          predefStepTableDesc,
          deferred
        );
      //-- Remove existing steps
      else
        EditFactory.deleteWhere(
          stepTableDesc.uid,
          config.projectIdFieldOfStepTable + '=' + config.projectId
        ).then(function(res) {
          var where = '';
          console.log(res.data);
          if (res.data['delete'][0] == 'success') {
            applyCreateSteps(
              config,
              stepTableDesc,
              projectTableDesc,
              predefStepTableDesc,
              deferred
            );
          }
        });
      return deferred.promise;
    }

    function deleteProcedureMainSteps(deleteProcedureParams) {
      //-- Remove existing steps
      var config = deleteProcedureParams.config;
      EditFactory.deleteWhere(
        deleteProcedureParams.stepTableDesc.uid,
        config.projectIdFieldOfStepTable + '=' + config.projectId
      ).then(function(res) {
        var where = '';
        console.log(res.data);
        if (res.data['delete'][0] == 'success')
          deleteProcedureParams.deferred.resolve('deleted');
        else deleteProcedureParams.deferred.resolve('not deleted');
      });
    }

    function deleteProcedureStepDeleted(deleteProcedureParams) {
      deleteProcedureParams.deletedStep++;
      if (
        deleteProcedureParams.deletedStep ==
        deleteProcedureParams.features.length
      ) {
        //-- Every step specific teble records have been deleted
        deleteProcedureMainSteps(deleteProcedureParams);
      }
    }

    /**
     * Function: apply
     * config contains:
     *      + storeName
     *      + projectTableName
     *      + projectId
     *      + stepTablename
     *      + predefStepTableName
     *      + predefStepIdFieldOfType
     *      + projectIdFieldOfStepTable
     *      + predefStepTypeId
     *
     */
    function deleteProcedure(config) {
      //-- Get the description of each feature type
      var stepTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        config.storeName,
        config.stepTableName
      );
      var projectTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        config.storeName,
        config.projectTableName
      );
      var predefStepTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        config.storeName,
        config.predefStepTableName
      );

      var deleteProcedureParams = {};
      deleteProcedureParams.deferred = $q.defer();

      QueryFactory.data(
        stepTableDesc.uid,
        config.projectIdFieldOfStepTable + '=' + config.projectId
      ).then(function(res) {
        var tDesc,
          features = res.data.features;
        deleteProcedureParams.features = features;
        deleteProcedureParams.deletedStep = 0;
        deleteProcedureParams.config = config;
        deleteProcedureParams.stepTableDesc = stepTableDesc;
        //-- Delete steps if specific table
        for (var iFeat = 0; iFeat < features.length; iFeat++) {
          if (features[iFeat].properties.table_specifique == null)
            deleteProcedureStepDeleted(deleteProcedureParams);
          else {
            tDesc = FeatureTypeFactory.getFeatureTypeDesc(
              config.storeName,
              features[iFeat].properties.table_specifique
            );
            EditFactory.deleteWhere(
              tDesc.uid,
              'id_etape=' + QueryFactory.getFeatureId(features[iFeat])
            ).then(function() {
              deleteProcedureStepDeleted(deleteProcedureParams);
            });
          }
        }
      });

      return deleteProcedureParams.deferred.promise;
    }
    return {
      deleteProcedure: deleteProcedure,
      ApplyProcedureFactory: ApplyProcedureFactory,
      apply: apply,
    };
  };
  ApplyProcedureFactory.$inject = [
    '$http',
    '$q',
    'EditFactory',
    'QueryFactory',
    'FeatureTypeFactory',
  ];
  return ApplyProcedureFactory;
});
