/**
 *
 */
'use strict';
define(function() {
  var FormFieldPanelCtrl = function(
    $scope,
    QueryFactory,
    FeatureTypeFactory,
    UnitsFactory,
    GlobalServices,
    gaJsUtils
  ) {
    var fieldDesc, fieldValue, fieldActions;
    var objectFields, specialFields, excludedFields;
    var fieldOrder;
    var panelFields, hiddenFields;
    var relations;
    var relMainFields, relationsCfg;
    var ind0 = 0,
      ind1,
      ind2 = 0,
      ind3,
      ind4;
    var fn;
    var indFD;
    var fieldList = [];
    var fieldGroups = [];
    var panel, config;
    var inlineConfigs,
      inlineInput = null;

    $scope.fieldList = fieldList;
    $scope.fieldGroups = fieldGroups;

    $scope.QueryFactory = QueryFactory;

    $scope.getPanelDescriptionFromParent = function() {
      fieldDesc = $scope.$parent.descField;
      objectFields = $scope.$parent.objectFields;
      if ($scope.$parent.config != null) {
        config = $scope.$parent.config;
        fieldOrder = config.fieldOrder;
        panelFields = config.panelFields;
        specialFields = config.specialFields;
        relMainFields = config.tableMainFields;
        relationsCfg = config.relations;
        inlineConfigs = config.inlineConfig;
        fieldActions = config.fieldActions;
        excludedFields = config.excludedFields;
        if (config.inlineInput != null)
          inlineInput = $scope.$parent.config.inlineInput;
      }
      if ($scope.$parent.excludedFields != undefined)
        excludedFields = $scope.$parent.excludedFields;
    };

    $scope.getPanel = function() {
      var parent;
      if ($scope.$parent == undefined) parent = {};
      else parent = $scope.$parent;

      if (parent.cont != undefined) panel = parent.cont;
      else if (parent.tab != undefined) panel = parent.tab;
      else if ($scope.theStep != undefined) panel = $scope.theStep;
      else if (parent.theStep != undefined) panel = parent.theStep;
      else if ($scope.fieldDesc != undefined) panel = $scope;
    };

    $scope.getInlineInput = function() {
      if (panel.inlineInput != undefined) inlineInput = panel.inlineInput;
      else if (
        panel.fieldDesc != undefined &&
        panel.fieldDesc.inlineInput != undefined
      )
        inlineInput = panel.fieldDesc.inlineInput;
      if (inlineInput != null) {
        fieldDesc.inlineInput = inlineInput;
        /*
                    if (fieldDesc.inlineInput!=null)
                        inlineInput = fieldDesc.inlineInput;
                        */
      }
    };

    $scope.getInlineConfig = function() {
      if (fieldDesc != undefined) inlineConfigs = fieldDesc.inlineConfigs;
      if (inlineConfigs == undefined && panel.config != undefined)
        inlineConfigs = panel.config.inlineConfigs;
      if (panel.fieldDesc != undefined)
        if (
          inlineConfigs == undefined &&
          panel.fieldDesc.inlineConfig != undefined
        )
          inlineConfigs = panel.fieldDesc.inlineConfig;
      if (inlineConfigs == undefined && panel.inlineConfigs != undefined)
        inlineConfigs = panel.inlineConfigs;
    };

    $scope.getPanel();

    if (panel != null) {
      fieldDesc = panel.fieldDesc;
      objectFields = panel.objectFields;
      fieldOrder = panel.fieldOrder;
      panelFields = panel.panelFields;
      relMainFields = panel.tableMainFields;
      relationsCfg = panel.relations;
      specialFields = panel.specialFields;
      excludedFields = panel.excludedFields;
      fieldActions = panel.fieldActions;
      config = panel.config;
      if (config != undefined) {
        if (fieldActions == undefined) fieldActions = config.fieldActions;
        if (excludedFields == undefined) excludedFields = config.excludedFields;
        if (specialFields == undefined) specialFields = config.specialFields;
        if (relMainFields == undefined) relMainFields = config.tableMainFields;
        $scope.reportFields = config.reportFields;
      }

      $scope.getInlineConfig();

      $scope.getInlineInput();
    } else {
      if ($scope.$parent != null) {
        $scope.getPanelDescriptionFromParent();
        panel = $scope.$parent;
      }
    }

    $scope.setDateFromObjToString = function(dDate) {
      var val;
      var newStrDate = dDate.getFullYear() + '-';
      if ((val = 1 + dDate.getMonth()) < 10) newStrDate += '0';
      newStrDate += val + '-';
      if ((val = dDate.getDate()) < 10) newStrDate += '0';
      newStrDate += val;

      return newStrDate;
    };

    /**yyyyyyyyyyy commenter  TODO
     *
     */
    $scope.setDate = function(objFieldValue) {
      var strDate, dDate, ms, val;

      if (objFieldValue != null && objFieldValue.trim != undefined) {
        //-- Actually the date is a string ...
        //-- Betting the date has the expected JAVA GEoJSson format
        //-- convert it into a Date (format example: 2015-02-03T23:00:00.000+0000)
        strDate = objFieldValue;
        dDate = new Date();
        dDate.setFullYear(strDate.substr(0, 4));
        dDate.setMonth(strDate.substr(5, 2) - 1);
        dDate.setDate(strDate.substr(8, 2));
        dDate.setHours(strDate.substr(11, 2));
        dDate.setMinutes(strDate.substr(14, 2));
        dDate.setSeconds(strDate.substr(17, 2));
        //----- TODO Modify server side after better DATE managemen
        //-- Date returned is day-1 23H00 so we add 2 hours
        //-- (one should be enough ...) to display correct date.
        //-- In the DB the displayed date is OK.
        //-- When date will be better managed we'll get rid of this.
        ms = dDate.getTime() + 7200000; //  = 60 secondes x 1000 x 60 minutes x 2 heures
        dDate.setTime(ms);
        // //$scope.fieldList[ind].objectField.value = dDate;
        return $scope.setDateFromObjToString(dDate);
        //return strDate.substr(0,10);
      }
    };

    /**
     *     In case an objectField is received with properties
     *  we change it to an object>Fields which contains directly
     *  these properties as attributes.
     */
    $scope.prepareObjectFields = function() {
      var newObjFields, prop, propName;

      //-- If properties attribute exists we have to convert the object.
      if (objectFields.properties != undefined) {
        //-- Create the new objectFields instance.
        newObjFields = {};
        //-- Move the properties to direct attributes.
        for (propName in objectFields.properties)
          newObjFields[propName] = objectFields.properties[propName];
        //-- Make the new object the one we are going to work with.
        objectFields = newObjFields;
        //-- If values are to be gotten from parent widget
        //-- set the value of the fiedls concerned by the inheritance.
        //-- "inheritedAttributes" comes from SearchResult which in turn comes from
        //-- searchResultModifyConfig read from the original configuration file used
        //-- by the widget"cherchermodsup".
        if ($scope.inheritedAttributes != undefined)
          for (var ind = 0; ind < config.inheritedAttributes.length; ind++) {
            prop = $scope.inheritedAttributes[ind];
            if (objectFields[prop.fieldName] != undefined)
              objectFields[prop.fieldName] = prop.fieldValue;
          }
      }
    };

    $scope.getInheritedValue = function(fieldName) {
      var prop;

      //-- If values are to be gotten from parent widget
      //-- set the value of the fiedls concerned by the inheritance.
      //-- "inheritedAttributes" comes from SearchResult which in turn comes from
      //-- searchResultModifyConfig read from the original configuration file used
      //-- by the widget"cherchermodsup".
      if ($scope.inheritedAttributes != undefined)
        for (var ind = 0; ind < $scope.inheritedAttributes.length; ind++) {
          prop = $scope.inheritedAttributes[ind];
          if (prop.fieldName == fieldName) return prop.fieldValue;
        }
      return '';
    };

    /**
     *     Management of special fields, mainly configuration settings
     *  to set on the field itself in in order to make the FormField
     *  module more independent.
     *  Treated cases are:
     *  - enabledConditions in order to enable or disable a field
     *                      depending on another field value.
     *  - alias the default field alias from model description can be overwritten
     *                      using the special fields configuration,
     *                      this piece of configuration is also useful
     *                      in order to give an alias to relation.
     *  - comment fields, these ones are text areas with more than on line.
     *  - radio buttons, an attribute input (display) can be done through
     *                   radio buttons if the description is done in the configuration.
     *  - relation dependency allows to change the content of one field depending on
     *                   another one, an example is the list of "sous préfecture"
     *                   depends on the selected "département".
     */
    $scope.manageSpecialField = function(ind0, ind1) {
      var ind;
      var sf = specialFields[fieldOrder[ind1]];

      //-- enabledConditions
      if (sf.enabledCondition != undefined) {
        if (fieldList[ind0].fieldDesc == undefined)
          fieldList[ind0].fieldDesc = {};
        fieldList[ind0].fieldDesc.enabledDependsOn = sf.enabledCondition;
      }

      //-- visibility conditions
      if (sf.visibleCondition != undefined) {
        if (fieldList[ind0].fieldDesc == undefined)
          fieldList[ind0].fieldDesc = {};
        fieldList[ind0].fieldDesc.visibilityDependsOn = sf.visibleCondition;
      }

      if (sf.dependentFields != undefined) {
        fieldList[ind0].fieldDesc.dependentFields = sf.dependentFields;
      }

      //-- Specific alias
      if (sf.alias != undefined) {
        if (fieldList[ind0].fieldDesc == undefined)
          fieldList[ind0].fieldDesc = {};
        fieldList[ind0].fieldDesc.alias = sf.alias;
        fieldList[ind0].fieldDesc.forceAlias = sf.forceAlias == 'true';
      }

      //--
      if (sf.selectWithForm != undefined) {
        if (fieldList[ind0].fieldDesc == undefined)
          fieldList[ind0].fieldDesc = {};
        fieldList[ind0].fieldDesc.selectWithForm = sf.selectWithForm;
      }

      //-- Comment fields can only be set from configuration
      if (sf.rows != undefined) fieldList[ind0].rows = sf.rows;

      if (sf.type != undefined) {
        if (sf.type == 'comment') {
          if (fieldList[ind0].fieldDesc != null) {
            fieldList[ind0].fieldDesc.fieldTypeIsComment = true;
            fieldList[ind0].fieldDesc.fieldTypeIsString = false;
          }
        }

        if (sf.type == 'radio_button') {
          if (fieldList[ind0].fieldDesc != null) {
            fieldList[ind0].fieldDesc.fieldTypeIsRadioButton = true;
            fieldList[ind0].fieldDesc.buttons = sf.buttons;
          }
        }
      }

      if (fieldList[ind0].fieldDesc == undefined)
        fieldList[ind0].fieldDesc = {};
      if (sf.dependencies != null)
        fieldList[ind0].fieldDesc.dependencies = sf.dependencies;
      if (sf.groupSelect != null)
        fieldList[ind0].fieldDesc.groupSelect = sf.groupSelect;
      if (sf.relation != null) fieldList[ind0].fieldDesc.relation = sf.relation;
      if (sf.configName != undefined)
        fieldList[ind0].configName = sf.configName;

      if (sf.storeAs != undefined) fieldList[ind0].storeAs = sf.storeAs;
    };

    $scope.getConfigOfMoreInput = function(fieldName, config) {
      var indCfg, len;

      //-- fieldName is like __moreInputs__0__
      //-- moreInputConfig is an array of configurations.
      if (config.moreInputs != undefined) {
        //-- Calculate the length of the index
        len = 1;
        while (fieldName.substr(14 + len, 1) != '_') len++;
        //-- Get the index from the field name
        indCfg = parseInt(fieldName.substr(14, len));
        //-- If the index is in the bounds of the array, return the matching configuration.
        if (indCfg < config.moreInputs.length)
          return config.moreInputs[indCfg].moreInputConfig;
      }
      //-- Could not get the configuration so return NULL.
      return null;
    };

    $scope.getValueFrom = function(object, theField, theFieldBis, fieldDesc) {
      if (theField == 'id') {
        if (object.hasOwnProperty(theField))
          return QueryFactory.getFeatureId(object);
        else return $scope.objectId;
      } else {
        if (object.hasOwnProperty(theField)) {
          if (
            fieldDesc != undefined &&
            fieldDesc.type != undefined &&
            fieldDesc.type.indexOf('.Date') != -1
          )
            return $scope.setDate(object[theField]);
          else return object[theField];
        } else if (object.hasOwnProperty('properties')) {
          if (object.properties.hasOwnProperty(theField)) {
            if (fieldDesc != undefined && fieldDesc.type.indexOf('.Date') != -1)
              return $scope.setDate(object.properties[theField]);
            else return object.properties[theField];
          } else {
            var indPt = theFieldBis.lastIndexOf('.');
            var val;
            if (indPt == -1) val = object.properties[theFieldBis];
            else val = object.properties[theFieldBis.substr(indPt + 1)];
            if (
              fieldDesc != undefined &&
              fieldDesc.type.indexOf('.Date') != -1
            ) {
              if (fieldDesc.type == undefined) val = 'yy';
              val = $scope.setDate(val);
            }
            return val;
          }
        } else return '';
      }
    };

    $scope.prepareStepContainer = function(ind1) {
      $scope.stepContainer = true;
      $scope.stepConfig = panelFields[ind1];
      $scope.stepDescField = panel.fieldDesc;
      //-- ComponentEnd is useful for step container
      for (var ind2 = 0; ind2 < panel.fieldDesc.relations.length; ind2++) {
        var ftinforel = FeatureTypeFactory.getFeatureTypeDesc(
          panel.fieldDesc.storeName,
          panel.fieldDesc.relations[ind2].componentEnd
        );
        panel.fieldDesc.relations[ind2].componentEndDescField = ftinforel;
      }
      //-- Called from relation form field so parent is probably not known
      if ($scope.relatedObjects != undefined) {
        if ($scope.relatedObjects.features.length == 0)
          $scope.objectId = undefined;
        else
          $scope.objectId = QueryFactory.getFeatureId(
            $scope.relatedObjects.features[0]
          );
      }
    };

    $scope.sendFieldsInfo = function() {
      for (var ind = 0; ind < $scope.relFieldsInfo.length; ind++)
        $scope.$broadcast('gotRelatedObjects', $scope.relFieldsInfo[ind]);
      $scope.relFieldsInfo.splice(0, $scope.relFieldsInfo.length);
    };

    $scope.getRelatedDescForRelation = function(
      tableDesc,
      fieldName0,
      panelField,
      objectFields
    ) {
      var desc,
        relations = tableDesc.relations;
      var indPt2 = fieldName0.lastIndexOf('.');
      var fn = fieldName0.substr(indPt2 + 1);

      // No description provided for the field: is it a relation ?
      for (var indFD = 0; indFD < relations.length; indFD++) {
        if (relations[indFD].name == fn) {
          if (panelField != undefined) desc = panelField;
          else desc = {};
          desc.relation = relations[indFD];
          desc.fieldDesc = {};
          desc.fieldDesc.fieldTypeIsRelation = true;

          if (relations[indFD].occurence != '1-1' && inlineInput == null)
            desc.fieldDesc.inlineInput = true;
          else desc.fieldDesc.inlineInput = inlineInput;

          // Look for name of fields which values will be displayed
          for (ind3 = 0; ind3 < relMainFields.length; ind3++)
            if (relMainFields[ind3].table == relations[indFD].componentEnd) {
              desc.relatedObjectField = relMainFields[ind3].fields[0];
              desc.relatedObjectFields = relMainFields[ind3].fields;
              relFieldName = relations[indFD].fieldStart;
              break;
            }
          if (ind3 == relMainFields.length)
            for (ind3 = 0; ind3 < relMainFields.length; ind3++)
              if (
                relMainFields[ind3].table == relations[indFD].componentStart
              ) {
                desc.relatedObjectField = relMainFields[ind3].fields[0];
                desc.relatedObjectFields = relMainFields[ind3].fields;
                relFieldName = relations[indFD].fieldEnd;
                break;
              }

          // Store relation start field value in order to be able
          // to get objects already in relation with this one.
          if (desc.objectId == null) {
            if (relations[indFD].fieldStart == 'id')
              //                                                          fieldList[ind0].objectId = QueryFactory.getFeatureId( objectFields );
              desc.objectId = $scope.objectId;
            else desc.objectId = objectFields[relations[indFD].fieldStart];
          }
          desc.field = fieldName0;
          desc.featureName = tableDesc.name;
          desc.datastoreName = tableDesc.storeName;
          return desc;
        }
      }
    };

    $scope.getRelatedDesc = function(fieldName0, storeName) {
      var indPt2 = fieldName0.lastIndexOf('.');
      var fn = fieldName0.substr(indPt2 + 1);
      var indPt1 = fieldName0.lastIndexOf('.', indPt2 - 1);
      var tn = fieldName0.substr(indPt1 + 1, indPt2 - indPt1 - 1);

      return FeatureTypeFactory.getFeatureTypeDesc(storeName, tn);
    };

    $scope.getRelatedDescForFieldList = function(tableDesc, fieldName0) {
      var indPt2 = fieldName0.lastIndexOf('.');
      var fn = fieldName0.substr(indPt2 + 1);

      for (var ind = 0; ind < tableDesc.attributes.length; ind++)
        if (tableDesc.attributes[ind].name == fn)
          return tableDesc.attributes[ind];
      return null;
    };

    $scope.getRelatedFieldInformation = function(
      fieldName0,
      fieldName,
      relations,
      object,
      storeName,
      inTableDesc
    ) {
      var tableName, tableDesc, where, theField;
      var fn, val;
      var indPt = fieldName.indexOf('.');

      if (indPt == -1) {
        console.log('getRelatedFieldInformation: FIN  object.id=' + object.id);
        //-- The parent who does the update into the database
        //-- must know the id of the related object, so we send it now.
        if (object.id != undefined)
          $scope.$emit('gotRecordIdOfRelatedField', {
            id: object.id,
            theField: $scope.fieldList[ind0],
          });
        console.log(
          'getRelatedFieldInformation: $scope.fieldList.length:' +
            $scope.fieldList.length
        );
        //-- No point in the field name so we reached the field name.
        for (var ind0 = 0; ind0 < $scope.fieldList.length; ind0++) {
          var aaa = false;
          if ($scope.fieldList[ind0] === undefined) aaa = true;
          else if (
            $scope.fieldList[ind0].objectField !== undefined &&
            $scope.fieldList[ind0].objectField.setByGrfi
          )
            continue;
          //-- When the field name is found we set its value and description.
          if ($scope.fieldList[ind0].objectField == undefined) {
            fn = $scope.fieldList[ind0].field;
            $scope.fieldList[ind0].objectField = {};
            $scope.fieldList[ind0].objectField.name = fn;
            $scope.fieldList[ind0].objectField.setByGrfi = false;
          } else {
            fn = $scope.fieldList[ind0].objectField.name;
            if (fn != fieldName0) fn = $scope.fieldList[ind0].field;
          }
          console.log(
            'getRelatedFieldInformation  fn=[' +
              fn +
              ']   fieldName0=[' +
              fieldName0 +
              ']'
          );
          if (fn == fieldName0) {
            $scope.fieldList[ind0].objectField.value = $scope.getValueFrom(
              object,
              fieldName,
              $scope.fieldList[ind0].objectField.name,
              $scope.fieldList[ind0].fieldDesc
            );
            if ($scope.fieldList[ind0].objectField.value != '')
              $scope.fieldList[ind0].objectField.setByGrfi = true;

            $scope.$broadcast('gotFieldValue', {
              theField: $scope.fieldList[ind0],
              objectId: object.id,
            });
            //-- In case we caome here after field controller has already been
            //-- let the fieldDesc as it is, else we're gonna loose its configuration.
            //-- So only set fieldDesc when not already set.
            if ($scope.fieldList[ind0].fieldDesc == undefined)
              for (
                var indFd = 0;
                indFd < inTableDesc.attributes.length;
                indFd++
              )
                if (inTableDesc.attributes[indFd].name == fieldName) {
                  $scope.fieldList[ind0].fieldDesc =
                    inTableDesc.attributes[indFd];
                  break;
                }
            if ($scope.relFieldsInfo == undefined) $scope.relFieldsInfo = [];
            if (object.properties != undefined) {
              $scope.relFieldsInfo.push({
                updatedFromPanel: '',
                fieldName: fieldName,
                feature: object,
              });
              setTimeout($scope.sendFieldsInfo, 500);
            }
            break;
          }
        }
      } else {
        //-- Still a point in the field name so we've got to find a related object.
        tableName = fieldName.substr(0, indPt);
        for (var indRel = 0; indRel < relations.length; indRel++) {
          if (relations[indRel].componentEnd == tableName) {
            theField = relations[indRel].fieldStart;
            where = relations[indRel].fieldEnd + '=';
            break;
          }
          if (relations[indRel].componentStart == tableName) {
            theField = relations[indRel].fieldEnd;
            where = relations[indRel].fieldStart + '=';
            break;
          }
        }
        if (indRel < relations.length) {
          tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
            storeName,
            tableName
          );
          val = $scope.getValueFrom(object, theField);
          if (val == undefined)
            $scope.getRelatedFieldInformation(
              fieldName0,
              fieldName.substr(indPt + 1),
              tableDesc.relations,
              {},
              storeName,
              tableDesc
            );
          else {
            where += $scope.getValueFrom(object, theField);
            console.log(
              'getRelatedFieldInformation: cherche dans table [' +
                tableName +
                '] clause where=[' +
                where +
                ']'
            );
            QueryFactory.data(tableDesc.uid, where).then(function(res) {
              console.log(
                'getRelatedFieldInformation: résultat de recherche dans table [' +
                  tableName +
                  '] clause where=[' +
                  where +
                  ']  res.data.features.length=' +
                  res.data.features.length
              );
              if (res.data.features.length == 0)
                $scope.getRelatedFieldInformation(
                  fieldName0,
                  fieldName.substr(indPt + 1),
                  tableDesc.relations,
                  {},
                  storeName,
                  tableDesc
                );
              else
                for (
                  var indFeat = 0;
                  indFeat < res.data.features.length;
                  indFeat++
                ) {
                  console.log(
                    '       data.features[indFeat].id=' +
                      res.data.features[indFeat].id
                  );
                  $scope.getRelatedFieldInformation(
                    fieldName0,
                    fieldName.substr(indPt + 1),
                    tableDesc.relations,
                    res.data.features[indFeat],
                    storeName,
                    tableDesc
                  );
                }
            });
          }
        }
      }
    };

    $scope.getGeometryField = function(fieldOrder, ind1, panel) {
      var field, typeInfo;

      field = {};
      field.field = fieldOrder[ind1];
      if (panel.objectId != undefined) field.objectId = panel.objectId;
      field.fieldDesc = {};
      field.fieldDesc.fieldTypeIsGeometry = true;
      field.fieldDesc.type = 'geometry';
      if (
        (config != undefined && config.state == 'view') ||
        panel.mode == 'readonly'
      )
        field.mode = 'readonly';
      if (panel.fieldDesc != undefined) {
        field.geomEpsg = panel.fieldDesc.srid;
        field.featureTypeName = panel.fieldDesc.name;
        field.datastoreName = panel.fieldDesc.storeName;
        typeInfo = panel.fieldDesc.typeInfo;
      } else if (panel.descField != undefined) {
        field.geomEpsg = panel.descField.srid;
        field.featureTypeName = panel.descField.name;
        field.datastoreName = panel.descField.storeName;
        typeInfo = panel.descField.typeInfo;
      }
      field.objectField = {};
      if ($scope.objectGeometry != undefined) {
        field.objectField.value = $scope.objectGeometry;
        if ($scope.objectGeometry.type.indexOf('olygon') != -1)
          field.fieldDesc.alias = 'Contour';
        else if ($scope.objectGeometry.type.indexOf('ine') != -1)
          field.fieldDesc.alias = 'Ligne';
        else field.fieldDesc.alias = 'Localisation';
      } else {
        field.objectField.value = {};
        switch (typeInfo) {
          case 'POINT':
            field.objectField.value.type = 'Point';
            field.fieldDesc.alias = 'Localisation';
            break;
          case 'LINE':
            field.objectField.value.type = 'LineString';
            field.fieldDesc.alias = 'Ligne';
            break;
          case 'POLYGON':
            field.objectField.value.type = 'Polygon';
            field.fieldDesc.alias = 'Contour';
            break;
        }
      }
      field.objectField.name = '__geom__';
      return field;
    };

    $scope.getMoreInputField = function(fieldOrder, ind1, relations, panel) {
      var field;

      field = {};
      field.field = fieldOrder[ind1];
      field.relations = relations;
      field.config = $scope.getConfigOfMoreInput(fieldOrder[ind1], config);
      if (panel.objectId != undefined) field.objectId = panel.objectId;
      return field;
    };

    $scope.buildPanelFieldListFromTableDesc = function() {
      panelFields = [];
      if (excludedFields.length == 0 || excludedFields[0] != '*') {
        var fieldCnt = fieldDesc.length;
        var ind2 = 0,
          ind1;
        if (
          panel.descField != undefined &&
          panel.descField.geographic &&
          excludedFields.indexOf('__geom__') == -1
        ) {
          panelFields[ind2] = {};
          panelFields[ind2].field = '__geom__';
          ind2++;
        }

        for (ind1 = 0; ind1 < fieldCnt; ind1++) {
          if (excludedFields.indexOf(fieldDesc[ind1].name) == -1) {
            panelFields[ind2] = {};
            panelFields[ind2++].field = fieldDesc[ind1].name;
          }
        }
        // Add relations (at the end by default)
        for (ind1 = 0; ind1 < relations.length; ind1++) {
          if (excludedFields.indexOf(relations[ind1].name) == -1) {
            panelFields[ind2] = {};
            panelFields[ind2].field = relations[ind1].name;

            for (ind4 = 0; ind4 < inlineConfigs.length; ind4++)
              if (
                inlineConfigs[ind4].featureName == relations[ind1].componentEnd
              ) {
                panelFields[ind2].inlineConfig = inlineConfigs[ind4];
                break;
              }
            if (panelFields[ind2].inlineConfig != null)
              panelFields[ind2].datastoreName =
                inlineConfigs[ind4].datastoreName;
            else if (config != undefined) {
              panelFields[ind2].datastoreName = config.datastoreName;
              panelFields[ind2].featureName = config.featureName;
            }
            ind2++;
          }
        }
      }
    };

    $scope.addAddedFields = function() {
      if (config != undefined && config.addedFields != undefined)
        for (var ind = 0; ind < config.addedFields.length; ind++) {
          var field = {};
          field.field = config.addedFields[ind];
          panelFields.push(field);
        }
    };

    $scope.builPanelFieldListFromConfiguration = function() {
      for (ind2 = 0; ind2 < panelFields.length; ind2++) {
        //-- Check if the field is a relation
        for (ind1 = 0; ind1 < relations.length; ind1++) {
          if (panelFields[ind2].relation == null)
            if (panelFields[ind2].field == relations[ind1].name)
              //-- The field is a relation so store the relation description on it
              panelFields[ind2].relation = relations[ind1];

          //-- When the field is a relation look for a possible specific configuration (inline configuration).
          if (panelFields[ind2].relation != null)
            if (
              panelFields[ind2].relation.componentEnd ==
              relations[ind1].componentEnd
            ) {
              for (ind4 = 0; ind4 < inlineConfigs.length; ind4++)
                if (
                  inlineConfigs[ind4].featureName ==
                  relations[ind1].componentEnd
                ) {
                  panelFields[ind2].inlineConfig = inlineConfigs[ind4];
                  break;
                }
            }
        }
        if (panelFields[ind2].trim == undefined) {
          if (panelFields[ind2].inlineConfig != null)
            panelFields[ind2].datastoreName = inlineConfigs[ind4].datastoreName;
          else if (
            panelFields[ind2].trim == undefined &&
            panelFields[ind2].datastoreName == null &&
            config != null
          )
            panelFields[ind2].datastoreName = config.datastoreName;

          if (config != null && config.featureName != undefined)
            panelFields[ind2].featureName = config.featureName;
          else if (panel.fieldDesc != undefined) {
            panelFields[ind2].featureName = panel.fieldDesc.name;
            panelFields[ind2].datastoreName = panel.fieldDesc.storeName;
          }
        }
      }
    };

    $scope.manageReportOrRelationThrough = function(
      fieldOrder,
      ind1,
      fieldList,
      ind0,
      relations,
      objectFields,
      config,
      panelFields
    ) {
      var dsName;

      if (config != undefined) dsName = config.datastoreName;
      if (dsName == undefined && panel.descField != undefined)
        dsName = panel.descField.storeName;
      if (dsName == undefined && panel.fieldDesc != undefined)
        dsName = panel.fieldDesc.storeName;
      $scope.dsName = dsName;
      //-- The field is not a modelized relation, is it an access to an attribute through relations ?
      if (fieldOrder[ind1].indexOf('.') != -1) {
        //-- In such a case, get the field description and value
        var tableDesc = $scope.getRelatedDesc(fieldOrder[ind1], dsName);
        fieldList[ind0].fieldDesc = $scope.getRelatedDescForFieldList(
          tableDesc,
          fieldOrder[ind1]
        );
        if (fieldList[ind0].fieldDesc == null)
          fieldList[ind0] = $scope.getRelatedDescForRelation(
            tableDesc,
            fieldOrder[ind1],
            fieldList[ind0],
            objectFields
          );
        if ($scope.objectFields[fieldOrder[ind1]] === undefined)
          $scope.objectFields[fieldOrder[ind1]] = null;
        $scope.getRelatedFieldInformation(
          fieldOrder[ind1],
          fieldOrder[ind1],
          relations,
          objectFields,
          dsName,
          null
        );
      } else if (fieldOrder[ind1] == '__==report==__') {
        fieldList[ind0].fieldDesc = {};
        fieldList[ind0].fieldDesc.alias = panelFields[ind2].report.alias;
        fieldList[ind0].report = panelFields[ind2].report.reportName;
        fieldList[ind0].fieldDesc.fieldTypeIsReport = true;
      }
    };

    $scope.checkReportFieldsForContainer = function(config) {
      var found = false;
      if (config != undefined && config.reportFields != undefined) {
        for (var indF = 0; indF < $scope.fieldList.length; indF++) {
          for (var indRf = 0; indRf < config.reportFields.length; indRf++) {
            if (
              $scope.fieldList[indF].fieldDesc.name ==
              config.reportFields[indRf].field
            ) {
              $scope.fieldList[indF].config = config.reportFields[indRf].config;
              found = true;
              break;
            }
          }
          if (!found) {
            if ($scope.fieldList[indF].config == undefined)
              $scope.fieldList[indF].config = {};
            $scope.fieldList[indF].config.reportFields = config.reportFields;
          }
        }
      }
    };

    if (fieldDesc != undefined) {
      relations = fieldDesc.relations;
      fieldDesc = fieldDesc.attributes;
    } else {
      fieldDesc = [];
      relations = [];
    }
    if (relations == null) relations = [];
    $scope.relations = relations;
    if (specialFields == null) specialFields = [];
    if (inlineConfigs == null) inlineConfigs = [];
    if (relMainFields == null) relMainFields = [];
    if (relationsCfg == null) relationsCfg = [];
    if (excludedFields == null) excludedFields = [];
    if (objectFields == null) objectFields = {};
    else $scope.prepareObjectFields();

    if (panelFields == null) {
      // No panel field list defined so we use all the fields of the table description.
      $scope.buildPanelFieldListFromTableDesc();
    } else $scope.builPanelFieldListFromConfiguration();
    $scope.addAddedFields();

    // No field ordering defined so we build it from panel field list.
    if (fieldOrder == null) {
      fieldOrder = [];
      for (ind2 = 0; ind2 < panelFields.length; ind2++)
        if (panelFields[ind2].field == undefined)
          fieldOrder[ind2] = panelFields[ind2];
        else fieldOrder[ind2] = panelFields[ind2].field;
    }
    $scope.fieldOrder = fieldOrder;

    for (ind1 = 0; ind1 < fieldOrder.length; ind1++) {
      if (
        fieldOrder[ind1].substr != undefined &&
        fieldOrder[ind1].substr(0, 14) == '__moreInputs__'
      ) {
        fieldList[ind0] = $scope.getMoreInputField(
          fieldOrder,
          ind1,
          relations,
          panel
        );
        if (specialFields != null && specialFields[fieldOrder[ind1]] != null)
          $scope.manageSpecialField(ind0, ind1);
        ind0++;
      } else if (
        fieldOrder[ind1].substr != undefined &&
        fieldOrder[ind1] == '__geom__'
      ) {
        fieldList[ind0] = $scope.getGeometryField(fieldOrder, ind1, panel);
        ind0++;
      } else {
        for (ind2 = 0; ind2 < panelFields.length; ind2++) {
          //                       if (panelFields[ind1].field!=null && panelFields[ind1].field==fieldOrder[ind1])
          // Simple field
          if (panelFields[ind2].field == fieldOrder[ind1]) {
            var relFieldName;
            relFieldName = undefined;
            fieldList[ind0] = panelFields[ind2];
            fieldList[ind0].id = $scope.$id + '_' + ind0;
            //-- DDns le cas où on veut passer la description des fields action à un champ qui est dans un step et donc accéder par l'intermédiaire de relation on stock ici la configuration.'
            if (fieldList[ind0].config == undefined)
              fieldList[ind0].config = {};
            if (config != undefined)
              fieldList[ind0].config.fieldActions = config.fieldActions;
            for (
              indFD = 0;
              fieldDesc != undefined && indFD < fieldDesc.length;
              indFD++
            ) {
              if (fieldDesc[indFD].name == fieldOrder[ind1]) {
                fieldList[ind0].fieldDesc = fieldDesc[indFD];
                break;
              }
            }
            if (fieldDesc == undefined || indFD == fieldDesc.length) {
              // No description provided for the field: is it a relation ?
              for (indFD = 0; indFD < relations.length; indFD++) {
                if (relations[indFD].name == fieldOrder[ind1]) {
                  fieldList[ind0].relation = relations[indFD];
                  fieldList[ind0].fieldDesc = {};
                  fieldList[ind0].fieldDesc.fieldTypeIsRelation = true;

                  if (
                    relations[indFD].occurence != '1-1' &&
                    inlineInput == null
                  )
                    fieldList[ind0].fieldDesc.inlineInput = true;
                  else fieldList[ind0].fieldDesc.inlineInput = inlineInput;

                  // Look for name of fields which values will be displayed
                  for (ind3 = 0; ind3 < relMainFields.length; ind3++)
                    if (
                      relMainFields[ind3].table == relations[indFD].componentEnd
                    ) {
                      fieldList[ind0].relatedObjectField =
                        relMainFields[ind3].fields[0];
                      fieldList[ind0].relatedObjectFields =
                        relMainFields[ind3].fields;
                      relFieldName = relations[indFD].fieldStart;
                      break;
                    }
                  if (ind3 == relMainFields.length)
                    for (ind3 = 0; ind3 < relMainFields.length; ind3++)
                      if (
                        relMainFields[ind3].table ==
                        relations[indFD].componentStart
                      ) {
                        fieldList[ind0].relatedObjectField =
                          relMainFields[ind3].fields[0];
                        fieldList[ind0].relatedObjectFields =
                          relMainFields[ind3].fields;
                        relFieldName = relations[indFD].fieldEnd;
                        break;
                      }

                  // Store relation start field value in order to be able
                  // to get objects already in relation with this one.
                  if (fieldList[ind0].objectId == null) {
                    if (relations[indFD].fieldStart == 'id')
                      //                                                          fieldList[ind0].objectId = QueryFactory.getFeatureId( objectFields );
                      fieldList[ind0].objectId = $scope.objectId;
                    else
                      fieldList[ind0].objectId =
                        objectFields[relations[indFD].fieldStart];
                  }
                  break;
                }
              }
              if (indFD == relations.length) {
                $scope.manageReportOrRelationThrough(
                  fieldOrder,
                  ind1,
                  fieldList,
                  ind0,
                  relations,
                  objectFields,
                  config,
                  panelFields
                );
              }
            }

            //-- If we have a special configuration for this field, take it into account
            if (
              specialFields != null &&
              specialFields[fieldOrder[ind1]] != null
            ) {
              $scope.manageSpecialField(ind0, ind1);
            }
            if (
              fieldActions != undefined &&
              fieldActions[fieldOrder[ind1]] != null
            )
              fieldList[ind0].fieldDesc.fieldActions =
                fieldActions[fieldOrder[ind1]];

            //-- Set initial field value
            if (relFieldName != undefined) {
              fieldValue = objectFields[relFieldName];
              //-- In case of a relation field get id field nillable value.
              for (var indField = 0; indField < fieldDesc.length; indField++)
                if (fieldDesc[indField].name == relFieldName) {
                  fieldList[ind0].fieldDesc.isNillable =
                    fieldDesc[indField].isNillable;
                  break;
                }
            } else if (objectFields[fieldOrder[ind1]] == null) {
              if (
                $scope.theStep != undefined &&
                $scope.theStep.parentObjectFields != undefined &&
                $scope.theStep.parentObjectFields[fieldOrder[ind1]] != undefined
              )
                fieldValue =
                  $scope.theStep.parentObjectFields[fieldOrder[ind1]];
              else fieldValue = '';
              if (fieldValue == undefined || fieldValue == '')
                fieldValue = $scope.getInheritedValue(fieldOrder[ind1]);
            } else {
              if (fieldList[ind0].fieldDesc == undefined) var abc = true;
              if (
                fieldList[ind0].fieldDesc != undefined &&
                fieldList[ind0].fieldDesc.type != undefined &&
                fieldList[ind0].fieldDesc.type.indexOf('.Date') != -1
              ) {
                objectFields[fieldOrder[ind1]] = fieldValue = $scope.setDate(
                  objectFields[fieldOrder[ind1]]
                );
              } else {
                fieldValue = objectFields[fieldOrder[ind1]];
              }
            }

            if (fieldList[ind0] !== undefined)
              fieldList[ind0].objectField = {
                name: fieldOrder[ind1],
                value: fieldValue,
                strValue: '' + fieldValue,
              };
            ind0++;
            break;
          }
        }
      }
      if (
        (config != undefined && config.state == 'view') ||
        panel.mode == 'readonly'
      )
        if (fieldList[ind0 - 1] !== undefined)
          fieldList[ind0 - 1].mode = 'readonly';
    }

    ind0 = 0;
    for (ind1 = 0; ind1 < panelFields.length; ind1++) {
      if (
        panelFields[ind1] != undefined &&
        panelFields[ind1].trim == undefined
      ) {
        panelFields[ind1].panelUse = $scope.panelUse;
        if (panelFields[ind1].group != null) {
          fieldGroups[ind0] = panelFields[ind1];
          if (
            panelFields[ind1].inlineConfig != undefined &&
            panelFields[ind1].inlineConfig.state == 'view'
          )
            fieldGroups[ind0].mode = 'readonly';
          fieldGroups[ind0].fieldDesc = fieldDesc;
          fieldGroups[ind0].fieldOrder = panelFields[ind1].group.fieldOrder;
          fieldGroups[ind0].title = panelFields[ind1].group.title;
          fieldGroups[ind0].panelFields = panelFields[ind1].group.panelFields;
          fieldGroups[ind0++].objectFields = objectFields;
        } else if (panelFields[ind1].stepsConfig != undefined) {
          $scope.prepareStepContainer(ind1);
        }
      }
    }

    $scope.checkReportFieldsForContainer(config);

    $scope.setObjectField = function(field) {
      var valueSettingDone = false;
      //-- In case of a more input field, objectField property does not exist.
      if (field.objectField != undefined) {
        fn = field.objectField.name;
        if (objectFields.hasOwnProperty(fn)) {
          objectFields[fn] = field.objectField.value;
          if (
            field.relation != undefined &&
            objectFields.hasOwnProperty(field.relation.name)
          )
            objectFields[field.relation.name] = field.objectField.value;
          valueSettingDone = true;
        } else if (
          $scope.theStep != undefined &&
          $scope.theStep.parentObjectFields != undefined &&
          $scope.theStep.parentObjectFields.hasOwnProperty(fn)
        ) {
          $scope.theStep.parentObjectFields[fn] = field.objectField.value;
          valueSettingDone = true;
        } else if (field.relation !== undefined && field.relation.name == fn) {
          if (field.relation.componentEnd == field.featureName) {
            if (objectFields[field.relation.fieldEnd] != undefined) {
              objectFields[field.relation.fieldEnd] = field.objectField.value;
              valueSettingDone = true;
            } else if (objectFields[field.relation.fieldStart] != undefined) {
              objectFields[field.relation.fieldStart] = field.objectField.value;
              valueSettingDone = true;
            }
          }
        }
        if (!valueSettingDone) objectFields[fn] = field.objectField.value;
        if (field.requiredValueIsNull)
          $scope.existsRequiredValueWithNull = true;
      }
    };

    // When a value has been changed we get all values from lower components
    $scope.valueChangedFunction = true;
    $scope.valueChanged = function(params) {
      $scope.existsRequiredValueWithNull = false;
      if (params !== undefined && params.modifiedField !== undefined) {
        for (ind0 = 0; ind0 < $scope.fieldList.length; ind0++)
          if ($scope.fieldList[ind0].field == params.modifiedField) {
            $scope.setObjectField($scope.fieldList[ind0]);
            break;
          }
      } else
        for (ind0 = 0; ind0 < $scope.fieldList.length; ind0++)
          $scope.setObjectField($scope.fieldList[ind0]);

      for (ind0 = 0; ind0 < fieldGroups.length; ind0++) {
        for (
          ind1 = 0;
          ind1 < $scope.fieldGroups[ind0].fieldOrder.length;
          ind1++
        ) {
          fn = $scope.fieldGroups[ind0].fieldOrder[ind1];
          objectFields[fn] = $scope.fieldGroups[ind0].objectFields[fn];
          if ($scope.fieldGroups[ind0].objectFields[fn].requiredValueIsNull)
            $scope.fieldGroups[ind0].objectFields[fn] = true;
        }
      }
      if (
        $scope.$parent != undefined &&
        $scope.$parent.valueChangedFunction === true
      ) {
        if ($scope.$parent.infoFromChildren != undefined)
          $scope.$parent.infoFromChildren.existsRequiredValueWithNull =
            $scope.existsRequiredValueWithNull;
        if (params == undefined) params = { scopeId: $scope.$id };
        else params.scopeId = $scope.$id;
        if ($scope.theStep != undefined) params.theStep = $scope.theStep;
        $scope.$parent.valueChanged(params);
      }
    };

    $scope.$on('dependencyParentChangedTriggered', function(event, data) {
      $scope.$broadcast('dependencyParentChangedDispatched', data);
    });

    $scope.$on('logicalDependencyParentChangedTriggered', function(
      event,
      data
    ) {
      $scope.$broadcast('logicalDependencyParentChangedDispatched', data);
    });

    $scope.$on('fieldValueModifiedOnMainWidget', function(event, data) {
      for (var ind0 = 0; ind0 < $scope.fieldList.length; ind0++)
        if ($scope.fieldList[ind0].field == data.fieldName) {
          $scope.fieldList[ind0].objectField.value = data.fieldValue;
          $scope.setObjectField($scope.fieldList[ind0]);
          break;
        }
    });

    $scope.$on('maybeChildCreatedAfterInsertingMainObject', function(
      event,
      data
    ) {
      var objectFields = $scope.$parent.objectFields;
      if (objectFields == undefined) {
        var panel = $scope.getPanel();
        if (panel != null) objectFields = panel.objectFields;
      }
      if (objectFields != undefined) {
        var fo = $scope.fieldOrder;
        for (var ind1 = 0; ind1 < fo.length; ind1++)
          $scope.getRelatedFieldInformation(
            fo[ind1],
            fo[ind1],
            $scope.relations,
            objectFields,
            $scope.dsName,
            null
          );
      }
    });

    /****************************************************************
     *
     */

    $scope.storeHiddenFieldBuildWhere = function(where) {
      var whereRes, reg;

      //-- Query key word CURRENT_YEAR replaced by current full year value such as 2015.
      reg = new RegExp('!CURRENT_YEAR!', 'g');
      whereRes = where.replace(reg, '' + gaJsUtils.getCurrentYear());

      //-- Query key word result is replaced by previous query result value.
      reg = new RegExp('!result!', 'g');
      whereRes = whereRes.replace(reg, $scope.queryResult);

      return whereRes;
    };

    $scope.storeHiddenFieldFromQueries = function() {
      var query, indFeatureType, where;

      if (
        $scope.indHiddenFieldQuery >= $scope.currentHiddenField.queries.length
      ) {
        objectFields[$scope.currentHiddenField.field] = $scope.queryResult;
        $scope.storeHiddenFields();
      } else {
        query = $scope.currentHiddenField.queries[$scope.indHiddenFieldQuery];
        for (
          indFeatureType = 0;
          indFeatureType < FeatureTypeFactory.resources.featuretypes.length;
          indFeatureType++
        )
          if (
            FeatureTypeFactory.resources.featuretypes[indFeatureType].name ==
            query.layerName
          )
            break;
        if (indFeatureType < FeatureTypeFactory.resources.featuretypes.length) {
          where = $scope.storeHiddenFieldBuildWhere(query.where);
          QueryFactory.data(
            FeatureTypeFactory.resources.featuretypes[indFeatureType].uid,
            where
          ).then(function(res) {
            if (res.data.features.length != 0) {
              if (query.result == 'id')
                $scope.queryResult = QueryFactory.getFeatureId(
                  res.data.features[0]
                );
              else
                $scope.queryResult =
                  res.data.features[0].properties[query.result];
              $scope.indHiddenFieldQuery++;
              $scope.storeHiddenFieldFromQueries();
            }
          });
        }
      }
    };

    $scope.storeHiddenField = function() {
      if ($scope.currentHiddenField.value_type == 'constant') {
        objectFields[$scope.currentHiddenField.field] =
          $scope.currentHiddenField.value;
        $scope.storeHiddenFields();
      } else if ($scope.currentHiddenField.value_type == 'query') {
        $scope.indHiddenFieldQuery = 0;
        if (
          FeatureTypeFactory.resources.featuretypes == undefined ||
          FeatureTypeFactory.resources.featuretypes.length == 0
        )
          FeatureTypeFactory.get().then(function() {
            $scope.storeHiddenFieldFromQueries();
          });
        else $scope.storeHiddenFieldFromQueries();
      } else {
        if (objectFields[$scope.currentHiddenField.field] == null) {
          var ret = GlobalServices.getValueForKeyWord(
            $scope.currentHiddenField.value
          );
          objectFields[$scope.currentHiddenField.field] = ret.newValue;
        }
      }
    };

    $scope.storeHiddenFields = function() {
      var ind1, ind2;

      //-- Ensure hidden fields are not in the list of panel fields
      for (ind1 = 0; ind1 < $scope.fieldList.length; ind1++) {
        for (ind2 = 0; ind2 < hiddenFields.length; ind2++) {
          if ($scope.fieldList[ind1].field == hiddenFields[ind2].field)
            //-- This is an hidden field so remove it from the panel.
            $scope.fieldList.splice(ind1, 1);
        }
      }

      $scope.indHiddenField++;
      if ($scope.indHiddenField < hiddenFields.length) {
        $scope.currentHiddenField = hiddenFields[$scope.indHiddenField];
        $scope.storeHiddenField();
      }
    };

    if (config != undefined && config.hiddenFields != undefined)
      $scope.hiddenFields = hiddenFields = config.hiddenFields;
    else if (panel != undefined && panel.hiddenFields != undefined)
      $scope.hiddenFields = hiddenFields = panel.hiddenFields;
    if (hiddenFields != undefined) {
      $scope.indHiddenField = -1;
      $scope.storeHiddenFields();
    } else $scope.hiddenFields = hiddenFields = [];
    /**
     *
     ***************************************************************/
  };

  FormFieldPanelCtrl.$inject = [
    '$scope',
    'QueryFactory',
    'FeatureTypeFactory',
    'UnitsFactory',
    'GlobalServices',
    'gaJsUtils',
  ];
  return FormFieldPanelCtrl;
});
