'use strict';
define(function() {
  var RelationFormFieldl2Factory = function(
    $http,
    FeatureTypeFactory,
    QueryFactory
  ) {
    var RelationFormFieldl2Factory = {};
    /**
     * Class : RelationFormFieldl2Factory
     * Factory WebServices
     */

    var resources = {
      objects: [],
    };

    /**
     * Function: get
     */
    function getRelatedObjects(tableUid, whereClause) {

      var promise = (promise = QueryFactory.data(
        tableUid,
        whereClause,
        undefined,
        undefined,
        undefined,
        undefined
      ));
      promise.then(function(res) {
        resources.objects = res.data;
      });
      return promise;
    }

    /**
     * Function: add related object
     */
    function addRelatedObject(fid, senddata, featureType) {
      var features;

      //-- Build GeoJSON object describing the object we want  to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].type = 'feature';
      features.features[0].properties = senddata;
      features.features[0].geometry = {};

      //-- Do the insert
      var promise = $http.post(
        '/services/{portalid}/edit/' + fid + '/add?f=json',
        features
      );
      promise.then(function(res) {
        var indPt;
        //- If the service returns OK (which does not mean the creation is OK)
        if (res.status == 200) {
          var created = res.data.create[0];
          if (created != undefined && created.id != undefined) {
            indPt = created.indexOf('.');
            resources.objectId = created.id.substr(indPt + 1);
          }
        }
      });
      return promise;
    }

    /**
     * Function: delete
     */
    function delRelatedObject(fid, ids) {
      var promise = $http.get(
        '/services/{portalid}/edit/' +
          fid +
          '/delete?f=json&fid=' +
          fid +
          '&ids=' +
          ids
      );
      return promise;
    }

    /**
     * Function: update
     */
    function updateObjects(fid, features) {
      var senddata, ind1;

      //-- Build GeoJSON object describing the object we want  to insert
      senddata = {};
      senddata.type = 'FeatureCollection';
      senddata.features = [];

      for (ind1 = 0; ind1 < features.length; ind1++) {
        senddata.features[ind1] = {};
        senddata.features[ind1].id = features[ind1].id;
        senddata.features[ind1].type = 'feature';
        senddata.features[ind1].properties = features[ind1].properties;
        senddata.features[ind1].geometry = {};
      }

      var promise = $http.post(
        '/services/{portalid}/edit/' + fid + '/update?f=json',
        senddata
      );
      return promise;
    }

    return {
      updateObjects: updateObjects,
      delRelatedObject: delRelatedObject,
      addRelatedObject: addRelatedObject,
      RelationFormFieldl2Factory: RelationFormFieldl2Factory,
      resources: resources,
      getRelatedObjects: getRelatedObjects,
    };
  };
  RelationFormFieldl2Factory.$inject = [
    '$http',
    'FeatureTypeFactory',
    'QueryFactory',
  ];
  return RelationFormFieldl2Factory;
});
