'use strict';
define(function() {
  var submitLoad = function($q) {
    return {
      scope: {
        submitLoad: '&',
      },
      link: function(scope, form, iAttrs) {
        form.bind('submit', function() {
          var submitButton = angular.element(form[0].querySelector('.submit'));

          form.addClass('processing');
          submitButton.prop('disabled', true);

          const submitPromise = scope.submitLoad();
          if (!submitPromise) {
            form.removeClass('processing');
            submitButton.prop('disabled', false);
          }
          else {
            submitPromise.then(
              function() {
                form.removeClass('processing');
                submitButton.prop('disabled', false);
              },
              function() {
                form.removeClass('processing');
                submitButton.prop('disabled', false);
              }
            );
          }
        });
      },
    };
  };

  submitLoad.$inject = ['$q'];
  return submitLoad;
});
