'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    $translate,
    EditTypesFactory,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.getInitialIntersectingLine.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope) {
        //scope.result = {};
        scope.rule.name = 'GetInitialFeaturesIntersectingLine';
        scope.rule.type = 'OnStart';

        var editTypesSource = [EditTypesFactory.editTypes.update];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        var shareObjectDescAmont = '';
        var shareObjectDescAval = '';
        $translate(
          'rulecfg.getInitialintersectingline.shareObjectDescAmont'
        ).then(function(res) {
          shareObjectDescAmont = res;
        });
        $translate(
          'rulecfg.getInitialintersectingline.shareObjectDescAval'
        ).then(function(res) {
          shareObjectDescAval = res;
        });

        //Si phase de creation
        if (scope.rule.parameters == undefined) {
          scope.rule.parameters = {};
        }

        //Objets partagés destinés au partage avec les autres config de règles
        if (scope.rule.parameters.sharedObjects == undefined) {
          scope.rule.parameters.sharedObjects = {};
        }
        if (scope.rule.parameters.amont == undefined) {
          scope.rule.parameters.amont = {};
          scope.rule.parameters.amont.shareObjects = [];
        }
        if (scope.rule.parameters.aval == undefined) {
          scope.rule.parameters.aval = {};
          scope.rule.parameters.aval.shareObjects = [];
        }

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function() {
            scope.featureTypes = angular.copy(
              FeatureTypeFactory.resources.featuretypes
            );
          });
        } else {
          scope.featureTypes = angular.copy(
            FeatureTypeFactory.resources.featuretypes
          );
        }

        scope.onLayerChange = function(f) {
          scope.selectedlayer = f;
        };

        function isLayerNamePresent(shareObjects, layerName) {
          var isPresent = false;
          for (var i = 0; i < shareObjects.length; i++) {
            if (shareObjects[i].layerName == layerName) {
              isPresent = true;
            }
          }
          return isPresent;
        }

        /**
         * Méthode appelée à chaque changement de nom de l'objet partagé, par l'utilisateur.
         * Permet d'enregistrer l'objet partagé dans un tableau utilisable par d'autres configuration de règles qui récupérent les objets partagés existants.
         * @param {type} shareObject
         * @returns {undefined}
         */
        scope.updateSharedObjects = function(shareObject) {
          //Affectation d'un hashKey à shareObject à sa creation seulement. C'est ce premier hashKey qui sera ensuite utilisé tout le cycle de vie de ce shareObject.
          //Si on remarque des problemes d'unicité, on pourra utiliser Math.random() à la place.
          if (shareObject.hashKey == undefined) {
            shareObject.hashKey = shareObject.$$hashKey;
          }
          scope.rule.parameters.sharedObjects[
            shareObject.hashKey
          ] = shareObject;

          //Mise à jour du composant de visualisation de tous les objets partagés par les cfg de règles.
          //element html correspondant à la directive de visualisation des objets partagés.
          var CfgRulesInfosElem = document.querySelector(
            '#updateCfgRulesInfos'
          );
          if (CfgRulesInfosElem) {
            CfgRulesInfosElem.dispatchEvent(new Event('updateCfgRulesInfos'));
          }
        };

        /**
         * Appelée lors de l'ajout d'un objet intersecté
         * @param {type} position
         * @returns {undefined}
         */
        scope.addUpShareObject = function(position) {
          if (scope.selectedlayer == null) return;
          var sourceArray = undefined;
          var description = '';

          if (position == 'amont') {
            sourceArray = scope.rule.parameters['amont']['shareObjects'];
            description = shareObjectDescAmont;
          } else if (position == 'aval') {
            sourceArray = scope.rule.parameters['aval']['shareObjects'];
            description = shareObjectDescAval;
          } else return;

          //Ajout de l'objet uniquement si le couple (layerName, name) n'est pas encore present
          if (!isLayerNamePresent(sourceArray, scope.selectedlayer.name)) {
            sourceArray.push({
              layerName: scope.selectedlayer.name,
              desc: description
            });
          }
        };

        /**
         * Appelée lors de la suppression d'un objet intersecté
         * @param {type} position
         * @returns {undefined}
         */
        scope.removeUpShareObject = function(sourceIndex) {
          var sourceArray = scope.rule.parameters['amont']['shareObjects'];
          var deleted = sourceArray.splice(sourceIndex, 1);

          //Suppression de l'objet partagé des sharedObjects
          var shareObject = deleted[0];
          if (shareObject == undefined) return;

          //Au lieu de chercher ici le meme couple nom, nom de layer, on peut essayer d'utiliser le shareObject.hashKey
          //                    var shareObjectkey = undefined;
          //                    angular.forEach(scope.rule.parameters.sharedObjects, function(value, key) {
          //                        if (shareObjectkey == undefined){
          //                            if (value.name == shareObject.name && value.name == shareObject.name){
          //                                shareObjectkey = key;
          //                            }
          //                        }
          //                    });
          //                    if (shareObjectkey){
          //                        delete scope.rule.parameters.sharedObjects[shareObjectkey];
          //                    }

          if (shareObject.hashKey) {
            delete scope.rule.parameters.sharedObjects[shareObject.hashKey];
            //Mise à jour du composant de visualisation de tous les objets partagés par les cfg de règles.
            //element html correspondant à la directive de visualisation des objets partagés.
            var CfgRulesInfosElem = document.querySelector(
              '#updateCfgRulesInfos'
            );
            if (CfgRulesInfosElem) {
              CfgRulesInfosElem.dispatchEvent(new Event('updateCfgRulesInfos'));
            }
          }
        };

        scope.removeDownShareObject = function(sourceIndex) {
          RuleCfgFactory.removeShareObject(scope, sourceIndex, true);
        };
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    '$translate',
    'EditTypesFactory',
    'RuleCfgFactory',
  ];
  return gcelement;
});
