'use strict';

define(function() {
  /**
   * Athentification tierce (LDAP)
   * @param {*}
   * @param {*} ngDialog
   */
  const ExtraAuthenticationCtrl = function($scope, ExtraAuthenticationFactory,
    $filter) {
    // provider types
    $scope.providerTypes = [
      {
        label: 'LDAP',
      },
      {
        label: 'OIDC',
      },
    ];

    /**
     * Loading
     */
    $scope.currentResources = [];
    ExtraAuthenticationFactory.get().then(function() {
      $scope.currentResources =
        ExtraAuthenticationFactory.resources.extra_authentications;
    });

    /**
         EditList Directive configuration
         */
    $scope.editListCfg = {
      dataModule: 'rights',
      resource_type: 'extra_authentication',
      removeFunction: () => {
        ExtraAuthenticationFactory.remove($scope.edit_resource.uid);
      },
      defautValues: [
        {
          k: 'parameters',
          v: { groupClasses: 'posixGroup,groupOfNames,groupOfUniqueNames' }
        }
      ] ,
      cols: ['name', 'type'],
    };

    // Add/edit provider d' auth
    $scope.editExtraAuthentication = () => {
      if ($scope.isNewResource) {
        ExtraAuthenticationFactory.add($scope.edit_resource).then(function(
          res
        ) {
          // set uid sinon l'update direct ne va pas marcher
          $scope.edit_resource.uid = res.data.uid;
          $scope.isNewResource = false;
          require('toastr').success($filter('translate')('common.saved'));
        });
      }
      else {
        ExtraAuthenticationFactory.update($scope.edit_resource).then(
          function() {
            require('toastr').success($filter('translate')('common.saved'));
          }
        );
      }
    };

    /**
     * canTestConnexion
     * Activation du bouton de test de la connexion
     */
    $scope.canTestConnexion = function() {
      var canTest = true;
      if ($scope.edit_resource.type == 'LDAP') {
        var p = $scope.edit_resource.parameters;

        canTest =
          angular.isDefined(p) &&
          angular.isDefined(p.server_url) &&
          p.server_url &&
          (p.anonyme ||
            (angular.isDefined(p.user) &&
              p.user &&
              angular.isDefined(p.password) &&
              p.password));
      }

      return canTest;
    };
    /**
     * connectionTest
     * test de la connexion au provider d' auth
     */
    $scope.connectionTest = function() {
      ExtraAuthenticationFactory.connectiontest($scope.edit_resource).then(
        function(connected) {
          require('toastr').success(
            $filter('translate')(
              'rights.extra_authentication.connection_test_' + connected.data
            )
          );
        },
        function(err) {
          require('toastr').error(
            $filter('translate')(
              'rights.extra_authentication.connection_test_' + err.data
            )
          );
        }
      );
    };

    $scope.mappingAttributes = [];
    /**
     * getAttributes
     */
    $scope.getAttributes = function() {
      ExtraAuthenticationFactory.getattributes($scope.edit_resource).then(
        function(res) {
          $scope.mappingAttributes = res.data;
        },
        function() {
          require('toastr').error($filter('translate')('common.error'));
        }
      );
    };
  };

  ExtraAuthenticationCtrl.$inject = ['$scope', 'ExtraAuthenticationFactory',
    '$filter'
  ];
  return ExtraAuthenticationCtrl;
});
