'use strict';
if (
  !define(function() {
    const BuilderCtrl = function(
      $scope,
      ngDialog,
      ApplicationFactory,
      ConfigFactory,
      $filter,
      FeatureTypeFactory
    ) {
      $scope.builderForm = function(loadTemplate) {
        if (ApplicationFactory.resources.applications.length == 0) {
          alert($filter('translate')('tools.builder.no_application'));
          return;
        }

        $scope.formTemplate = {};
        $scope.loadTemplate = loadTemplate ? loadTemplate : {};

        $scope.formIsDirty = { v: false };

        $scope.isClosed = false;
        ngDialog.open({
          template:
            'js/XG/modules/model/views/modals/modal.featuretypes.builder.html',
          className:
            'ngdialog-theme-plain fullScreen transparent nopadding miniclose',
          closeByDocument: false,
          scope: $scope,
          preCloseCallback: function() {
            if ($scope.formIsDirty.v && !$scope.isClosed) {

              let doClose = confirm(
                $filter('translate')('tools.builder.leave_without_saving'));

              if (doClose) {
                // permet de ne proposer qu'un seul message de confirmation
                $scope.isClosed = true;
              }
              return doClose
            }
          },
        });
      };

      const refreshList = () => {
        $scope.currentResources = [];
        ConfigFactory.getFormBuilderList().then((res) => {
          if (res.data && res.data.length > 0) {
            $scope.currentResources = res.data.map((currentResourcesApplicationConfig) => ({
                application_name: currentResourcesApplicationConfig.appName,
                type: currentResourcesApplicationConfig.appType,
                name: currentResourcesApplicationConfig.configname,
            }));
          }
        });
      };

      // we need to be sure featuretype are loaded..
      FeatureTypeFactory.get().then(() => {
        refreshList();
      });
      $scope.$on('formbuilder_save', (event, args) => {
        refreshList();
      });

      $scope.removeForm = function() {
        ConfigFactory.remove(
          $scope.edit_resource.type,
          $scope.edit_resource.name,
          $scope.edit_resource.application_name
        ).then(function() {
          $scope.currentResources.forEach(function(c, index) {
            if (
              $scope.edit_resource.type == c.type &&
              $scope.edit_resource.name == c.name &&
              $scope.edit_resource.application_name == c.application_name
            ) {
              $scope.currentResources.splice(index, 1);
            }
          });
        });
      };

      $scope.editListCfg = {
        dataModule: 'tools',
        resource_type: 'builder',
        cols: ['application_name', 'type', 'name'],
        addFunction: $scope.builderForm,
        editFunction: $scope.builderForm,
        removeFunction: $scope.removeForm,
      };
    };

    BuilderCtrl.$inject = [
      '$scope',
      'ngDialog',
      'ApplicationFactory',
      'ConfigFactory',
      '$filter',
      'FeatureTypeFactory',
    ];
    return BuilderCtrl;
  })
) {
}
