'use strict';
define(function() {
  var ancCreateCommune = function(
    AncAppFactory,
    ngDialog,
    BacAppFactory,
    $rootScope,
    CommonFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/ancCreateCommune.html',
      restrict: 'EA',
      scope: {
        res: '=?',
        editable: '=?',
        required: '=?',
        labelKey: '=?',
        modal: '=',
      },
      link: function(scope) {
        let CurrentAppFactory = null;
        if ($rootScope.xgos.sector !== 'map') {
          CurrentAppFactory =
            $rootScope.xgos.sector == 'bac' ? BacAppFactory : AncAppFactory;
        } else {
          CurrentAppFactory =
            $rootScope.xgos.sub_sector == 'bac' ? BacAppFactory : AncAppFactory;
        }

        var nouvelleVilleModale;
        scope.add_ville_cp = function(cp) {
          scope.nouvelle_ville.cp.push(undefined);
        };
        scope.remove_ville_cp = function(index) {
          scope.nouvelle_ville.cp.splice(index, 1);
        };
        scope.nouvelle_ville = { cp: [] };

        /**
         * nouvelleVille
         */
        scope.nouvelleVille = function() {
          scope.nouvelle_ville.extra_ville = true;

          let data = angular.copy(CurrentAppFactory.appCfg.main);
          data = CurrentAppFactory.addNewCommuneToData(
            data,
            scope.nouvelle_ville
          );
          CommonFactory.updateConfigWithCreateCommune(
            data,
            CurrentAppFactory.appCfg.appname,
            CurrentAppFactory.appCfg.appname == AncAppFactory.appCfg.appname
          )
            .then(() => {
              CurrentAppFactory.appCfg.main = data;
              scope.$parent.$parent.setVille(scope.nouvelle_ville.value);
              scope.$parent.$parent.setPays(scope.nouvelle_ville.pays);
              if (scope.nouvelle_ville.cp.length == 1) {
                scope.$parent.$parent.setCodePostal(scope.nouvelle_ville.cp[0]);
              }
              scope.modal.close();
            })
            .catch(err => {
              const message =
                err.status == 400 ? 'La commune existe déjà' : err.data;
              require('toastr').error(message, '', {
                positionClass: 'toast-bottom-left',
              });
            });
        };
      },
    };
  };

  ancCreateCommune.$inject = [
    'AncAppFactory',
    'ngDialog',
    'BacAppFactory',
    '$rootScope',
    'CommonFactory',
  ];
  return ancCreateCommune;
});
