'use strict';
define(() => {
  var ancDerogation = () => {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_derogation.html',
      restrict: 'E',
      scope: {
        fti: '=',
        model: '=',
      },
      link: function(scope) {
        const getDifference = () => {
          return (
            Math.ceil(
              Math.abs(
                (new Date(scope.model.date_derogation) -
                  new Date(scope.model.date_debut_derogation)) /
                  (1000 * 60 * 60 * 24)
              )
            ) *
            (new Date(scope.model.date_derogation) <
            new Date(scope.model.date_debut_derogation)
              ? -1
              : 1)
          );
        };
        const changeDerogationDelay = () => {
          if (
            angular.isUndefined(scope.model) ||
            !scope.model.date_debut_derogation ||
            !scope.model.date_derogation
          )
            return;
          scope.model.delai_calcule_derogation = getDifference();
        };
        scope.$watch('model.date_debut_derogation', (oldVal, newVal) => {
          if (new Date(oldVal).getTime() == new Date(newVal).getTime()) return; // Prevent resetting delay on directive loading
          changeDerogationDelay();
        });
        scope.$watch('model.date_derogation', (oldVal, newVal) => {
          if (new Date(oldVal).getTime() == new Date(newVal).getTime()) return; // Prevent resetting delay on directive loading
          changeDerogationDelay();
        });
      },
    };
  };

  ancDerogation.$inject = [];
  return ancDerogation;
});
