'use strict';
define(function() {
  var ancParcelle = function(
    FeatureTypeFactory,
    AncAppFactory,
    BacAppFactory,
    ngDialog,
    gaDomUtils,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_parcelle.html',
      restrict: 'EA',
      scope: {
        parcelle: '=',
        afterEdit: '&?',
        commune: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        var CurrentAppFactory = !AncAppFactory.appCfg.main
          ? BacAppFactory
          : AncAppFactory;

        scope.parcelleFields =
          CurrentAppFactory.appCfg.main.parcellesCfg.fields;

        // retrieve parcelle fti
        scope.parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          CurrentAppFactory.appCfg.main.parcellesCfg.emplacement
        );

        if (
          angular.isDefined(scope.commune) &&
          angular.isUndefined(scope.parcelle.properties)
        ) {
          scope.parcelle.properties = {};
          if (
            angular.isUndefined(
              scope.parcelle.properties[scope.parcelleFields.commune] &&
                angular.isDefined(scope.commune.adresse_ville)
            ) &&
            scope.commune.adresse_ville != null
          ) {
            scope.parcelle.properties[scope.parcelleFields.commune] =
              scope.commune.adresse_ville;
          }
        }

        /*scope.parcelle.properties  = scope.commune.adresse_ville;*/

        /**
         * save parcelle
         */
        scope.saveParcelle = function() {
          var featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };

          gaDomUtils.showGlobalLoader();

          if (angular.isUndefined(scope.parcelle.id)) {
            featureCollection.features.push({
              type: 'Feature',
              properties: scope.parcelle.properties,
            });
            AncAppFactory.addparcelle(
              featureCollection,
              CurrentAppFactory.appCfg.appname
            ).then(
              res => {
                scope.parcelle.id = res.data[0].id;
                gaDomUtils.hideGlobalLoader();
                scope.afterEdit({ id: res.data[0].id });
                require('toastr').success('Parcelle enregistrée');
              },
              () => {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error("Une erreur s'est produite");
              }
            );
          } else {
            featureCollection.features.push(scope.parcelle);
            AncAppFactory.updateparcelle(featureCollection).then(
              res => {
                scope.parcelle.id = res.data[0].id;
                gaDomUtils.hideGlobalLoader();
                scope.afterEdit({ id: scope.parcelle.id });
                require('toastr').success('Parcelle mise à jour');
              },
              () => {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error("Une erreur s'est produite");
              }
            );
          }
        };
      },
    };
  };

  ancParcelle.$inject = [
    'FeatureTypeFactory',
    'AncAppFactory',
    'BacAppFactory',
    'ngDialog',
    'gaDomUtils',
    'gaJsUtils',
  ];
  return ancParcelle;
});
