'use strict';
define(function() {
  var ancBacServiceControle = function(
    AncAppFactory,
    BacAppFactory,
    $rootScope,
    ngDialog,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_service_controle.html',
      restrict: 'EA',
      scope: {
        labelKey: '=?',
        cdata: '=?',
        entrepriseFti: '=?',
        controleClos: '=?', // controle-clos
        controleCommentConfig: '=?', // Commentaires pré saisis via l'admin
        apptype: '=?',
      },
      link: function(scope, elt, attrs, ctrl, testCtrl) {
        var idTypeEntreprise = scope.apptype == 'anc' ? '4' : '6';
        var nomTypeEntreprise = scope.apptype == 'anc' ? 'spanc' : 'spac';

        QueryFactory.data(
          scope.entrepriseFti.uid,
          'type = ' + idTypeEntreprise
        ).then(function(data) {
          var spancEntreprise = data.data.features;
          if (spancEntreprise.length == 1) {
            // ssi undefined
            if (!angular.isDefined(scope.cdata.service_controle)) {
              scope.cdata.service_controle = spancEntreprise[0].properties;
            }
          }
        });

        scope.display = {};
        scope.display.spanc = 'reduced';
        scope.expand = 0;
        scope.toggleDisplaySpanc = function() {
          scope.expand = scope.expand == 0 ? 1 : 0;
          $rootScope.$emit('toggleDisplaySpanc', scope.display.spanc);
        };
        /**
         * prePickSpanc
         */
        scope.prePickSpanc = function() {
          angular
            .element(document.querySelector('.mainFormTitle'))
            .scope()
            .prePickInstallateur(nomTypeEntreprise);
        };

        /**
         * addSpanc
         */
        scope.addSpanc = function() {
          angular
            .element(document.querySelector('.mainFormTitle'))
            .scope()
            .ouvrirEntrepriseDialog(idTypeEntreprise);
        };

        /**
         * unlinkSpanc
         */
        scope.unlinkSpanc = function() {
          angular
            .element(document.querySelector('.mainFormTitle'))
            .scope()
            .unlinkEntreprise(nomTypeEntreprise);
        };
      },
    };
  };

  ancBacServiceControle.$inject = [
    'AncAppFactory',
    'BacAppFactory',
    '$rootScope',
    'ngDialog',
    'QueryFactory',
  ];
  return ancBacServiceControle;
});
