'use strict';
define(function() {
  var gcMainController = function(
    $scope,
    $location,
    ConfigFactory,
    ngDialog,
    $filter,
    panelsManager,
    FeatureTypeFactory,
    gcformfunction,
    $timeout,
    $sce
  ) {
    // ---------------------------
    // Loading the form app
    // ---------------------------
    $scope.appReady = false;

    $scope.formAppCfg = {
      appname: $location.search().app,
      userIsAllowedToCfg: $location.search().mode == 'config' ? true : false,
      configSet: false,
      config: {
        menu: {
          items: [],
        },
        menuBodyRatio: 2,
      },
    };

    // change body ratio
    $scope.$watch(
      'formAppCfg.config.menuBodyRatio',
      function(v) {
        $scope.menuBodyRatio = { menu: v, body: 12 - v };
      },
      1
    );

    // change landingText
    $scope.$watch(
      'formAppCfg.config.landingText',
      function(v) {
        $scope.landingText = $sce.trustAsHtml(v);
      },
      1
    );

    ConfigFactory.get('main', 'mainconfig').then((resConfigFactory) => {
      // need to be sure the list of featureType has been loaded
      FeatureTypeFactory.get().then((resFeatureTypeFactory) => {
        // on attends le chargement de la liste des fti mais on ne l'utilise pas içi
        if (resConfigFactory && resConfigFactory.data) {
          $scope.formAppCfg.configSet = true;
          $scope.formAppCfg.config = resConfigFactory.data;
        }

        $scope.appReady = true;
      });
    });

    panelsManager.init();
    $scope.panelsManager = panelsManager;

    $scope.closepanel = function() {
      $scope.panelsManager.removePanel('list_features');
    };

    // ---------------------------
    // Form app configuration
    // ---------------------------
    $scope.configTabs = [
      {
        title: 'formapp.configuration.tabs.menu.title',
        content:
          'js/XG/widgets/formapp/main/views/modals/modal.configuration.menu.html',
      },
      {
        title: 'formapp.configuration.tabs.presentation.title',
        content:
          'js/XG/widgets/formapp/main/views/modals/modal.configuration.presentation.html',
      },
    ];
    $scope.configTabs.activeTab = 0;

    $scope.possibleTypes = [
      {
        id: 'button',
        label: 'formapp.configuration.tabs.menu.types.button',
      },
      {
        id: 'list',
        label: 'formapp.configuration.tabs.menu.types.list',
      },
      {
        id: 'title',
        label: 'formapp.configuration.tabs.menu.types.title',
      },
      {
        id: 'text',
        label: 'formapp.configuration.tabs.menu.types.text',
      },
    ];

    /**
     * formAppCfgModale
     */
    var cfgModale;
    $scope.formAppCfgModale = function() {
      $scope.tmpCfg = angular.copy($scope.formAppCfg.config);
      $scope.configTabs.activeTab = 0;

      cfgModale = ngDialog.open({
        template:
          'js/XG/widgets/formapp/main/views/modals/modal.configuration.html',
        className: 'ngdialog-theme-plain nopadding miniclose width800',
        closeByDocument: false,
        scope: $scope,
      });
    };
    $scope.closeFormAppCfgModale = function() {
      cfgModale.close();
    };

    /**
     * addMenuItem
     */
    $scope.addMenuItem = function() {
      $scope.tmpCfg.menu.items.push({
        type: 'text',
      });
    };
    /**
     * removeMenuItem
     * @param index
     */
    $scope.removeMenuItem = function(index) {
      $scope.tmpCfg.menu.items.splice(index, 1);
    };

    /**
     * moveItem up and down when editListCfg.allowReorder==true
     * @param index
     * @param direction
     * @returns {boolean}
     */
    $scope.moveItem = function(index, direction) {
      if (
        (index == 0 && direction == 'up') ||
        (index == $scope.tmpCfg.menu.items.length - 1 && direction == 'down')
      )
        return false;
      var newIndex = direction == 'up' ? index - 1 : index + 1;
      $scope.tmpCfg.menu.items.splice(
        index,
        0,
        $scope.tmpCfg.menu.items.splice(newIndex, 1)[0]
      );
    };

    /**
     * Check whether the form can be submitted
     * @returns {*}
     */
    $scope.isValidCfgForm = function() {
      return true;

      var cfg = $scope.formAppCfg.config;
      return cfg.btnLabel && cfg.form && cfg.ftid;
    };

    $scope.saveFormAppCfg = function() {
      $scope.formAppCfg.config = $scope.tmpCfg;
      console.log($scope.formAppCfg.config);
      ConfigFactory.add($scope.formAppCfg.config, 'main', 'mainconfig').then(
        function(res) {
          require('toastr').success(
            $filter('translate')('formapp.config_saved')
          );
          $scope.formAppCfg.configSet = true;
          cfgModale.close();
        }
      );
    };

    /**
     * openConfigBrowser
     */
    var configBrowserModale, currentlyEditedButtonElement;
    $scope.openConfigBrowser = function(item) {
      currentlyEditedButtonElement = item;

      configBrowserModale = ngDialog.open({
        template: 'js/XG/widgets/utilities/form/views/modal/builderOpen.html',
        className: 'ngdialog-theme-plain width1000 nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };
    /**
     * openForm (select the form to link to the "new" button
     * (openForm is the function returned by config-browser directive used in in builderOpen modale)
     * */
    $scope.openForm = function(selected) {
      currentlyEditedButtonElement.form = selected;
    };

    // ---------------------------
    // New Feature Form
    // ---------------------------

    /**
     * openNewForm
     * @param item
     */
    $scope.currentForm = false;
    $scope.openNewForm = function(item) {
      ConfigFactory.get(
        item.form.type,
        item.form.name + '.form',
        item.form.application_name
      ).then(function(res) {
        $scope.newobj = {};
        $scope.ftemplatedata = res.data;
        $scope.currentForm = res.data;

        /* var newForm = ngDialog.open({
                    template:'js/XG/widgets/formapp/main/views/modals/modal.form.html',
                    className: 'ngdialog-theme-plain width1000 nopadding miniclose',
                    closeByDocument: false,
                    scope: $scope
                });*/
      });
    };
    /**
     * closeCurrentForm
     */
    $scope.closeCurrentForm = function() {
      $scope.currentForm = false;
    };

    // ---------------------------
    // Feature List
    // ---------------------------

    /**
     * showFeatureListPanel
     * @param item
     */
    var currentListCfg;
    $scope.showFeatureListPanel = function(item) {
      currentListCfg = item;

      $scope.closepanel();
      $scope.listFeature = {
        fti: FeatureTypeFactory.getFeatureByUid(currentListCfg.ftid),
        actions: [
          {
            label: 'btn',
            btnclass: 'default',
            cfg: {
              iconOrLabel: 'label',
              label: 'common.edit',
              size: 'btn-xs',
              style: 'btn-default',
              icon: {
                spinning: false,
              },
            },
            config: {
              click: ['openEditForm'],
            },
          },
        ],
      };

      $scope.listFeatureFilter = item.filter ? item.filter : '';
      console.log($scope.listFeatureFilter);

      // need to use an extra level because selectedFeature wont be updated if its an array...
      $scope.selectedFeature = { tab: [] };
      $scope.panelsManager.addPanel({
        id: 'list_features',
        stickToRight: true,
        templateUrl: 'js/XG/widgets/formapp/main/views/list_features.html',
        scope: $scope,
        stickToBorder: true,
        visible: true,
      });
    };

    /**
     *
     * @param action
     * @returns {boolean}
     */
    $scope.actionFromFeatureList = function(action) {
      if (action == 'openEditForm') {
        ConfigFactory.get(
          currentListCfg.form.type,
          currentListCfg.form.name + '.form',
          currentListCfg.form.application_name
        ).then(function(res) {
          $scope.newobj = {};
          $scope.newobj.current = angular.copy($scope.selectedFeature.tab[0]);
          $scope.currentForm = res.data;

        });


      }
      return true;
    };
  };
  gcMainController.$inject = [
    '$scope',
    '$location',
    'ConfigFactory',
    'ngDialog',
    '$filter',
    'panelsManager',
    'FeatureTypeFactory',
    'gcformfunction',
    '$timeout',
    '$sce',
  ];

  return gcMainController;
});
