'use strict';
define(function() {
  var HpoMulticritereServices = function(
    $http,
    FeatureTypeFactory,
    $filter,
    $rootScope,
    $location,
    InitProvider,
    $timeout,
    $q,
    HpoAppModelServices
  ) {
    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function saveParameter(hpoparameter, uid) {
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/parameter/save?uid=' +
          uid,
        hpoparameter
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getParameters(uid) {
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/parameter/get?uid=' +
          uid
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function deleteParameters(uid, ids) {
      var promise = $http.delete(
        '/services/{portalid}/hpo-multicritere-services/{appname}/parameter/delete?uid=' +
          uid +
          '&ids=' +
          ids
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function saveCriterea(hpoparameter, uid, checkbyuid) {
      if (angular.isUndefined(checkbyuid)) checkbyuid = false;
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/criterea/save?uid=' +
          uid +
          '&checkbyuid=' +
          checkbyuid,
        hpoparameter
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getCritereas(uid, id) {
      if (angular.isUndefined(id)) id = '';
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/criterea/get?uid=' +
          uid +
          '&id=' +
          id
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function deleteCritereas(uid, ids) {
      var promise = $http.delete(
        '/services/{portalid}/hpo-multicritere-services/{appname}/criterea/delete?uid=' +
          uid +
          '&ids=' +
          ids
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function savePonderation(hpoparameter, uid) {
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/ponderation/save?uid=' +
          uid,
        hpoparameter
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getPonderation(uid, id) {
      if (angular.isUndefined(id)) id = '';
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/ponderation/get?uid=' +
          uid +
          '&id=' +
          id
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function deletePonderation(uid, ids) {
      var promise = $http.delete(
        '/services/{portalid}/hpo-multicritere-services/{appname}/ponderation/delete?uid=' +
          uid +
          '&ids=' +
          ids
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function saveIndicateur(hpoparameter, uid) {
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/indicateur/save?uid=' +
          uid,
        hpoparameter
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getIndicateur(uid, id) {
      if (angular.isUndefined(id)) id = '';
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/indicateur/get?uid=' +
          uid +
          '&id=' +
          id
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function deleteIndicateur(uid, ids) {
      var promise = $http.delete(
        '/services/{portalid}/hpo-multicritere-services/{appname}/indicateur/delete?uid=' +
          uid +
          '&ids=' +
          ids
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function compareAnalyses(hpocompare) {
      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/compare/analysis?',
        hpocompare
      );
      promise.then(
        function(res) {
          HpoAppModelServices.checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function saveComparaison(hpoparameter, uid) {
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/compare/save?uid=' +
          uid,
        hpoparameter
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getComparaison(uid, id, hpoparameter) {
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/compare/get?uid=' +
          uid +
          '&id=' +
          id,
        hpoparameter
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getPriority(uid, id, hpoparameter) {
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/priority/get?uid=' +
          uid +
          '&id=' +
          id
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function saveScore(sendata) {
      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/score/save?',
        sendata
      );
      promise.then(
        function(res) {
          HpoAppModelServices.checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [calculPriorities description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function calculPriorities(hpocompare) {
      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/calcul/priorities?',
        hpocompare
      );
      promise.then(
        function(res) {
          HpoAppModelServices.checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [calculPriorities description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function recalculPriorities(hpocompare) {
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/recalcul/priorities?',
        hpocompare
      );
      
      return promise;
    }

    /**
     * [calculPriorities description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function saveCorrespondance(uidCorrespondance, uidChantiers, hpocompare) {
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/correspondance/save?uidCorrespondance=' +
          uidCorrespondance+
          "&uidChantiers="+
          uidChantiers,
        hpocompare
      );
      
      return promise;
    }

    /**
     * [calculPriorities description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getCorrespondance(uid, id) {
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/correspondance/get?uid=' +
          uid +
          '&id=' +
          id
      );
      
      return promise;
    }

    /**
     * [calculPriorities description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function createGenericParameters(sendata) {
      var promise = $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/parameters/create/generic',
        sendata
      );
      
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getAuto(uid, id, hpoparameter) {
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/automatisation/get?uid=' +
          uid +
          '&id=' +
          id
      );
      
      return promise;
    }

    function addAmcFilter(uid,filter,componentUid,newFilterName){
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/amcFilter/add?uid=' +
          uid +
          '&componentUid=' +
          componentUid + 
          '&filter=' +
          filter +
          '&newFilterName=' +
          newFilterName
      );
      
      return promise;
    }

    function selectAmcFilter(id,uid,componentUid){
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/amcFilter/select?id=' +
          id +
          '&uid=' +
          uid+
          '&componentUid='+
          componentUid
      );
      
      return promise;
    }

    function removeAmcFilter(id,uid){
      var promise = $http.get(
        '/services/{portalid}/hpo-multicritere-services/{appname}/amcFilter/remove?id=' +
          id +
          '&uid=' +
          uid
      );
      
      return promise;
    }

    const generateReport= (sendata) =>{
      return $http.post(
        '/services/{portalid}/hpo-multicritere-services/{appname}/generateReport',
        sendata
      );
    };

    return {
      saveParameter: saveParameter,
      getParameters: getParameters,
      deleteParameters: deleteParameters,
      saveCriterea: saveCriterea,
      getCritereas: getCritereas,
      deleteCritereas: deleteCritereas,
      savePonderation: savePonderation,
      getPonderation: getPonderation,
      deletePonderation: deletePonderation,
      saveIndicateur: saveIndicateur,
      getIndicateur: getIndicateur,
      deleteIndicateur: deleteIndicateur,
      compareAnalyses: compareAnalyses,
      saveComparaison: saveComparaison,
      getComparaison: getComparaison,
      saveScore: saveScore,
      calculPriorities: calculPriorities,
      recalculPriorities: recalculPriorities,
      getPriority: getPriority,
      saveCorrespondance: saveCorrespondance,
      getCorrespondance: getCorrespondance,
      createGenericParameters: createGenericParameters,
      getAuto: getAuto,
      addAmcFilter: addAmcFilter,
      selectAmcFilter: selectAmcFilter,
      removeAmcFilter:removeAmcFilter,
      generateReport:generateReport
    };
  };
  HpoMulticritereServices.$inject = [
    '$http',
    'FeatureTypeFactory',
    '$filter',
    '$rootScope',
    '$location',
    'InitProvider',
    '$timeout',
    '$q',
    'HpoAppModelServices',
  ];
  return HpoMulticritereServices;
});
