'use strict';
define(function() {
  var createUpdateAttribute = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    UnitFactory,
    CalculFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/create_update_attribute.html',
      restrict: 'EA',
      scope: {
        correction: '=?',
        fixedTitle: '=?',
        fixedTypes: '=?',
        fixedNumber: '=?',
        addonlyOne: '=?',
        addOneFunc: '=?',
        noTitle: '=?',
        toVerifyAttributes: '=?',
        currentFeatureTypeAttribute: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.specialAttributesHPO = HpoCarteAppFactory.getAppFactory().getHpoSpecialAttributes();
        scope.isAuthorisedToAddAttribute = HpoCarteAppFactory.getAppFactory().isAuthorisedToAddAttribute;

        scope.validName = function(name) {
          if (scope.toVerifyAttributes && scope.toVerifyAttributes.length > 0) {
            if (
              name &&
              scope.toVerifyAttributes &&
              scope.toVerifyAttributes.length > 0
            ) {
              var idx = scope.toVerifyAttributes.indexOf(name);
              if (~idx) return false;
            }
          }
          return /^[A-Za-z0-9-_]+$/.test(name);
        };

        scope.attributeTypes = scope.fixedTypes || [
          {
            id: 'java.lang.Double',
            label: 'java.lang.Double',
          },
          {
            id: 'java.util.Date',
            label: 'java.util.Date',
          },
          {
            id: 'java.lang.String',
            label: 'java.lang.String',
          },
          {
            id: 'java.lang.Boolean',
            label: 'java.lang.Boolean',
          },
          {
            id: 'java.lang.Integer',
            label: 'java.lang.Integer',
          },
          {
            id: 'java.sql.Timestamp',
            label: 'java.sql.Timestamp',
          },
          {
            id: 'g2c.attachment',
            label: 'g2c.attachment',
          },
          {
            id: 'g2c.attachments',
            label: 'g2c.attachments',
          },
          {
            id: 'g2c.hyperlink',
            label: 'g2c.hyperlink',
          }
        ];

        UnitFactory.get().then(function() {
          scope.units = UnitFactory.resources.units;
        });

        scope.setAvailableMultiples = function() {
          if (!scope.currentFeatureTypeAttribute.unit) return;
          scope.availableMultiples = [];

          if (scope.currentFeatureTypeAttribute.unit.type == null) {
            scope.currentFeatureTypeAttribute.unit = '';
            return;
          }

          scope.units.forEach(function(unit) {
            if (unit.unit == scope.currentFeatureTypeAttribute.unit.type) {
              //scope.availableMultiples = unit.multiple;
              scope.availableMultiples = unit.multiple.map(function(x) {
                x.factor = parseFloat(x.factor);
                return x;
              });
            }
          });
        };

        /**
         * Load Automatic calculs
         */
        CalculFactory.get().then(function() {
          scope.calculs = [];

          for (var i = 0; i < CalculFactory.resources.calculs.length; i++) {
            var loopCalcul = CalculFactory.resources.calculs[i];

            var calcItem = {
              code: loopCalcul.code,
              alias: loopCalcul.alias,
            };

            scope.calculs.push(calcItem);
          }

          var noCalcul = {
            code: 'none',
            alias: 'Aucun',
          };

          scope.calculs.push(noCalcul);

          scope.currentCalcul = {
            selected: 'none',
          };
        });

        /**
         * @ngdoc method
         * @name scope.setAttributeCalcul
         * @methodOf modules.model.controller:FeatureTypeCtrl
         * @description
         * setAttributeCalcul
         */
        scope.setAttributeCalcul = function() {
          var selectedCalcul = getCalculFromCode(scope.currentCalcul.selected);

          scope.currentFeatureTypeAttribute.autoCalcul = selectedCalcul;
        };

        /**
         * @ngdoc method
         * @name getCalculFromCode
         * @methodOf modules.model.controller:FeatureTypeCtrl
         * @description
         * getCalculFromCode
         */
        var getCalculFromCode = function(calcCode) {
          for (var i = 0; i < CalculFactory.resources.calculs.length; i++) {
            var loopCalcul = CalculFactory.resources.calculs[i];

            if (loopCalcul.code == calcCode) {
              return loopCalcul;
            }
          }

          return null;
        };

        var ngDialogPromise;
        scope.addAttribute = function(idx, newattribute) {
          if (newattribute) {
            scope.currentFeatureTypeAttribute = {
              size: 500,
            };
          } else {
            scope.currentFeatureTypeAttribute =
              scope.correction.attributestoadd[idx];
            scope.idx = idx;
          }
          getExistingNames();
          scope.newattribute = newattribute;
          ngDialogPromise = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/utilities/attribute_general.html',
            scope: scope,
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
          });
          ngDialogPromise.then(
            function(data) {
              console.log(data);
              if (scope.newattribute) {
                scope.correction.attributestoadd.push(data);
              } else {
                scope.correction.attributestoadd[scope.idx] = data;
              }
            },
            function(data) {
              require('toastr').info(
                $filter('translate')('elastic.search.annuler')
              );
            }
          );
        };

        scope.removeAttribute = function(idx) {
          scope.correction.attributestoadd.splice(idx, 1);
        };

        scope.validateAttributeName = function() {
          var actualName = scope.currentFeatureTypeAttribute.name;
          scope.$watch(
            'currentFeatureTypeAttribute.name',
            function(name) {
              $timeout(function() {
                if (
                  name &&
                  scope.oracleDatabasesNames.indexOf(
                    scope.currentFeatureType.storeName
                  ) !== -1
                ) {
                  scope.currentFeatureTypeAttribute.name = scope.currentFeatureTypeAttribute.name.toUpperCase();
                }
                scope.attributeNameExists =
                  scope.currentFeatureType.attributes
                    .map(function(r) {
                      return r.name;
                    })
                    .indexOf(name) != -1;
                if (
                  !scope.isNewFeatureTypeAttribute &&
                  scope.currentFeatureTypeAttribute.name == actualName
                )
                  scope.attributeNameExists = false;
                scope.validAttributeForm.name =
                  !scope.attributeNameExists && scope.validAttributeFields.name;
              });
            },
            1
          );
        };

        if (scope.fixedNumber)
          scope.$watch('fixedNumber', function(newval) {
            if (
              angular.isDefined(newval) &&
              scope.correction.attributestoadd &&
              scope.correction.attributestoadd.length > newval
            ) {
              var splitnumber =
                scope.correction.attributestoadd.length - newval + 1;
              scope.correction.attributestoadd.splice(newval, splitnumber);
            }
          });

        if (scope.addonlyOne) {
          scope.currentFeatureTypeAttribute = {
            size: 500,
          };
          scope.newattribute = true;
          scope.confirm = function(data) {
            scope.addOneFunc(data);
          };
        }

        scope.existingNames = [];
        var getExistingNames = function() {
          if (
            scope.correction &&
            scope.correction.tableselected &&
            scope.correction.tableselected.uid
          ) {
            scope.existingNames = scope.correction.tableselected.attributes
              .map(function(x) {
                if (
                  scope.currentFeatureTypeAttribute &&
                  scope.currentFeatureTypeAttribute.name &&
                  x.name !== scope.currentFeatureTypeAttribute.name
                )
                  return x.name;
                else {
                  return x.name;
                }
              })
              .filter(function(x) {
                if (x) return x;
              });
          }
        };
        getExistingNames();
      },
    };
  };

  createUpdateAttribute.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'UnitFactory',
    'CalculFactory',
  ];
  return createUpdateAttribute;
});
