'use strict';
define(function() {
  var selectData = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    UnitFactory,
    CalculFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/select_data_hpo.html',
      restrict: 'EA',
      scope: {
        validation: '=',
        ftis: '=',
        ftisdefail: '=',
        modes: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.changed = true;
        scope.changedCorrectionToolOrFti = function() {
          if (scope.validation.fti && scope.validation.fti.name) {
            var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
              scope.validation.fti
            );
            var idx = scope.ftisdefail
              .map(function(x) {
                return x.uid;
              })
              .indexOf(ftidefailuid);
            if (idx !== -1) scope.validation.ftidefail = scope.ftisdefail[idx];
          }
          if (
            scope.validation.fti &&
            scope.validation.mode &&
            scope.validation.mode.id === 'map'
          ) {
            scope.changed = false;
            $timeout(function() {
              scope.changed = true;
            }, 500);
          }
        };

        scope.$watch('validation', function(newval) {
          if (newval) {
            if (scope.validation && scope.validation.mode && scope.modes) {
              var idx = scope.modes
                .map(function(x) {
                  return x.id;
                })
                .indexOf(scope.validation.mode.id);
              if (~idx) scope.validation.mode = scope.modes[idx];
            } else if (
              scope.modes &&
              scope.modes.length === 1 &&
              scope.validation &&
              !scope.validation.mode
            )
              scope.validation.mode = scope.modes[0];

            if (scope.validation && scope.validation.fti && scope.ftis) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.validation.fti.uid);
              if (~idx) scope.validation.fti = scope.ftis[idx];
            }

            if (scope.validation && scope.validation.ftidefail && scope.ftis) {
              var idx = scope.ftisdefail
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.validation.ftidefail.uid);
              if (~idx) scope.validation.ftidefail = scope.ftisdefail[idx];
            }
            scope.changed = false;
            $timeout(function() {
              scope.changed = true;
            }, 500);
          }
        });
      },
    };
  };

  selectData.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'UnitFactory',
    'CalculFactory',
  ];
  return selectData;
});
