'use strict';
define(function() {
  var HpoAppServices = function(
    $http,
    FeatureTypeFactory,
    $filter,
    $rootScope,
    $location,
    InitProvider,
    $timeout,
    $q,
    gaDomUtils
  ) {
    /**
     * [analyseData description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function analyseData(hpoConfig) {
      var deferred = $q.defer();
      var app = '';
      if ($rootScope.xgos && $rootScope.xgos.sector)
        app = $rootScope.xgos.sector;
      var promise = $http.post(
        '/services/{portalid}/hposervices/{appname}/data/prepare/analyse?app=' +
          app,
        hpoConfig
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [addAttribute description]
     * @param {[type]} hpoConfig [description]
     */
    function addAttribute(uid, hpoConfig) {
      var promise = $http.post(
        '/services/{portalid}/hposervices/{appname}/data/add/attribute?uid=' +
          uid,
        hpoConfig
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [createFilter description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function createFilter(hpoConfig) {
      var promise = $http.post(
        '/services/{portalid}/hposervices/{appname}/data/create/filter',
        hpoConfig
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [correctData description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function correctData(hpoConfig) {
      var deferred = $q.defer();
      var app = '';
      if ($rootScope.xgos && $rootScope.xgos.sector)
        app = $rootScope.xgos.sector;
      var promise = $http.post(
        '/services/{portalid}/hposervices/{appname}/data/prepare/correct?app=' +
          app,
        hpoConfig
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [correctData description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function doOrUndoCorrection(uid, obj, action) {
      var deferred = $q.defer();
      var app = '';
      if ($rootScope.xgos && $rootScope.xgos.sector)
        app = $rootScope.xgos.sector;
      var promise = $http.get(
        '/services/{portalid}/hposervices/{appname}/data/prepare/doOrUndo?uid=' +
          uid +
          '&action=' +
          action +
          '&transaction=' +
          obj +
          '&app=' +
          app
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [correctData description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function UndoValidation(uid, obj) {
      var deferred = $q.defer();
      var app = '';
      if ($rootScope.xgos && $rootScope.xgos.sector)
        app = $rootScope.xgos.sector;
      var promise = $http.get(
        '/services/{portalid}/hposervices/{appname}/data/validation/undo?uid=' +
          uid +
          '&transaction=' +
          obj +
          '&app=' +
          app
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }
    function checkLoadDataThread(threadid, deferred, count) {
      var promise = $http.get(
        '/services/{portalid}/hposervices/{appname}/data/prepare/checkDataLoading?f=json' +
          '&threadid=' +
          threadid
      );
      promise.then(
        function(res0) {
          if (res0 && res0.data) {
            var jsRes = res0.data;
             gaDomUtils.setGlobalLoaderScaleBar(jsRes.progress,jsRes.progressMax/jsRes.progressPercentage);
            if (jsRes.alive) {
              // require('toastr').info($filter('translate')('importexportwidget.importing'));
              var delay = 5000;
              if (count < 3) delay = 1000;
              $timeout(function() {
                checkLoadDataThread(threadid, deferred, ++count);
              }, delay);
            } else {
              if (jsRes.status == 400) {
                deferred.resolve({ data: jsRes.error });
              } else {
                deferred.resolve({ data: jsRes.result });
              }
            }
          } else {
            deferred.reject(res0);
          }
        },
        function(res) {
          deferred.reject(res);
        }
      );
    }

    /**
     * [addToDashboard description]
     * @param {[type]} statistic [description]
     */
    function addToDashboard(statistic) {
      var promise = $http.post(
        '/services/{portalid}/hposervices/{appname}/data/add/dashboard',
        statistic
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [addToDashboard description]
     * @param {[type]} statistic [description]
     */
    function updateDashboard(uid, id, statistic) {
      var promise = $http.post(
        '/services/{portalid}/hposervices/{appname}/data/update/dashboard?uid=' +
          uid +
          '&id=' +
          id,
        statistic
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [addToDashboard description]
     * @param {[type]} statistic [description]
     */
    function getDashboards(uid, sendata) {
      var promise = $http.post(
        '/services/{portalid}/hposervices/{appname}/data/get/dashboard?uid=' +
          uid,
        sendata
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [addToDashboard description]
     * @param {[type]} statistic [description]
     */
    function getStats(sendata) {
      var promise = $http.post(
        '/services/{portalid}/hposervices/{appname}/data/stats/dashboard',
        sendata
      );
      promise.then(function(res) {});
      return promise;
    }

    return {
      analyseData: analyseData,
      addAttribute: addAttribute,
      createFilter: createFilter,
      correctData: correctData,
      doOrUndoCorrection: doOrUndoCorrection,
      UndoValidation: UndoValidation,
      addToDashboard: addToDashboard,
      updateDashboard: updateDashboard,
      getDashboards: getDashboards,
      getStats: getStats,
    };
  };
  HpoAppServices.$inject = [
    '$http',
    'FeatureTypeFactory',
    '$filter',
    '$rootScope',
    '$location',
    'InitProvider',
    '$timeout',
    '$q',
    'gaDomUtils'
  ];
  return HpoAppServices;
});
